/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import io.papermc.paper.inventory.recipe.ItemOrExact;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundSetPlayerInventoryPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class Inventory
implements Container,
Nameable {
    public static final int POP_TIME_DURATION = 5;
    public static final int INVENTORY_SIZE = 36;
    public static final int SELECTION_SIZE = 9;
    public static final int SLOT_OFFHAND = 40;
    public static final int NOT_FOUND_INDEX = -1;
    public static final Int2ObjectMap<EquipmentSlot> EQUIPMENT_SLOT_MAPPING = new Int2ObjectArrayMap(Map.of(EquipmentSlot.FEET.getIndex(36), EquipmentSlot.FEET, EquipmentSlot.LEGS.getIndex(36), EquipmentSlot.LEGS, EquipmentSlot.CHEST.getIndex(36), EquipmentSlot.CHEST, EquipmentSlot.HEAD.getIndex(36), EquipmentSlot.HEAD, 40, EquipmentSlot.OFFHAND));
    private final NonNullList<ItemStack> items = NonNullList.withSize(36, ItemStack.EMPTY);
    private int selected;
    public final Player player;
    public final EntityEquipment equipment;
    private int timesChanged;
    public static final EquipmentSlot[] EQUIPMENT_SLOTS_SORTED_BY_INDEX = (EquipmentSlot[])EQUIPMENT_SLOT_MAPPING.int2ObjectEntrySet().stream().sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).map(Map.Entry::getValue).toArray(EquipmentSlot[]::new);
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        ArrayList<ItemStack> combined = new ArrayList<ItemStack>(this.items.size() + EQUIPMENT_SLOT_MAPPING.size());
        combined.addAll(this.items);
        for (EquipmentSlot equipmentSlot : EQUIPMENT_SLOTS_SORTED_BY_INDEX) {
            ItemStack itemStack = this.equipment.get(equipmentSlot);
            combined.add(itemStack);
        }
        return combined;
    }

    public List<ItemStack> getArmorContents() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (EquipmentSlot equipmentSlot : EQUIPMENT_SLOTS_SORTED_BY_INDEX) {
            if (!equipmentSlot.isArmor()) continue;
            items.add(this.equipment.get(equipmentSlot));
        }
        return items;
    }

    @Override
    public void onOpen(CraftHumanEntity player) {
        this.transaction.add(player);
    }

    @Override
    public void onClose(CraftHumanEntity player) {
        this.transaction.remove(player);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.player.getBukkitEntity();
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        return this.player.getBukkitEntity().getLocation();
    }

    public Inventory(Player player, EntityEquipment equipment) {
        this.player = player;
        this.equipment = equipment;
    }

    public int getSelectedSlot() {
        return this.selected;
    }

    public void setSelectedSlot(int slot) {
        if (!Inventory.isHotbarSlot(slot)) {
            throw new IllegalArgumentException("Invalid selected slot");
        }
        this.selected = slot;
    }

    public ItemStack getSelectedItem() {
        return this.items.get(this.selected);
    }

    public ItemStack setSelectedItem(ItemStack stack) {
        return this.items.set(this.selected, stack);
    }

    public static int getSelectionSize() {
        return 9;
    }

    public NonNullList<ItemStack> getNonEquipmentItems() {
        return this.items;
    }

    private boolean hasRemainingSpaceForItem(ItemStack destination, ItemStack origin) {
        return !destination.isEmpty() && destination.isStackable() && destination.getCount() < this.getMaxStackSize(destination) && ItemStack.isSameItemSameComponents(destination, origin);
    }

    public int canHold(ItemStack itemStack) {
        int remains = itemStack.getCount();
        for (int slot = 0; slot < this.items.size(); ++slot) {
            ItemStack itemInSlot = this.getItem(slot);
            if (itemInSlot.isEmpty()) {
                return itemStack.getCount();
            }
            if (this.hasRemainingSpaceForItem(itemInSlot, itemStack)) {
                remains -= (itemInSlot.getMaxStackSize() < this.getMaxStackSize() ? itemInSlot.getMaxStackSize() : this.getMaxStackSize()) - itemInSlot.getCount();
            }
            if (remains > 0) continue;
            return itemStack.getCount();
        }
        ItemStack itemInOffhand = this.equipment.get(EquipmentSlot.OFFHAND);
        if (this.hasRemainingSpaceForItem(itemInOffhand, itemStack)) {
            remains -= (itemInOffhand.getMaxStackSize() < this.getMaxStackSize() ? itemInOffhand.getMaxStackSize() : this.getMaxStackSize()) - itemInOffhand.getCount();
        }
        if (remains <= 0) {
            return itemStack.getCount();
        }
        return itemStack.getCount() - remains;
    }

    public int getFreeSlot() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public void addAndPickItem(ItemStack stack, int targetSlot) {
        int freeSlot;
        this.setSelectedSlot(targetSlot);
        if (!this.items.get(this.selected).isEmpty() && (freeSlot = this.getFreeSlot()) != -1) {
            this.items.set(freeSlot, this.items.get(this.selected));
        }
        this.items.set(this.selected, stack);
    }

    public void pickSlot(int index, int targetSlot) {
        this.setSelectedSlot(targetSlot);
        ItemStack itemStack = this.items.get(this.selected);
        this.items.set(this.selected, this.items.get(index));
        this.items.set(index, itemStack);
    }

    public static boolean isHotbarSlot(int index) {
        return index >= 0 && index < 9;
    }

    public int findSlotMatchingItem(ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i).isEmpty() || !ItemStack.isSameItemSameComponents(stack, this.items.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isUsableForCrafting(ItemStack stack) {
        return !stack.isDamaged() && !stack.isEnchanted() && !stack.has(DataComponents.CUSTOM_NAME);
    }

    public int findSlotMatchingCraftingIngredient(ItemOrExact item, ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = this.items.get(i);
            if (itemStack.isEmpty() || !item.matches(itemStack) || item instanceof ItemOrExact.Item && !Inventory.isUsableForCrafting(itemStack) || !stack.isEmpty() && !ItemStack.isSameItemSameComponents(stack, itemStack)) continue;
            return i;
        }
        return -1;
    }

    public int getSuitableHotbarSlot() {
        int i1;
        for (int i = 0; i < 9; ++i) {
            i1 = (this.selected + i) % 9;
            if (!this.items.get(i1).isEmpty()) continue;
            return i1;
        }
        for (int ix = 0; ix < 9; ++ix) {
            i1 = (this.selected + ix) % 9;
            if (this.items.get(i1).isEnchanted()) continue;
            return i1;
        }
        return this.selected;
    }

    public int clearOrCountMatchingItems(Predicate<ItemStack> stackPredicate, int maxCount, Container inventory) {
        int i = 0;
        boolean flag = maxCount == 0;
        i += ContainerHelper.clearOrCountMatchingItems(this, stackPredicate, maxCount - i, flag);
        i += ContainerHelper.clearOrCountMatchingItems(inventory, stackPredicate, maxCount - i, flag);
        ItemStack carried = this.player.containerMenu.getCarried();
        i += ContainerHelper.clearOrCountMatchingItems(carried, stackPredicate, maxCount - i, flag);
        if (carried.isEmpty()) {
            this.player.containerMenu.setCarried(ItemStack.EMPTY);
        }
        return i;
    }

    private int addResource(ItemStack stack) {
        int slotWithRemainingSpace = this.getSlotWithRemainingSpace(stack);
        if (slotWithRemainingSpace == -1) {
            slotWithRemainingSpace = this.getFreeSlot();
        }
        return slotWithRemainingSpace == -1 ? stack.getCount() : this.addResource(slotWithRemainingSpace, stack);
    }

    private int addResource(int slot, ItemStack stack) {
        int i;
        int min;
        int count = stack.getCount();
        ItemStack item = this.getItem(slot);
        if (item.isEmpty()) {
            item = stack.copyWithCount(0);
            this.setItem(slot, item);
        }
        if ((min = Math.min(count, i = this.getMaxStackSize(item) - item.getCount())) == 0) {
            return count;
        }
        item.grow(min);
        item.setPopTime(5);
        return count -= min;
    }

    public int getSlotWithRemainingSpace(ItemStack stack) {
        if (this.hasRemainingSpaceForItem(this.getItem(this.selected), stack)) {
            return this.selected;
        }
        if (this.hasRemainingSpaceForItem(this.getItem(40), stack)) {
            return 40;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.hasRemainingSpaceForItem(this.items.get(i), stack)) continue;
            return i;
        }
        return -1;
    }

    public void tick() {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack item = this.getItem(i);
            if (item.isEmpty()) continue;
            item.inventoryTick(this.player.level(), this.player, i == this.selected ? EquipmentSlot.MAINHAND : null);
        }
    }

    public boolean add(ItemStack stack) {
        return this.add(-1, stack);
    }

    public boolean add(int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        try {
            int count;
            if (stack.isDamaged()) {
                if (slot == -1) {
                    slot = this.getFreeSlot();
                }
                if (slot >= 0) {
                    this.items.set(slot, stack.copyAndClear());
                    this.items.get(slot).setPopTime(5);
                    return true;
                }
                if (this.player.hasInfiniteMaterials()) {
                    stack.setCount(0);
                    return true;
                }
                return false;
            }
            do {
                count = stack.getCount();
                if (slot == -1) {
                    stack.setCount(this.addResource(stack));
                    continue;
                }
                stack.setCount(this.addResource(slot, stack));
            } while (!stack.isEmpty() && stack.getCount() < count);
            if (stack.getCount() == count && this.player.hasInfiniteMaterials()) {
                stack.setCount(0);
                return true;
            }
            return stack.getCount() < count;
        }
        catch (Throwable var6) {
            CrashReport crashReport = CrashReport.forThrowable(var6, "Adding item to inventory");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Item being added");
            crashReportCategory.setDetail("Item ID", Item.getId(stack.getItem()));
            crashReportCategory.setDetail("Item data", stack.getDamageValue());
            crashReportCategory.setDetail("Item name", () -> stack.getHoverName().getString());
            throw new ReportedException(crashReport);
        }
    }

    public void placeItemBackInInventory(ItemStack stack) {
        this.placeItemBackInInventory(stack, true);
    }

    public void placeItemBackInInventory(ItemStack stack, boolean sendPacket) {
        while (!stack.isEmpty()) {
            Player player;
            int slotWithRemainingSpace = this.getSlotWithRemainingSpace(stack);
            if (slotWithRemainingSpace == -1) {
                slotWithRemainingSpace = this.getFreeSlot();
            }
            if (slotWithRemainingSpace == -1) {
                this.player.drop(stack, false);
                break;
            }
            int i = stack.getMaxStackSize() - this.getItem(slotWithRemainingSpace).getCount();
            if (!this.add(slotWithRemainingSpace, stack.split(i)) || !sendPacket || !((player = this.player) instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send(this.createInventoryUpdatePacket(slotWithRemainingSpace));
        }
    }

    public ClientboundSetPlayerInventoryPacket createInventoryUpdatePacket(int slot) {
        return new ClientboundSetPlayerInventoryPacket(slot, this.getItem(slot).copy());
    }

    @Override
    public ItemStack removeItem(int index, int count) {
        ItemStack itemStack;
        if (index < this.items.size()) {
            return ContainerHelper.removeItem(this.items, index, count);
        }
        EquipmentSlot equipmentSlot = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(index);
        if (equipmentSlot != null && !(itemStack = this.equipment.get(equipmentSlot)).isEmpty()) {
            return itemStack.split(count);
        }
        return ItemStack.EMPTY;
    }

    public void removeItem(ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) != stack) continue;
            this.items.set(i, ItemStack.EMPTY);
            return;
        }
        for (EquipmentSlot equipmentSlot : EQUIPMENT_SLOT_MAPPING.values()) {
            ItemStack itemStack = this.equipment.get(equipmentSlot);
            if (itemStack != stack) continue;
            this.equipment.set(equipmentSlot, ItemStack.EMPTY);
            return;
        }
    }

    @Override
    public ItemStack removeItemNoUpdate(int index) {
        if (index < this.items.size()) {
            ItemStack itemStack = this.items.get(index);
            this.items.set(index, ItemStack.EMPTY);
            return itemStack;
        }
        EquipmentSlot equipmentSlot = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(index);
        return equipmentSlot != null ? this.equipment.set(equipmentSlot, ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    @Override
    public void setItem(int index, ItemStack stack) {
        EquipmentSlot equipmentSlot;
        if (index < this.items.size()) {
            this.items.set(index, stack);
        }
        if ((equipmentSlot = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(index)) != null) {
            this.equipment.set(equipmentSlot, stack);
        }
    }

    public ListTag save(ListTag listTag) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i).isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)i);
            listTag.add(this.items.get(i).save(this.player.registryAccess(), compoundTag));
        }
        return listTag;
    }

    public void load(ListTag listTag) {
        this.items.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundOrEmpty = listTag.getCompoundOrEmpty(i);
            int i1 = compoundOrEmpty.getByteOr("Slot", (byte)0) & 0xFF;
            ItemStack itemStack = ItemStack.parse(this.player.registryAccess(), compoundOrEmpty).orElse(ItemStack.EMPTY);
            if (i1 >= this.items.size()) continue;
            this.setItem(i1, itemStack);
        }
    }

    @Override
    public int getContainerSize() {
        return this.items.size() + EQUIPMENT_SLOT_MAPPING.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        for (EquipmentSlot equipmentSlot : EQUIPMENT_SLOT_MAPPING.values()) {
            if (this.equipment.get(equipmentSlot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int index) {
        if (index < this.items.size()) {
            return this.items.get(index);
        }
        EquipmentSlot equipmentSlot = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(index);
        return equipmentSlot != null ? this.equipment.get(equipmentSlot) : ItemStack.EMPTY;
    }

    @Override
    public Component getName() {
        return Component.translatable("container.inventory");
    }

    public void dropAll() {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = this.items.get(i);
            if (itemStack.isEmpty()) continue;
            this.player.drop(itemStack, true, false);
            this.items.set(i, ItemStack.EMPTY);
        }
        this.equipment.dropAll(this.player);
    }

    @Override
    public void setChanged() {
        ++this.timesChanged;
    }

    public int getTimesChanged() {
        return this.timesChanged;
    }

    @Override
    public boolean stillValid(Player player) {
        return true;
    }

    public boolean contains(ItemStack stack) {
        for (ItemStack itemStack : this) {
            if (itemStack.isEmpty() || !ItemStack.isSameItemSameComponents(itemStack, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(TagKey<Item> tag) {
        for (ItemStack itemStack : this) {
            if (itemStack.isEmpty() || !itemStack.is(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Predicate<ItemStack> predicate) {
        for (ItemStack itemStack : this) {
            if (!predicate.test(itemStack)) continue;
            return true;
        }
        return false;
    }

    public void replaceWith(Inventory playerInventory) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, playerInventory.getItem(i));
        }
        this.setSelectedSlot(playerInventory.getSelectedSlot());
    }

    @Override
    public void clearContent() {
        this.items.clear();
        this.equipment.clear();
    }

    public void fillStackedContents(StackedItemContents contents) {
        for (ItemStack itemStack : this.items) {
            contents.accountSimpleStack(itemStack);
        }
    }

    public ItemStack removeFromSelected(boolean removeStack) {
        ItemStack selectedItem = this.getSelectedItem();
        return selectedItem.isEmpty() ? ItemStack.EMPTY : this.removeItem(this.selected, removeStack ? selectedItem.getCount() : 1);
    }
}

