/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.annotation.DoNotUse;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.PublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ThrowingComponent;
import net.minecraft.util.Crypt;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureValidator;
import org.bukkit.event.player.PlayerKickEvent;

public record ProfilePublicKey(Data data) {
    public static final Component EXPIRED_PROFILE_PUBLIC_KEY = Component.translatable("multiplayer.disconnect.expired_public_key");
    private static final Component INVALID_SIGNATURE = Component.translatable("multiplayer.disconnect.invalid_public_key_signature");
    public static final Duration EXPIRY_GRACE_PERIOD = Duration.ofHours(8L);
    public static final Codec<ProfilePublicKey> TRUSTED_CODEC = Data.CODEC.xmap(ProfilePublicKey::new, ProfilePublicKey::data);

    public static ProfilePublicKey createValidated(SignatureValidator signatureValidator, UUID profileId, Data data) throws ValidationException {
        if (!data.validateSignature(signatureValidator, profileId)) {
            throw new ValidationException(INVALID_SIGNATURE, PlayerKickEvent.Cause.INVALID_PUBLIC_KEY_SIGNATURE);
        }
        return new ProfilePublicKey(data);
    }

    public SignatureValidator createSignatureValidator() {
        return SignatureValidator.from(this.data.key, "SHA256withRSA");
    }

    public record Data(Instant expiresAt, PublicKey key, byte[] keySignature) {
        private static final int MAX_KEY_SIGNATURE_SIZE = 4096;
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.INSTANT_ISO8601.fieldOf("expires_at").forGetter(Data::expiresAt), (App)Crypt.PUBLIC_KEY_CODEC.fieldOf("key").forGetter(Data::key), (App)ExtraCodecs.BASE64_STRING.fieldOf("signature_v2").forGetter(Data::keySignature)).apply((Applicative)instance, Data::new));

        public Data(FriendlyByteBuf buffer) {
            this(buffer.readInstant(), buffer.readPublicKey(), buffer.readByteArray(4096));
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeInstant(this.expiresAt);
            buffer.writePublicKey(this.key);
            buffer.writeByteArray(this.keySignature);
        }

        boolean validateSignature(SignatureValidator signatureValidator, UUID profileId) {
            return signatureValidator.validate(this.signedPayload(profileId), this.keySignature);
        }

        private byte[] signedPayload(UUID profileId) {
            byte[] encoded = this.key.getEncoded();
            byte[] bytes = new byte[24 + encoded.length];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
            byteBuffer.putLong(profileId.getMostSignificantBits()).putLong(profileId.getLeastSignificantBits()).putLong(this.expiresAt.toEpochMilli()).put(encoded);
            return bytes;
        }

        public boolean hasExpired() {
            return this.expiresAt.isBefore(Instant.now());
        }

        public boolean hasExpired(Duration gracePeriod) {
            return this.expiresAt.plus(gracePeriod).isBefore(Instant.now());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Data)) return false;
            Data data = (Data)other;
            if (!this.expiresAt.equals(data.expiresAt)) return false;
            if (!this.key.equals(data.key)) return false;
            if (!Arrays.equals(this.keySignature, data.keySignature)) return false;
            return true;
        }
    }

    public static class ValidationException
    extends ThrowingComponent {
        public final PlayerKickEvent.Cause kickCause;

        @Deprecated
        @DoNotUse
        public ValidationException(Component component) {
            this(component, PlayerKickEvent.Cause.UNKNOWN);
        }

        public ValidationException(Component component, PlayerKickEvent.Cause kickCause) {
            super(component);
            this.kickCause = kickCause;
        }
    }
}

