/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import io.papermc.paper.event.entity.WaterBottleSplashEvent;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public abstract class AbstractThrownPotion
extends ThrowableItemProjectile {
    public static final double SPLASH_RANGE = 4.0;
    protected static final double SPLASH_RANGE_SQ = 16.0;
    public static final Predicate<LivingEntity> WATER_SENSITIVE_OR_ON_FIRE = livingEntity -> livingEntity.isSensitiveToWater() || livingEntity.isOnFire();
    private static final Predicate<LivingEntity> APPLY_WATER_GET_ENTITIES_PREDICATE = WATER_SENSITIVE_OR_ON_FIRE.or(Axolotl.class::isInstance);

    public AbstractThrownPotion(EntityType<? extends AbstractThrownPotion> entityType, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)entityType, level);
    }

    public AbstractThrownPotion(EntityType<? extends AbstractThrownPotion> entityType, Level level, LivingEntity owner, ItemStack item) {
        super(entityType, owner, level, item);
    }

    public AbstractThrownPotion(EntityType<? extends AbstractThrownPotion> entityType, Level level, double x, double y, double z, ItemStack item) {
        super(entityType, x, y, z, level, item);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    @Override
    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            ItemStack item = this.getItem();
            Direction direction = result.getDirection();
            BlockPos blockPos = result.getBlockPos();
            BlockPos blockPos1 = blockPos.relative(direction);
            PotionContents potionContents = item.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
            if (potionContents.is(Potions.WATER)) {
                this.dowseFire(blockPos1);
                this.dowseFire(blockPos1.relative(direction.getOpposite()));
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    this.dowseFire(blockPos1.relative(direction1));
                }
            }
        }
    }

    @Override
    protected void onHit(HitResult result) {
        super.onHit(result);
        this.splash(result);
    }

    public void splash(@Nullable HitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack item = this.getItem();
            PotionContents potionContents = item.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
            boolean showParticles = true;
            showParticles = potionContents.is(Potions.WATER) ? this.onHitAsWater(serverLevel, result) : this.onHitAsPotion(serverLevel, item, result != null && result.getType() == HitResult.Type.ENTITY ? ((EntityHitResult)result).getEntity() : null, result);
            if (showParticles) {
                int i = potionContents.potion().isPresent() && potionContents.potion().get().value().hasInstantEffects() ? 2007 : 2002;
                serverLevel.levelEvent(i, this.blockPosition(), potionContents.getColor());
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    private boolean onHitAsWater(ServerLevel level, @Nullable HitResult result) {
        AABB aabb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        HashMap<org.bukkit.entity.LivingEntity, Double> affected = new HashMap<org.bukkit.entity.LivingEntity, Double>();
        HashSet<org.bukkit.entity.LivingEntity> rehydrate = new HashSet<org.bukkit.entity.LivingEntity>();
        HashSet<org.bukkit.entity.LivingEntity> extinguish = new HashSet<org.bukkit.entity.LivingEntity>();
        for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, aabb, APPLY_WATER_GET_ENTITIES_PREDICATE)) {
            double d;
            if (livingEntity instanceof Axolotl) {
                Axolotl axolotl = (Axolotl)livingEntity;
                rehydrate.add((org.bukkit.entity.LivingEntity)((org.bukkit.entity.Axolotl)axolotl.getBukkitEntity()));
            }
            if (!((d = this.distanceToSqr(livingEntity)) < 16.0)) continue;
            if (livingEntity.isSensitiveToWater()) {
                affected.put(livingEntity.getBukkitLivingEntity(), 1.0);
            }
            if (!livingEntity.isOnFire() || !livingEntity.isAlive()) continue;
            extinguish.add(livingEntity.getBukkitLivingEntity());
        }
        WaterBottleSplashEvent event = CraftEventFactory.callWaterBottleSplashEvent(this, result, affected, rehydrate, extinguish);
        if (!event.isCancelled()) {
            for (org.bukkit.entity.LivingEntity affectedEntity : event.getToDamage()) {
                ((CraftLivingEntity)affectedEntity).getHandle().hurtServer(level, this.damageSources().indirectMagic(this, this.getOwner()), 1.0f);
            }
            for (org.bukkit.entity.LivingEntity toExtinguish : event.getToExtinguish()) {
                ((CraftLivingEntity)toExtinguish).getHandle().extinguishFire();
            }
            for (org.bukkit.entity.LivingEntity toRehydrate : event.getToRehydrate()) {
                LivingEntity livingEntity = ((CraftLivingEntity)toRehydrate).getHandle();
                if (!(livingEntity instanceof Axolotl)) continue;
                Axolotl axolotl = (Axolotl)livingEntity;
                axolotl.rehydrate();
            }
        }
        return !event.isCancelled();
    }

    protected abstract boolean onHitAsPotion(ServerLevel var1, ItemStack var2, @Nullable Entity var3, @Nullable HitResult var4);

    private void dowseFire(BlockPos pos) {
        BlockState blockState = this.level().getBlockState(pos);
        if (blockState.is(BlockTags.FIRE)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, pos, blockState.getFluidState().createLegacyBlock())) {
                this.level().destroyBlock(pos, false, this);
            }
        } else if (AbstractCandleBlock.isLit(blockState)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, pos, (BlockState)blockState.setValue(AbstractCandleBlock.LIT, false))) {
                AbstractCandleBlock.extinguish(null, blockState, this.level(), pos);
            }
        } else if (CampfireBlock.isLitCampfire(blockState) && CraftEventFactory.callEntityChangeBlockEvent(this, pos, (BlockState)blockState.setValue(CampfireBlock.LIT, false))) {
            this.level().levelEvent(null, 1009, pos, 0);
            CampfireBlock.dowse(this.getOwner(), this.level(), pos, blockState);
            this.level().setBlockAndUpdate(pos, (BlockState)blockState.setValue(CampfireBlock.LIT, false));
        }
    }

    @Override
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(LivingEntity entity, DamageSource damageSource) {
        double d = entity.position().x - this.position().x;
        double d1 = entity.position().z - this.position().z;
        return DoubleDoubleImmutablePair.of((double)d, (double)d1);
    }
}

