/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class Raids
extends SavedData {
    private static final String RAID_FILE_ID = "raids";
    public static final Codec<Raids> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RaidWithId.CODEC.listOf().optionalFieldOf(RAID_FILE_ID, List.of()).forGetter(raids -> raids.raidMap.int2ObjectEntrySet().stream().map(RaidWithId::from).toList()), (App)Codec.INT.fieldOf("next_id").forGetter(raids -> raids.nextId), (App)Codec.INT.fieldOf("tick").forGetter(raids -> raids.tick)).apply((Applicative)instance, Raids::new));
    public static final SavedDataType<Raids> TYPE = new SavedDataType<Raids>("raids", Raids::new, CODEC, DataFixTypes.SAVED_DATA_RAIDS);
    public static final SavedDataType<Raids> TYPE_END = new SavedDataType<Raids>("raids_end", Raids::new, CODEC, DataFixTypes.SAVED_DATA_RAIDS);
    public final Int2ObjectMap<Raid> raidMap = new Int2ObjectOpenHashMap();
    private int nextId = 1;
    private int tick;

    public static SavedDataType<Raids> getType(Holder<DimensionType> dimension) {
        return dimension.is(BuiltinDimensionTypes.END) ? TYPE_END : TYPE;
    }

    public Raids() {
        this.setDirty();
    }

    private Raids(List<RaidWithId> raids, int nextId, int tick) {
        for (RaidWithId raidWithId : raids) {
            this.raidMap.put(raidWithId.id, (Object)raidWithId.raid);
            raidWithId.raid.idOrNegativeOne = raidWithId.id;
        }
        this.nextId = nextId;
        this.tick = tick;
    }

    @Nullable
    public Raid get(int id) {
        return (Raid)this.raidMap.get(id);
    }

    public OptionalInt getId(Raid raid) {
        for (Int2ObjectMap.Entry entry : this.raidMap.int2ObjectEntrySet()) {
            if (entry.getValue() != raid) continue;
            return OptionalInt.of(entry.getIntKey());
        }
        return OptionalInt.empty();
    }

    public void tick(ServerLevel level) {
        ++this.tick;
        ObjectIterator iterator = this.raidMap.values().iterator();
        while (iterator.hasNext()) {
            Raid raid = (Raid)iterator.next();
            if (level.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
                raid.stop();
            }
            if (raid.isStopped()) {
                iterator.remove();
                this.setDirty();
                continue;
            }
            raid.tick(level);
        }
        if (this.tick % 200 == 0) {
            this.setDirty();
        }
        DebugPackets.sendRaids(level, (Collection<Raid>)this.raidMap.values());
    }

    public static boolean canJoinRaid(Raider raider) {
        return raider.isAlive() && raider.canJoinRaid() && raider.getNoActionTime() <= 2400;
    }

    @Nullable
    public Raid createOrExtendRaid(ServerPlayer player, BlockPos pos) {
        BlockPos blockPos;
        if (player.isSpectator()) {
            return null;
        }
        ServerLevel serverLevel = player.serverLevel();
        if (serverLevel.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
            return null;
        }
        DimensionType dimensionType = serverLevel.dimensionType();
        if (!dimensionType.hasRaids()) {
            return null;
        }
        List<PoiRecord> list = serverLevel.getPoiManager().getInRange(holder -> holder.is(PoiTypeTags.VILLAGE), pos, 64, PoiManager.Occupancy.IS_OCCUPIED).toList();
        int i = 0;
        Vec3 vec3 = Vec3.ZERO;
        for (PoiRecord poiRecord : list) {
            BlockPos pos1 = poiRecord.getPos();
            vec3 = vec3.add(pos1.getX(), pos1.getY(), pos1.getZ());
            ++i;
        }
        if (i > 0) {
            vec3 = vec3.scale(1.0 / (double)i);
            blockPos = BlockPos.containing(vec3);
        } else {
            blockPos = pos;
        }
        Raid raid = this.getOrCreateRaid(serverLevel, blockPos);
        if (!raid.isStarted() || raid.isInProgress() && raid.getRaidOmenLevel() < raid.getMaxRaidOmenLevel()) {
            if (!CraftEventFactory.callRaidTriggerEvent(serverLevel, raid, player)) {
                player.removeEffect(MobEffects.RAID_OMEN);
                return null;
            }
            if (!raid.isStarted() && !this.raidMap.containsValue((Object)raid)) {
                this.raidMap.put(this.getUniqueId(), (Object)raid);
                raid.idOrNegativeOne = this.nextId;
            }
            raid.absorbRaidOmen(player);
        }
        this.setDirty();
        return raid;
    }

    private Raid getOrCreateRaid(ServerLevel serverLevel, BlockPos pos) {
        Raid raidAt = serverLevel.getRaidAt(pos);
        return raidAt != null ? raidAt : new Raid(pos, serverLevel.getDifficulty());
    }

    public static Raids load(CompoundTag tag) {
        return CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial().orElseGet(Raids::new);
    }

    private int getUniqueId() {
        return ++this.nextId;
    }

    @Nullable
    public Raid getNearbyRaid(BlockPos pos, int distance) {
        Raid raid = null;
        double d = distance;
        for (Raid raid1 : this.raidMap.values()) {
            double d1 = raid1.getCenter().distSqr(pos);
            if (!raid1.isActive() || !(d1 < d)) continue;
            raid = raid1;
            d = d1;
        }
        return raid;
    }

    record RaidWithId(int id, Raid raid) {
        public static final Codec<RaidWithId> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(RaidWithId::id), (App)Raid.MAP_CODEC.forGetter(RaidWithId::raid)).apply((Applicative)instance, RaidWithId::new));

        public static RaidWithId from(Int2ObjectMap.Entry<Raid> entry) {
            return new RaidWithId(entry.getIntKey(), (Raid)entry.getValue());
        }
    }
}

