/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.variant;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class VariantUtils {
    public static final String TAG_VARIANT = "variant";

    public static <T> Holder<T> getDefaultOrAny(RegistryAccess registryAccess, ResourceKey<T> key) {
        HolderLookup.RegistryLookup registry = registryAccess.lookupOrThrow(key.registryKey());
        return (Holder)registry.get(key).or(((Registry)registry)::getAny).orElseThrow();
    }

    public static <T> Holder<T> getAny(RegistryAccess registryAccess, ResourceKey<? extends Registry<T>> registryKey) {
        return registryAccess.lookupOrThrow(registryKey).getAny().orElseThrow();
    }

    public static <T> void writeVariant(CompoundTag tag, Holder<T> variant) {
        variant.unwrapKey().ifPresent(resourceKey -> tag.store(TAG_VARIANT, ResourceLocation.CODEC, resourceKey.location()));
    }

    public static <T> Optional<Holder<T>> readVariant(CompoundTag tag, RegistryAccess registryAccess, ResourceKey<? extends Registry<T>> registryKey) {
        return tag.read(TAG_VARIANT, ResourceLocation.CODEC).map(resourceLocation -> ResourceKey.create(registryKey, resourceLocation)).flatMap(registryAccess::get);
    }
}

