/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.mojang.datafixers.util.Pair;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;

public class NewMinecartBehavior
extends MinecartBehavior {
    public static final int POS_ROT_LERP_TICKS = 3;
    public static final double ON_RAIL_Y_OFFSET = 0.1;
    public static final double OPPOSING_SLOPES_REST_AT_SPEED_THRESHOLD = 0.005;
    @Nullable
    private StepPartialTicks cacheIndexAlpha;
    private int cachedLerpDelay;
    private float cachedPartialTick;
    private int lerpDelay = 0;
    public final List<MinecartStep> lerpSteps = new LinkedList<MinecartStep>();
    public final List<MinecartStep> currentLerpSteps = new LinkedList<MinecartStep>();
    public double currentLerpStepsTotalWeight = 0.0;
    public MinecartStep oldLerp = MinecartStep.ZERO;

    public NewMinecartBehavior(AbstractMinecart minecart) {
        super(minecart);
    }

    @Override
    public void tick() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos var5 = this.minecart.getCurrentBlockPosOrRailBelow();
            BlockState blockState = this.level().getBlockState(var5);
            if (this.minecart.isFirstTick()) {
                this.minecart.setOnRails(BaseRailBlock.isRail(blockState));
                this.adjustToRails(var5, blockState, true);
            }
            this.minecart.applyGravity();
            this.minecart.moveAlongTrack(serverLevel);
        } else {
            this.lerpClientPositionAndRotation();
            boolean isRail = BaseRailBlock.isRail(this.level().getBlockState(this.minecart.getCurrentBlockPosOrRailBelow()));
            this.minecart.setOnRails(isRail);
        }
    }

    private void lerpClientPositionAndRotation() {
        if (--this.lerpDelay <= 0) {
            this.setOldLerpValues();
            this.currentLerpSteps.clear();
            if (!this.lerpSteps.isEmpty()) {
                this.currentLerpSteps.addAll(this.lerpSteps);
                this.lerpSteps.clear();
                this.currentLerpStepsTotalWeight = 0.0;
                for (MinecartStep minecartStep : this.currentLerpSteps) {
                    this.currentLerpStepsTotalWeight += (double)minecartStep.weight;
                }
                int n = this.lerpDelay = this.currentLerpStepsTotalWeight == 0.0 ? 0 : 3;
            }
        }
        if (this.cartHasPosRotLerp()) {
            this.setPos(this.getCartLerpPosition(1.0f));
            this.setDeltaMovement(this.getCartLerpMovements(1.0f));
            this.setXRot(this.getCartLerpXRot(1.0f));
            this.setYRot(this.getCartLerpYRot(1.0f));
        }
    }

    public void setOldLerpValues() {
        this.oldLerp = new MinecartStep(this.position(), this.getDeltaMovement(), this.getYRot(), this.getXRot(), 0.0f);
    }

    public boolean cartHasPosRotLerp() {
        return !this.currentLerpSteps.isEmpty();
    }

    public float getCartLerpXRot(float partialTick) {
        StepPartialTicks currentLerpStep = this.getCurrentLerpStep(partialTick);
        return Mth.rotLerp(currentLerpStep.partialTicksInStep, currentLerpStep.previousStep.xRot, currentLerpStep.currentStep.xRot);
    }

    public float getCartLerpYRot(float partialTick) {
        StepPartialTicks currentLerpStep = this.getCurrentLerpStep(partialTick);
        return Mth.rotLerp(currentLerpStep.partialTicksInStep, currentLerpStep.previousStep.yRot, currentLerpStep.currentStep.yRot);
    }

    public Vec3 getCartLerpPosition(float partialTick) {
        StepPartialTicks currentLerpStep = this.getCurrentLerpStep(partialTick);
        return Mth.lerp((double)currentLerpStep.partialTicksInStep, currentLerpStep.previousStep.position, currentLerpStep.currentStep.position);
    }

    public Vec3 getCartLerpMovements(float partialTick) {
        StepPartialTicks currentLerpStep = this.getCurrentLerpStep(partialTick);
        return Mth.lerp((double)currentLerpStep.partialTicksInStep, currentLerpStep.previousStep.movement, currentLerpStep.currentStep.movement);
    }

    private StepPartialTicks getCurrentLerpStep(float partialTick) {
        int i;
        if (partialTick == this.cachedPartialTick && this.lerpDelay == this.cachedLerpDelay && this.cacheIndexAlpha != null) {
            return this.cacheIndexAlpha;
        }
        float f = ((float)(3 - this.lerpDelay) + partialTick) / 3.0f;
        float f1 = 0.0f;
        float f2 = 1.0f;
        boolean flag = false;
        for (i = 0; i < this.currentLerpSteps.size(); ++i) {
            float f3 = this.currentLerpSteps.get((int)i).weight;
            if (f3 <= 0.0f || !((double)(f1 += f3) >= this.currentLerpStepsTotalWeight * (double)f)) continue;
            float f4 = f1 - f3;
            f2 = (float)(((double)f * this.currentLerpStepsTotalWeight - (double)f4) / (double)f3);
            flag = true;
            break;
        }
        if (!flag) {
            i = this.currentLerpSteps.size() - 1;
        }
        MinecartStep minecartStep = this.currentLerpSteps.get(i);
        MinecartStep minecartStep1 = i > 0 ? this.currentLerpSteps.get(i - 1) : this.oldLerp;
        this.cacheIndexAlpha = new StepPartialTicks(f2, minecartStep, minecartStep1);
        this.cachedLerpDelay = this.lerpDelay;
        this.cachedPartialTick = partialTick;
        return this.cacheIndexAlpha;
    }

    public void adjustToRails(BlockPos pos, BlockState state, boolean snapToStart) {
        if (BaseRailBlock.isRail(state)) {
            boolean flag3;
            Vec3 vec39;
            Vec3 vec36;
            boolean flag;
            RailShape railShape = state.getValue(((BaseRailBlock)state.getBlock()).getShapeProperty());
            Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(railShape);
            Vec3 vec3 = new Vec3((Vec3i)pair.getFirst()).scale(0.5);
            Vec3 vec31 = new Vec3((Vec3i)pair.getSecond()).scale(0.5);
            Vec3 vec32 = vec3.horizontal();
            Vec3 vec33 = vec31.horizontal();
            if (this.getDeltaMovement().length() > (double)1.0E-5f && this.getDeltaMovement().dot(vec32) < this.getDeltaMovement().dot(vec33) || this.isDecending(vec33, railShape)) {
                Vec3 vec34 = vec32;
                vec32 = vec33;
                vec33 = vec34;
            }
            float f = 180.0f - (float)(Math.atan2(vec32.z, vec32.x) * 180.0 / Math.PI);
            f += this.minecart.isFlipped() ? 180.0f : 0.0f;
            Vec3 vec35 = this.position();
            boolean bl = flag = vec3.x() != vec31.x() && vec3.z() != vec31.z();
            if (flag) {
                vec36 = vec31.subtract(vec3);
                Vec3 vec37 = vec35.subtract(pos.getBottomCenter()).subtract(vec3);
                Vec3 vec38 = vec36.scale(vec36.dot(vec37) / vec36.dot(vec36));
                vec39 = pos.getBottomCenter().add(vec3).add(vec38);
                f = 180.0f - (float)(Math.atan2(vec38.z, vec38.x) * 180.0 / Math.PI);
                f += this.minecart.isFlipped() ? 180.0f : 0.0f;
            } else {
                boolean flag1 = vec3.subtract((Vec3)vec31).x != 0.0;
                boolean flag2 = vec3.subtract((Vec3)vec31).z != 0.0;
                vec39 = new Vec3(flag2 ? pos.getCenter().x : vec35.x, pos.getY(), flag1 ? pos.getCenter().z : vec35.z);
            }
            vec36 = vec39.subtract(vec35);
            this.setPos(vec35.add(vec36));
            float f1 = 0.0f;
            boolean bl2 = flag3 = vec3.y() != vec31.y();
            if (flag3) {
                Vec3 vec310 = pos.getBottomCenter().add(vec33);
                double d = vec310.distanceTo(this.position());
                this.setPos(this.position().add(0.0, d + 0.1, 0.0));
                f1 = this.minecart.isFlipped() ? 45.0f : -45.0f;
            } else {
                this.setPos(this.position().add(0.0, 0.1, 0.0));
            }
            this.setRotation(f, f1);
            double d1 = vec35.distanceTo(this.position());
            if (d1 > 0.0) {
                this.lerpSteps.add(new MinecartStep(this.position(), this.getDeltaMovement(), this.getYRot(), this.getXRot(), snapToStart ? 0.0f : (float)d1));
            }
        }
    }

    private void setRotation(float yRot, float xRot) {
        double d = Math.abs(yRot - this.getYRot());
        if (d >= 175.0 && d <= 185.0) {
            this.minecart.setFlipped(!this.minecart.isFlipped());
            yRot -= 180.0f;
            xRot *= -1.0f;
        }
        xRot = Math.clamp(xRot, -45.0f, 45.0f);
        this.setXRot(xRot % 360.0f);
        this.setYRot(yRot % 360.0f);
    }

    @Override
    public void moveAlongTrack(ServerLevel level) {
        TrackIteration trackIteration = new TrackIteration();
        while (trackIteration.shouldIterate() && this.minecart.isAlive()) {
            Vec3 vec3;
            Vec3 deltaMovement = this.getDeltaMovement();
            BlockPos currentBlockPosOrRailBelow = this.minecart.getCurrentBlockPosOrRailBelow();
            BlockState blockState = this.level().getBlockState(currentBlockPosOrRailBelow);
            boolean isRail = BaseRailBlock.isRail(blockState);
            if (this.minecart.isOnRails() != isRail) {
                this.minecart.setOnRails(isRail);
                this.adjustToRails(currentBlockPosOrRailBelow, blockState, false);
            }
            if (isRail) {
                this.minecart.resetFallDistance();
                this.minecart.setOldPosAndRot();
                if (blockState.is(Blocks.ACTIVATOR_RAIL)) {
                    this.minecart.activateMinecart(currentBlockPosOrRailBelow.getX(), currentBlockPosOrRailBelow.getY(), currentBlockPosOrRailBelow.getZ(), blockState.getValue(PoweredRailBlock.POWERED));
                }
                RailShape railShape = blockState.getValue(((BaseRailBlock)blockState.getBlock()).getShapeProperty());
                vec3 = this.calculateTrackSpeed(level, deltaMovement.horizontal(), trackIteration, currentBlockPosOrRailBelow, blockState, railShape);
                trackIteration.movementLeft = trackIteration.firstIteration ? vec3.horizontalDistance() : (trackIteration.movementLeft += vec3.horizontalDistance() - deltaMovement.horizontalDistance());
                this.setDeltaMovement(vec3);
                trackIteration.movementLeft = this.minecart.makeStepAlongTrack(currentBlockPosOrRailBelow, railShape, trackIteration.movementLeft);
            } else {
                this.minecart.comeOffTrack(level);
                trackIteration.movementLeft = 0.0;
            }
            Vec3 vec31 = this.position();
            vec3 = vec31.subtract(this.minecart.oldPosition());
            double len = vec3.length();
            if (len > (double)1.0E-5f) {
                if (!(vec3.horizontalDistanceSqr() > (double)1.0E-5f)) {
                    if (!this.minecart.isOnRails()) {
                        this.setXRot(this.minecart.onGround() ? 0.0f : Mth.rotLerp(0.2f, this.getXRot(), 0.0f));
                    }
                } else {
                    float f = 180.0f - (float)(Math.atan2(vec3.z, vec3.x) * 180.0 / Math.PI);
                    float f1 = this.minecart.onGround() && !this.minecart.isOnRails() ? 0.0f : 90.0f - (float)(Math.atan2(vec3.horizontalDistance(), vec3.y) * 180.0 / Math.PI);
                    this.setRotation(f += this.minecart.isFlipped() ? 180.0f : 0.0f, f1 *= this.minecart.isFlipped() ? -1.0f : 1.0f);
                }
                this.lerpSteps.add(new MinecartStep(vec31, this.getDeltaMovement(), this.getYRot(), this.getXRot(), (float)Math.min(len, this.getMaxSpeed(level))));
            } else if (deltaMovement.horizontalDistanceSqr() > 0.0) {
                this.lerpSteps.add(new MinecartStep(vec31, this.getDeltaMovement(), this.getYRot(), this.getXRot(), 1.0f));
            }
            if (len > (double)1.0E-5f || trackIteration.firstIteration) {
                this.minecart.applyEffectsFromBlocks();
                this.minecart.applyEffectsFromBlocks();
            }
            trackIteration.firstIteration = false;
        }
    }

    private Vec3 calculateTrackSpeed(ServerLevel level, Vec3 speed, TrackIteration trackIteration, BlockPos pos, BlockState state, RailShape railShape) {
        Vec3 vec31;
        Vec3 vec312;
        Vec3 vec3 = speed;
        if (!trackIteration.hasGainedSlopeSpeed && (vec312 = this.calculateSlopeSpeed(speed, railShape)).horizontalDistanceSqr() != speed.horizontalDistanceSqr()) {
            trackIteration.hasGainedSlopeSpeed = true;
            vec3 = vec312;
        }
        if (trackIteration.firstIteration && (vec312 = this.calculatePlayerInputSpeed(vec3)).horizontalDistanceSqr() != vec3.horizontalDistanceSqr()) {
            trackIteration.hasHalted = true;
            vec3 = vec312;
        }
        if (!trackIteration.hasHalted && (vec312 = this.calculateHaltTrackSpeed(vec3, state)).horizontalDistanceSqr() != vec3.horizontalDistanceSqr()) {
            trackIteration.hasHalted = true;
            vec3 = vec312;
        }
        if (trackIteration.firstIteration && (vec3 = this.minecart.applyNaturalSlowdown(vec3)).lengthSqr() > 0.0) {
            double min = Math.min(vec3.length(), this.minecart.getMaxSpeed(level));
            vec3 = vec3.normalize().scale(min);
        }
        if (!trackIteration.hasBoosted && (vec31 = this.calculateBoostTrackSpeed(vec3, pos, state)).horizontalDistanceSqr() != vec3.horizontalDistanceSqr()) {
            trackIteration.hasBoosted = true;
            vec3 = vec31;
        }
        return vec3;
    }

    private Vec3 calculateSlopeSpeed(Vec3 speed, RailShape railShape) {
        double max = Math.max(0.0078125, speed.horizontalDistance() * 0.02);
        if (this.minecart.isInWater()) {
            max *= 0.2;
        }
        return switch (railShape) {
            case RailShape.ASCENDING_EAST -> speed.add(-max, 0.0, 0.0);
            case RailShape.ASCENDING_WEST -> speed.add(max, 0.0, 0.0);
            case RailShape.ASCENDING_NORTH -> speed.add(0.0, 0.0, max);
            case RailShape.ASCENDING_SOUTH -> speed.add(0.0, 0.0, -max);
            default -> speed;
        };
    }

    private Vec3 calculatePlayerInputSpeed(Vec3 speed) {
        Entity entity = this.minecart.getFirstPassenger();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Vec3 lastClientMoveIntent = serverPlayer.getLastClientMoveIntent();
            if (lastClientMoveIntent.lengthSqr() > 0.0) {
                Vec3 vec3 = lastClientMoveIntent.normalize();
                double d = speed.horizontalDistanceSqr();
                if (vec3.lengthSqr() > 0.0 && d < 0.01) {
                    return speed.add(new Vec3(vec3.x, 0.0, vec3.z).normalize().scale(0.001));
                }
            }
            return speed;
        }
        return speed;
    }

    private Vec3 calculateHaltTrackSpeed(Vec3 speed, BlockState state) {
        if (state.is(Blocks.POWERED_RAIL) && !state.getValue(PoweredRailBlock.POWERED).booleanValue()) {
            return speed.length() < 0.03 ? Vec3.ZERO : speed.scale(0.5);
        }
        return speed;
    }

    private Vec3 calculateBoostTrackSpeed(Vec3 speed, BlockPos pos, BlockState state) {
        if (state.is(Blocks.POWERED_RAIL) && state.getValue(PoweredRailBlock.POWERED).booleanValue()) {
            if (speed.length() > 0.01) {
                return speed.normalize().scale(speed.length() + 0.06);
            }
            Vec3 redstoneDirection = this.minecart.getRedstoneDirection(pos);
            return redstoneDirection.lengthSqr() <= 0.0 ? speed : redstoneDirection.scale(speed.length() + 0.2);
        }
        return speed;
    }

    @Override
    public double stepAlongTrack(BlockPos pos, RailShape railShape, double speed) {
        if (speed < (double)1.0E-5f) {
            return 0.0;
        }
        Vec3 vec3 = this.position();
        Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(railShape);
        Vec3i vec3i = (Vec3i)pair.getFirst();
        Vec3i vec3i1 = (Vec3i)pair.getSecond();
        Vec3 vec31 = this.getDeltaMovement().horizontal();
        if (vec31.length() < (double)1.0E-5f) {
            this.setDeltaMovement(Vec3.ZERO);
            return 0.0;
        }
        boolean flag = vec3i.getY() != vec3i1.getY();
        Vec3 vec32 = new Vec3(vec3i1).scale(0.5).horizontal();
        Vec3 vec33 = new Vec3(vec3i).scale(0.5).horizontal();
        if (vec31.dot(vec33) < vec31.dot(vec32)) {
            vec33 = vec32;
        }
        Vec3 vec34 = pos.getBottomCenter().add(vec33).add(0.0, 0.1, 0.0).add(vec33.normalize().scale(1.0E-5f));
        if (flag && !this.isDecending(vec31, railShape)) {
            vec34 = vec34.add(0.0, 1.0, 0.0);
        }
        Vec3 vec35 = vec34.subtract(this.position()).normalize();
        vec31 = vec35.scale(vec31.length() / vec35.horizontalDistance());
        Vec3 vec36 = vec3.add(vec31.normalize().scale(speed * (double)(flag ? Mth.SQRT_OF_TWO : 1.0f)));
        if (vec3.distanceToSqr(vec34) <= vec3.distanceToSqr(vec36)) {
            speed = vec34.subtract(vec36).horizontalDistance();
            vec36 = vec34;
        } else {
            speed = 0.0;
        }
        this.minecart.move(MoverType.SELF, vec36.subtract(vec3));
        BlockState blockState = this.level().getBlockState(BlockPos.containing(vec36));
        if (flag) {
            RailShape railShape1;
            if (BaseRailBlock.isRail(blockState) && this.restAtVShape(railShape, railShape1 = blockState.getValue(((BaseRailBlock)blockState.getBlock()).getShapeProperty()))) {
                return 0.0;
            }
            double d = vec34.horizontal().distanceTo(this.position().horizontal());
            double d1 = vec34.y + (this.isDecending(vec31, railShape) ? d : -d);
            if (this.position().y < d1) {
                this.setPos(this.position().x, d1, this.position().z);
            }
        }
        if (this.position().distanceTo(vec3) < (double)1.0E-5f && vec36.distanceTo(vec3) > (double)1.0E-5f) {
            this.setDeltaMovement(Vec3.ZERO);
            return 0.0;
        }
        this.setDeltaMovement(vec31);
        return speed;
    }

    private boolean restAtVShape(RailShape shape1, RailShape shape2) {
        if (this.getDeltaMovement().lengthSqr() < 0.005 && shape2.isSlope() && this.isDecending(this.getDeltaMovement(), shape1) && !this.isDecending(this.getDeltaMovement(), shape2)) {
            this.setDeltaMovement(Vec3.ZERO);
            return true;
        }
        return false;
    }

    @Override
    public double getMaxSpeed(ServerLevel level) {
        Double maxSpeed = this.minecart.maxSpeed;
        if (maxSpeed != null) {
            return this.minecart.isInWater() ? maxSpeed / 2.0 : maxSpeed;
        }
        return (double)level.getGameRules().getInt(GameRules.RULE_MINECART_MAX_SPEED) * (this.minecart.isInWater() ? 0.5 : 1.0) / 20.0;
    }

    private boolean isDecending(Vec3 speed, RailShape railShape) {
        return switch (railShape) {
            case RailShape.ASCENDING_EAST -> {
                if (speed.x < 0.0) {
                    yield true;
                }
                yield false;
            }
            case RailShape.ASCENDING_WEST -> {
                if (speed.x > 0.0) {
                    yield true;
                }
                yield false;
            }
            case RailShape.ASCENDING_NORTH -> {
                if (speed.z > 0.0) {
                    yield true;
                }
                yield false;
            }
            case RailShape.ASCENDING_SOUTH -> {
                if (speed.z < 0.0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public double getSlowdownFactor() {
        if (this.minecart.frictionState == TriState.FALSE) {
            return 1.0;
        }
        return this.minecart.isVehicle() || !this.minecart.slowWhenEmpty ? 0.997 : 0.975;
    }

    @Override
    public boolean pushAndPickupEntities() {
        boolean flag = this.pickupEntities(this.minecart.getBoundingBox().inflate(0.2, 0.0, 0.2));
        if (!this.minecart.horizontalCollision && !this.minecart.verticalCollision) {
            return false;
        }
        boolean flag1 = this.pushEntities(this.minecart.getBoundingBox().inflate(1.0E-7));
        return flag && !flag1;
    }

    public boolean pickupEntities(AABB box) {
        List<Entity> entities;
        if (this.minecart.isRideable() && !this.minecart.isVehicle() && !(entities = this.level().getEntities(this.minecart, box, EntitySelector.pushableBy(this.minecart))).isEmpty()) {
            for (Entity entity : entities) {
                boolean flag;
                VehicleEntityCollisionEvent collisionEvent;
                if (entity instanceof Player || entity instanceof IronGolem || entity instanceof AbstractMinecart || this.minecart.isVehicle() || entity.isPassenger() || !(collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.minecart.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity())).callEvent() || !(flag = entity.startRiding(this.minecart))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean pushEntities(AABB box) {
        boolean flag;
        block3: {
            block2: {
                flag = false;
                if (!this.minecart.isRideable()) break block2;
                List<Entity> entities = this.level().getEntities(this.minecart, box, EntitySelector.pushableBy(this.minecart));
                if (entities.isEmpty()) break block3;
                for (Entity entity : entities) {
                    VehicleEntityCollisionEvent collisionEvent;
                    if (!(entity instanceof Player) && !(entity instanceof IronGolem) && !(entity instanceof AbstractMinecart) && !this.minecart.isVehicle() && !entity.isPassenger() || !this.minecart.isPassengerOfSameVehicle(entity) && !(collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.minecart.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity())).callEvent()) continue;
                    entity.push(this.minecart);
                    flag = true;
                }
                break block3;
            }
            for (Entity entity1 : this.level().getEntities(this.minecart, box)) {
                VehicleEntityCollisionEvent collisionEvent;
                if (this.minecart.hasPassenger(entity1) || !entity1.isPushable() || !(entity1 instanceof AbstractMinecart) || !(collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.minecart.getBukkitEntity(), (org.bukkit.entity.Entity)entity1.getBukkitEntity())).callEvent()) continue;
                entity1.push(this.minecart);
                flag = true;
            }
        }
        return flag;
    }

    public record MinecartStep(Vec3 position, Vec3 movement, float yRot, float xRot, float weight) {
        public static final StreamCodec<ByteBuf, MinecartStep> STREAM_CODEC = StreamCodec.composite(Vec3.STREAM_CODEC, MinecartStep::position, Vec3.STREAM_CODEC, MinecartStep::movement, ByteBufCodecs.ROTATION_BYTE, MinecartStep::yRot, ByteBufCodecs.ROTATION_BYTE, MinecartStep::xRot, ByteBufCodecs.FLOAT, MinecartStep::weight, MinecartStep::new);
        public static MinecartStep ZERO = new MinecartStep(Vec3.ZERO, Vec3.ZERO, 0.0f, 0.0f, 0.0f);
    }

    record StepPartialTicks(float partialTicksInStep, MinecartStep currentStep, MinecartStep previousStep) {
    }

    static class TrackIteration {
        double movementLeft = 0.0;
        boolean firstIteration = true;
        boolean hasGainedSlopeSpeed = false;
        boolean hasHalted = false;
        boolean hasBoosted = false;

        TrackIteration() {
        }

        public boolean shouldIterate() {
            return this.firstIteration || this.movementLeft > (double)1.0E-5f;
        }
    }
}

