/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;

public class ItemCombinerMenuSlotDefinition {
    private final List<SlotDefinition> slots;
    private final SlotDefinition resultSlot;

    ItemCombinerMenuSlotDefinition(List<SlotDefinition> slots, SlotDefinition resultSlot) {
        if (slots.isEmpty() || resultSlot.equals(SlotDefinition.EMPTY)) {
            throw new IllegalArgumentException("Need to define both inputSlots and resultSlot");
        }
        this.slots = slots;
        this.resultSlot = resultSlot;
    }

    public static Builder create() {
        return new Builder();
    }

    public SlotDefinition getSlot(int slot) {
        return this.slots.get(slot);
    }

    public SlotDefinition getResultSlot() {
        return this.resultSlot;
    }

    public List<SlotDefinition> getSlots() {
        return this.slots;
    }

    public int getNumOfInputSlots() {
        return this.slots.size();
    }

    public int getResultSlotIndex() {
        return this.getNumOfInputSlots();
    }

    public record SlotDefinition(int slotIndex, int x, int y, Predicate<ItemStack> mayPlace) {
        static final SlotDefinition EMPTY = new SlotDefinition(0, 0, 0, stack -> true);
    }

    public static class Builder {
        private final List<SlotDefinition> inputSlots = new ArrayList<SlotDefinition>();
        private SlotDefinition resultSlot = SlotDefinition.EMPTY;

        public Builder withSlot(int slotIndex, int x, int y, Predicate<ItemStack> mayPlace) {
            this.inputSlots.add(new SlotDefinition(slotIndex, x, y, mayPlace));
            return this;
        }

        public Builder withResultSlot(int slotIndex, int x, int y) {
            this.resultSlot = new SlotDefinition(slotIndex, x, y, stack -> false);
            return this;
        }

        public ItemCombinerMenuSlotDefinition build() {
            int size = this.inputSlots.size();
            for (int i = 0; i < size; ++i) {
                SlotDefinition slotDefinition = this.inputSlots.get(i);
                if (slotDefinition.slotIndex == i) continue;
                throw new IllegalArgumentException("Expected input slots to have continous indexes");
            }
            if (this.resultSlot.slotIndex != size) {
                throw new IllegalArgumentException("Expected result slot index to follow last input slot");
            }
            return new ItemCombinerMenuSlotDefinition(this.inputSlots, this.resultSlot);
        }
    }
}

