/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import io.papermc.paper.event.player.PlayerLecternPageChangeEvent;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.inventory.CraftInventoryLectern;
import org.bukkit.craftbukkit.inventory.view.CraftLecternView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.inventory.LecternInventory;

public class LecternMenu
extends AbstractContainerMenu {
    private static final int DATA_COUNT = 1;
    private static final int SLOT_COUNT = 1;
    public static final int BUTTON_PREV_PAGE = 1;
    public static final int BUTTON_NEXT_PAGE = 2;
    public static final int BUTTON_TAKE_BOOK = 3;
    public static final int BUTTON_PAGE_JUMP_RANGE_START = 100;
    private final Container lectern;
    private final ContainerData lecternData;
    @Nullable
    private CraftLecternView view = null;
    private final org.bukkit.entity.Player player;

    @Override
    public CraftLecternView getBukkitView() {
        if (this.view != null) {
            return this.view;
        }
        CraftInventoryLectern inventory = new CraftInventoryLectern(this.lectern);
        this.view = new CraftLecternView((HumanEntity)this.player, inventory, this);
        return this.view;
    }

    public LecternMenu(int containerId, Inventory playerinventory) {
        this(containerId, new SimpleContainer(1), new SimpleContainerData(1), playerinventory);
    }

    public LecternMenu(int containerId, Container lectern, ContainerData lecternData, Inventory playerinventory) {
        super(MenuType.LECTERN, containerId);
        LecternMenu.checkContainerSize(lectern, 1);
        LecternMenu.checkContainerDataCount(lecternData, 1);
        this.lectern = lectern;
        this.lecternData = lecternData;
        this.addSlot(new Slot(lectern, 0, 0, 0){

            @Override
            public void setChanged() {
                super.setChanged();
                LecternMenu.this.slotsChanged(this.container);
            }
        });
        this.addDataSlots(lecternData);
        this.player = (org.bukkit.entity.Player)playerinventory.player.getBukkitEntity();
    }

    @Override
    public boolean clickMenuButton(Player player, int id) {
        if (id >= 100) {
            int i = id - 100;
            this.setData(0, i);
            return true;
        }
        switch (id) {
            case 1: {
                int i = this.lecternData.get(0);
                CraftInventoryLectern bukkitView = (CraftInventoryLectern)this.getBukkitView().getTopInventory();
                PlayerLecternPageChangeEvent playerLecternPageChangeEvent = new PlayerLecternPageChangeEvent((org.bukkit.entity.Player)player.getBukkitEntity(), bukkitView.getHolder(), bukkitView.getBook(), PlayerLecternPageChangeEvent.PageChangeDirection.LEFT, i, i - 1);
                if (!playerLecternPageChangeEvent.callEvent()) {
                    return false;
                }
                this.setData(0, playerLecternPageChangeEvent.getNewPage());
                return true;
            }
            case 2: {
                int i = this.lecternData.get(0);
                CraftInventoryLectern bukkitView = (CraftInventoryLectern)this.getBukkitView().getTopInventory();
                PlayerLecternPageChangeEvent playerLecternPageChangeEvent = new PlayerLecternPageChangeEvent((org.bukkit.entity.Player)player.getBukkitEntity(), bukkitView.getHolder(), bukkitView.getBook(), PlayerLecternPageChangeEvent.PageChangeDirection.RIGHT, i, i + 1);
                if (!playerLecternPageChangeEvent.callEvent()) {
                    return false;
                }
                this.setData(0, playerLecternPageChangeEvent.getNewPage());
                return true;
            }
            case 3: {
                if (!player.mayBuild()) {
                    return false;
                }
                PlayerTakeLecternBookEvent event = new PlayerTakeLecternBookEvent(this.player, ((LecternInventory)this.getBukkitView().getTopInventory()).getHolder());
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return false;
                }
                ItemStack itemStack = this.lectern.removeItemNoUpdate(0);
                this.lectern.setChanged();
                if (!player.getInventory().add(itemStack)) {
                    player.drop(itemStack, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    @Override
    public void setData(int id, int data) {
        super.setData(id, data);
        this.broadcastChanges();
    }

    @Override
    public boolean stillValid(Player player) {
        if (this.lectern instanceof LecternBlockEntity.LecternInventory && !((LecternBlockEntity.LecternInventory)this.lectern).getLectern().hasBook()) {
            return false;
        }
        if (!this.checkReachable) {
            return true;
        }
        return this.lectern.stillValid(player);
    }

    public ItemStack getBook() {
        return this.lectern.getItem(0);
    }

    public int getPage() {
        return this.lecternData.get(0);
    }
}

