/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.network.HashedPatchMap;
import net.minecraft.network.HashedStack;
import net.minecraft.world.item.ItemStack;

public interface RemoteSlot {
    public static final RemoteSlot PLACEHOLDER = new RemoteSlot(){

        @Override
        public void receive(HashedStack stack) {
        }

        @Override
        public void force(ItemStack stack) {
        }

        @Override
        public boolean matches(ItemStack stack) {
            return true;
        }
    };

    public void force(ItemStack var1);

    public void receive(HashedStack var1);

    public boolean matches(ItemStack var1);

    public static class Synchronized
    implements RemoteSlot {
        private final HashedPatchMap.HashGenerator hasher;
        private final boolean simplifyMatching;
        @Nullable
        private ItemStack remoteStack = null;
        @Nullable
        private HashedStack remoteHash = null;

        public Synchronized(HashedPatchMap.HashGenerator hasher, boolean simplifyMatching) {
            this.simplifyMatching = simplifyMatching;
            this.hasher = hasher;
        }

        @Override
        public void force(ItemStack stack) {
            this.remoteStack = stack.copy();
            this.remoteHash = null;
        }

        @Override
        public void receive(HashedStack stack) {
            this.remoteStack = null;
            this.remoteHash = stack;
        }

        @Override
        public boolean matches(ItemStack stack) {
            if (this.remoteStack != null) {
                return ItemStack.matches(this.remoteStack, stack);
            }
            if (this.remoteHash != null && this.remoteHash.matches(stack, this.hasher, this.simplifyMatching)) {
                this.remoteStack = stack.copy();
                return true;
            }
            return false;
        }

        public void copyFrom(Synchronized other) {
            this.remoteStack = other.remoteStack;
            this.remoteHash = other.remoteHash;
        }
    }
}

