/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Projectile;

public class EggItem
extends Item
implements ProjectileItem {
    public static final float PROJECTILE_SHOOT_POWER = 1.5f;

    public EggItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        Projectile.Delayed<ThrownEgg> thrownEgg = net.minecraft.world.entity.projectile.Projectile.spawnProjectileFromRotationDelayed(ThrownEgg::new, (ServerLevel)level, itemInHand, player, 0.0f, 1.5f, 1.0f);
        PlayerLaunchProjectileEvent event = new PlayerLaunchProjectileEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(itemInHand), (Projectile)thrownEgg.projectile().getBukkitEntity());
        if (event.callEvent() && thrownEgg.attemptSpawn()) {
            if (event.shouldConsume()) {
                itemInHand.consume(1, player);
            } else {
                player.containerMenu.sendAllDataToRemote();
            }
        } else {
            player.containerMenu.sendAllDataToRemote();
            return InteractionResult.FAIL;
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        player.awardStat(Stats.ITEM_USED.get(this));
        return InteractionResult.SUCCESS;
    }

    @Override
    public net.minecraft.world.entity.projectile.Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        return new ThrownEgg(level, pos.x(), pos.y(), pos.z(), stack);
    }
}

