/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class FoodOnAStickItem<T extends Entity>
extends Item {
    private final EntityType<T> canInteractWith;
    private final int consumeItemDamage;

    public FoodOnAStickItem(EntityType<T> canInteractWith, int consumeItemDamage, Item.Properties properties) {
        super(properties);
        this.canInteractWith = canInteractWith;
        this.consumeItemDamage = consumeItemDamage;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        Entity controlledVehicle = player.getControlledVehicle();
        if (player.isPassenger() && controlledVehicle instanceof ItemSteerable) {
            ItemSteerable itemSteerable = (ItemSteerable)((Object)controlledVehicle);
            if (controlledVehicle.getType() == this.canInteractWith && itemSteerable.boost()) {
                EquipmentSlot slotForHand = LivingEntity.getSlotForHand(hand);
                ItemStack itemStack = itemInHand.hurtAndConvertOnBreak(this.consumeItemDamage, Items.FISHING_ROD, player, slotForHand);
                return InteractionResult.SUCCESS_SERVER.heldItemTransformedTo(itemStack);
            }
        }
        player.awardStat(Stats.ITEM_USED.get(this));
        return InteractionResult.PASS;
    }
}

