/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.papermc.paper.event.entity.EntityDamageItemEvent;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import io.papermc.paper.util.SafeAutoClosable;
import io.papermc.paper.util.sanitizer.ItemComponentSanitizer;
import io.papermc.paper.util.sanitizer.ItemObfuscationSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.NullOps;
import net.minecraft.util.StringUtil;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    private static final List<Component> OP_NBT_WARNING = List.of(Component.translatable("item.op_warning.line1").withStyle(ChatFormatting.RED, ChatFormatting.BOLD), Component.translatable("item.op_warning.line2").withStyle(ChatFormatting.RED), Component.translatable("item.op_warning.line3").withStyle(ChatFormatting.RED));
    private static final Component UNBREAKABLE_TOOLTIP = Component.translatable("item.unbreakable").withStyle(ChatFormatting.BLUE);
    public static final MapCodec<ItemStack> MAP_CODEC = MapCodec.recursive((String)"ItemStack", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)Item.CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.intRange(1, 99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(stack -> stack.components.asPatch())).apply((Applicative)instance, ItemStack::new)));
    public static final Codec<ItemStack> CODEC = Codec.lazyInitialized(() -> MAP_CODEC.codec());
    public static final Codec<ItemStack> SINGLE_ITEM_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)Item.CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(stack -> stack.components.asPatch())).apply((Applicative)instance, (item, components) -> new ItemStack((Holder<Item>)item, 1, (DataComponentPatch)components))));
    public static final Codec<ItemStack> STRICT_CODEC = CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> STRICT_SINGLE_ITEM_CODEC = SINGLE_ITEM_CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(CODEC).xmap(optional -> optional.orElse(EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack));
    public static final Codec<ItemStack> SIMPLE_ITEM_CODEC = Item.CODEC.xmap(ItemStack::new, ItemStack::getItemHolder);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> OPTIONAL_STREAM_CODEC = ItemStack.createOptionalStreamCodec(DataComponentPatch.STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> OPTIONAL_UNTRUSTED_STREAM_CODEC = ItemStack.createOptionalStreamCodec(DataComponentPatch.DELIMITED_STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        @Override
        public ItemStack decode(RegistryFriendlyByteBuf buffer) {
            ItemStack itemStack = (ItemStack)OPTIONAL_STREAM_CODEC.decode(buffer);
            if (itemStack.isEmpty()) {
                throw new DecoderException("Empty ItemStack not allowed");
            }
            return itemStack;
        }

        @Override
        public void encode(RegistryFriendlyByteBuf buffer, ItemStack value) {
            if (value.isEmpty()) {
                throw new EncoderException("Empty ItemStack not allowed");
            }
            OPTIONAL_STREAM_CODEC.encode(buffer, value);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> OPTIONAL_LIST_STREAM_CODEC = OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ItemStack EMPTY = new ItemStack((Void)null);
    private static final Component DISABLED_ITEM_TOOLTIP = Component.translatable("item.disabled").withStyle(ChatFormatting.RED);
    private int count;
    private int popTime;
    @Deprecated
    @Nullable
    private Item item;
    PatchedDataComponentMap components;
    @Nullable
    private net.minecraft.world.entity.Entity entityRepresentation;
    @Nullable
    private CraftItemStack bukkitStack;

    public static DataResult<ItemStack> validateStrict(ItemStack stack) {
        DataResult<Unit> dataResult = ItemStack.validateComponents(stack.getComponents());
        if (dataResult.isError()) {
            return dataResult.map(unit -> stack);
        }
        return stack.getCount() > stack.getMaxStackSize() ? DataResult.error(() -> "Item stack with stack size of " + stack.getCount() + " was larger than maximum: " + stack.getMaxStackSize()) : DataResult.success((Object)stack);
    }

    private static StreamCodec<RegistryFriendlyByteBuf, ItemStack> createOptionalStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> codec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            @Override
            public ItemStack decode(RegistryFriendlyByteBuf buffer) {
                int varInt = buffer.readVarInt();
                if (varInt <= 0) {
                    return EMPTY;
                }
                Holder holder = (Holder)Item.STREAM_CODEC.decode(buffer);
                DataComponentPatch dataComponentPatch = (DataComponentPatch)codec.decode(buffer);
                return new ItemStack(holder, varInt, dataComponentPatch);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void encode(RegistryFriendlyByteBuf buffer, ItemStack value) {
                if (value.isEmpty() || value.getItem() == null) {
                    buffer.writeVarInt(0);
                } else {
                    buffer.writeVarInt(ItemComponentSanitizer.sanitizeCount(ItemObfuscationSession.currentSession(), value, value.getCount()));
                    Item.STREAM_CODEC.encode(buffer, value.getItemHolder());
                    boolean prev = ComponentSerialization.DONT_RENDER_TRANSLATABLES.get();
                    try (SafeAutoClosable ignored = ItemObfuscationSession.withContext(c -> c.itemStack(value));){
                        ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(true);
                        codec.encode(buffer, value.components.asPatch());
                    }
                    finally {
                        ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(prev);
                    }
                }
            }
        };
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> validatedStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> codec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            @Override
            public ItemStack decode(RegistryFriendlyByteBuf buffer) {
                ItemStack itemStack = (ItemStack)codec.decode(buffer);
                if (!itemStack.isEmpty()) {
                    RegistryOps<Unit> registryOps = buffer.registryAccess().createSerializationContext(NullOps.INSTANCE);
                    CODEC.encodeStart(registryOps, (Object)itemStack).getOrThrow(DecoderException::new);
                }
                return itemStack;
            }

            @Override
            public void encode(RegistryFriendlyByteBuf buffer, ItemStack value) {
                codec.encode(buffer, value);
            }
        };
    }

    public Optional<TooltipComponent> getTooltipImage() {
        return this.getItem().getTooltipImage(this);
    }

    @Override
    public DataComponentMap getComponents() {
        return !this.isEmpty() ? this.components : DataComponentMap.EMPTY;
    }

    public DataComponentMap getPrototype() {
        return !this.isEmpty() ? this.getItem().components() : DataComponentMap.EMPTY;
    }

    public DataComponentPatch getComponentsPatch() {
        return !this.isEmpty() ? this.components.asPatch() : DataComponentPatch.EMPTY;
    }

    public DataComponentMap immutableComponents() {
        return !this.isEmpty() ? this.components.toImmutableMap() : DataComponentMap.EMPTY;
    }

    public boolean hasNonDefault(DataComponentType<?> component) {
        return !this.isEmpty() && this.components.hasNonDefault(component);
    }

    public ItemStack(ItemLike item) {
        this(item, 1);
    }

    public ItemStack(Holder<Item> tag) {
        this(tag.value(), 1);
    }

    public ItemStack(Holder<Item> tag, int count, DataComponentPatch components) {
        this(tag.value(), count, PatchedDataComponentMap.fromPatch(tag.value().components(), components));
    }

    public ItemStack(Holder<Item> item, int count) {
        this(item.value(), count);
    }

    public ItemStack(ItemLike item, int count) {
        this(item, count, new PatchedDataComponentMap(item.asItem().components()));
    }

    private ItemStack(ItemLike item, int count, PatchedDataComponentMap components) {
        this.item = item.asItem();
        this.count = count;
        this.components = components;
        this.getItem().verifyComponentsAfterLoad(this);
    }

    private ItemStack(@Nullable Void unused) {
        this.item = null;
        this.components = new PatchedDataComponentMap(DataComponentMap.EMPTY);
    }

    public static DataResult<Unit> validateComponents(DataComponentMap components) {
        if (components.has(DataComponents.MAX_DAMAGE) && components.getOrDefault(DataComponents.MAX_STACK_SIZE, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents itemContainerContents = components.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY);
        for (ItemStack itemStack : itemContainerContents.nonEmptyItems()) {
            int maxStackSize;
            int count = itemStack.getCount();
            if (count <= (maxStackSize = itemStack.getMaxStackSize())) continue;
            return DataResult.error(() -> "Item stack with count of " + count + " was larger than maximum: " + maxStackSize);
        }
        return DataResult.success((Object)((Object)Unit.INSTANCE));
    }

    public static Optional<ItemStack> parse(HolderLookup.Provider lookupProvider, Tag tag) {
        return CODEC.parse(lookupProvider.createSerializationContext(NbtOps.INSTANCE), (Object)tag).resultOrPartial(itemId -> LOGGER.error("Tried to load invalid item: '{}'", itemId));
    }

    public boolean isEmpty() {
        return this == EMPTY || this.item == Items.AIR || this.count <= 0;
    }

    public boolean isItemEnabled(FeatureFlagSet enabledFlags) {
        return this.isEmpty() || this.getItem().isEnabled(enabledFlags);
    }

    public ItemStack split(int amount) {
        int min = Math.min(amount, this.getCount());
        ItemStack itemStack = this.copyWithCount(min);
        this.shrink(min);
        return itemStack;
    }

    public ItemStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemStack = this.copy();
        this.setCount(0);
        return itemStack;
    }

    public Item getItem() {
        return this.isEmpty() ? Items.AIR : this.item;
    }

    public Holder<Item> getItemHolder() {
        return this.getItem().builtInRegistryHolder();
    }

    public boolean is(TagKey<Item> tag) {
        return this.getItem().builtInRegistryHolder().is(tag);
    }

    public boolean is(Item item) {
        return this.getItem() == item;
    }

    public boolean is(Predicate<Holder<Item>> item) {
        return item.test(this.getItem().builtInRegistryHolder());
    }

    public boolean is(Holder<Item> item) {
        return this.getItem().builtInRegistryHolder() == item;
    }

    public boolean is(HolderSet<Item> item) {
        return item.contains(this.getItemHolder());
    }

    public Stream<TagKey<Item>> getTags() {
        return this.getItem().builtInRegistryHolder().tags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InteractionResult useOn(UseOnContext context) {
        InteractionResult.Success success;
        InteractionResult interactionResult;
        Player player = context.getPlayer();
        BlockPos clickedPos = context.getClickedPos();
        if (player != null && !player.getAbilities().mayBuild && !this.canPlaceOnBlockInAdventureMode(new BlockInWorld(context.getLevel(), clickedPos, false))) {
            return InteractionResult.PASS;
        }
        Item item = this.getItem();
        DataComponentPatch previousPatch = this.components.asPatch();
        int oldCount = this.getCount();
        ServerLevel serverLevel = (ServerLevel)context.getLevel();
        if (!(item instanceof BucketItem)) {
            serverLevel.captureBlockStates = true;
            if (item == Items.BONE_MEAL) {
                serverLevel.captureTreeGeneration = true;
            }
        }
        try {
            interactionResult = item.useOn(context);
        }
        finally {
            serverLevel.captureBlockStates = false;
        }
        DataComponentPatch newPatch = this.components.asPatch();
        int newCount = this.getCount();
        this.setCount(oldCount);
        this.restorePatch(previousPatch);
        if (interactionResult.consumesAction() && serverLevel.captureTreeGeneration && !serverLevel.capturedBlockStates.isEmpty()) {
            serverLevel.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit(clickedPos, (World)serverLevel.getWorld());
            TreeType treeType = SaplingBlock.treeType;
            SaplingBlock.treeType = null;
            ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(serverLevel.capturedBlockStates.values());
            serverLevel.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean isBonemeal = this.getItem() == Items.BONE_MEAL;
                structureEvent = new StructureGrowEvent(location, treeType, isBonemeal, (org.bukkit.entity.Player)player.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(serverLevel, clickedPos), (org.bukkit.entity.Player)player.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.getCount() == oldCount && Objects.equals(this.components.asPatch(), previousPatch)) {
                    this.restorePatch(newPatch);
                    this.setCount(newCount);
                }
                for (CraftBlockState snapshot : blocks) {
                    snapshot.place(snapshot.getFlags());
                    serverLevel.checkCapturedTreeStateForObserverNotify(clickedPos, snapshot);
                }
                player.awardStat(Stats.ITEM_USED.get(item));
            }
            SignItem.openSign = null;
            return interactionResult;
        }
        serverLevel.captureTreeGeneration = false;
        if (player != null && interactionResult instanceof InteractionResult.Success && (success = (InteractionResult.Success)interactionResult).wasItemInteraction()) {
            InteractionHand hand = context.getHand();
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(serverLevel.capturedBlockStates.values());
            serverLevel.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(serverLevel, player, hand, blocks, clickedPos);
            } else if (blocks.size() == 1 && item != Items.POWDER_SNOW_BUCKET) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(serverLevel, player, hand, (BlockState)blocks.getFirst(), clickedPos);
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                interactionResult = InteractionResult.FAIL;
                player.containerMenu.sendAllDataToRemote();
                serverLevel.capturedTileEntities.clear();
                for (BlockState blockstate : blocks) {
                    ((CraftBlockState)blockstate).revertPlace();
                }
                SignItem.openSign = null;
            } else {
                BlockPos pos;
                net.minecraft.world.level.block.state.BlockState state;
                BlockEntity te;
                if (this.getCount() == oldCount && Objects.equals(this.components.asPatch(), previousPatch)) {
                    this.restorePatch(newPatch);
                    this.setCount(newCount);
                }
                for (Map.Entry<BlockPos, BlockEntity> e : serverLevel.capturedTileEntities.entrySet()) {
                    serverLevel.setBlockEntity(e.getValue());
                }
                for (BlockState blockstate : blocks) {
                    int updateFlags = ((CraftBlockState)blockstate).getFlags();
                    net.minecraft.world.level.block.state.BlockState oldBlock = ((CraftBlockState)blockstate).getHandle();
                    BlockPos newPos = ((CraftBlockState)blockstate).getPosition();
                    net.minecraft.world.level.block.state.BlockState block = serverLevel.getBlockState(newPos);
                    if (!(block.getBlock() instanceof BaseEntityBlock)) {
                        block.onPlace(serverLevel, newPos, oldBlock, true, context);
                    }
                    serverLevel.notifyAndUpdatePhysics(newPos, null, oldBlock, block, serverLevel.getBlockState(newPos), updateFlags, 512);
                }
                if (this.item == Items.WITHER_SKELETON_SKULL) {
                    BlockPos bp = clickedPos;
                    if (!serverLevel.getBlockState(clickedPos).canBeReplaced()) {
                        bp = !serverLevel.getBlockState(clickedPos).isSolid() ? null : bp.relative(context.getClickedFace());
                    }
                    if (bp != null && (te = serverLevel.getBlockEntity(bp)) instanceof SkullBlockEntity) {
                        WitherSkullBlock.checkSpawn(serverLevel, bp, (SkullBlockEntity)te);
                    }
                }
                if (this.item instanceof SignItem && SignItem.openSign != null) {
                    try {
                        te = serverLevel.getBlockEntity(SignItem.openSign);
                        if (te instanceof SignBlockEntity) {
                            SignBlockEntity blockEntity = (SignBlockEntity)te;
                            Block block = serverLevel.getBlockState(SignItem.openSign).getBlock();
                            if (block instanceof SignBlock) {
                                SignBlock signBlock = (SignBlock)block;
                                signBlock.openTextEdit(player, blockEntity, true, PlayerOpenSignEvent.Cause.PLACE);
                            }
                        }
                    }
                    finally {
                        SignItem.openSign = null;
                    }
                }
                if (placeEvent != null && this.item instanceof BedItem && (state = serverLevel.getBlockState(pos = ((CraftBlock)placeEvent.getBlock()).getPosition())).getBlock() instanceof BedBlock) {
                    serverLevel.updateNeighborsAt(pos, Blocks.AIR);
                    state.updateNeighbourShapes(serverLevel, pos, 3);
                }
                if (this.item instanceof BlockItem && success.paperSuccessContext().placedBlockPosition() != null) {
                    net.minecraft.world.level.block.state.BlockState state2 = serverLevel.getBlockState(success.paperSuccessContext().placedBlockPosition());
                    SoundType soundType = state2.getSoundType();
                    serverLevel.playSound((net.minecraft.world.entity.Entity)player, clickedPos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
                }
                player.awardStat(Stats.ITEM_USED.get(item));
            }
        }
        serverLevel.capturedTileEntities.clear();
        serverLevel.capturedBlockStates.clear();
        return interactionResult;
    }

    public float getDestroySpeed(net.minecraft.world.level.block.state.BlockState state) {
        return this.getItem().getDestroySpeed(this, state);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        InteractionResult.Success success;
        ItemStack itemStack = this.copy();
        boolean flag = this.getUseDuration(player) <= 0;
        InteractionResult interactionResult = this.getItem().use(level, player, hand);
        return flag && interactionResult instanceof InteractionResult.Success ? success.heldItemTransformedTo((success = (InteractionResult.Success)interactionResult).heldItemTransformedTo() == null ? this.applyAfterUseComponentSideEffects(player, itemStack) : success.heldItemTransformedTo().applyAfterUseComponentSideEffects(player, itemStack)) : interactionResult;
    }

    public ItemStack finishUsingItem(Level level, LivingEntity livingEntity) {
        ItemStack itemStack = this.copy();
        ItemStack itemStack1 = this.getItem().finishUsingItem(this, level, livingEntity);
        return itemStack1.applyAfterUseComponentSideEffects(livingEntity, itemStack);
    }

    private ItemStack applyAfterUseComponentSideEffects(LivingEntity entity, ItemStack stack) {
        UseRemainder useRemainder = stack.get(DataComponents.USE_REMAINDER);
        UseCooldown useCooldown = stack.get(DataComponents.USE_COOLDOWN);
        int count = stack.getCount();
        ItemStack itemStack = this;
        if (useRemainder != null) {
            itemStack = useRemainder.convertIntoRemainder(this, count, entity.hasInfiniteMaterials(), entity::handleExtraItemsCreatedOnUse);
        }
        if (useCooldown != null) {
            useCooldown.apply(stack, entity);
        }
        return itemStack;
    }

    public Tag save(HolderLookup.Provider levelRegistryAccess, Tag outputTag) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (Tag)CODEC.encode((Object)this, levelRegistryAccess.createSerializationContext(NbtOps.INSTANCE), (Object)outputTag).getOrThrow();
    }

    public Tag save(HolderLookup.Provider levelRegistryAccess) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (Tag)CODEC.encodeStart(levelRegistryAccess.createSerializationContext(NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    public int getMaxStackSize() {
        return this.getOrDefault(DataComponents.MAX_STACK_SIZE, 1);
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isDamageableItem() || !this.isDamaged());
    }

    public boolean isDamageableItem() {
        return this.has(DataComponents.MAX_DAMAGE) && !this.has(DataComponents.UNBREAKABLE) && this.has(DataComponents.DAMAGE);
    }

    public boolean isDamaged() {
        return this.isDamageableItem() && this.getDamageValue() > 0;
    }

    public int getDamageValue() {
        return Mth.clamp(this.getOrDefault(DataComponents.DAMAGE, 0), 0, this.getMaxDamage());
    }

    public void setDamageValue(int damage) {
        this.set(DataComponents.DAMAGE, Mth.clamp(damage, 0, this.getMaxDamage()));
    }

    public int getMaxDamage() {
        return this.getOrDefault(DataComponents.MAX_DAMAGE, 0);
    }

    public boolean isBroken() {
        return this.isDamageableItem() && this.getDamageValue() >= this.getMaxDamage();
    }

    public boolean nextDamageWillBreak() {
        return this.isDamageableItem() && this.getDamageValue() >= this.getMaxDamage() - 1;
    }

    public void hurtAndBreak(int damage, ServerLevel level, @Nullable LivingEntity player, Consumer<Item> onBreak) {
        this.hurtAndBreak(damage, level, player, onBreak, false);
    }

    public void hurtAndBreak(int damage, ServerLevel level, @Nullable LivingEntity player, Consumer<Item> onBreak, boolean force) {
        int originalDamage = damage;
        int i = this.processDurabilityChange(damage, level, player, force);
        if (i > 0 && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerItemDamageEvent event = new PlayerItemDamageEvent((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), i, originalDamage);
            event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
            if (i != event.getDamage() || event.isCancelled()) {
                serverPlayer.containerMenu.sendAllDataToRemote();
            }
            if (event.isCancelled()) {
                return;
            }
            i = event.getDamage();
        } else if (i > 0 && player != null) {
            EntityDamageItemEvent event = new EntityDamageItemEvent((Entity)player.getBukkitLivingEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), i);
            if (!event.callEvent()) {
                return;
            }
            i = event.getDamage();
        }
        if (i != 0) {
            this.applyDamage(this.getDamageValue() + i, player, onBreak);
        }
    }

    private int processDurabilityChange(int damage, ServerLevel level, @Nullable LivingEntity player) {
        return this.processDurabilityChange(damage, level, player, false);
    }

    private int processDurabilityChange(int damage, ServerLevel level, @Nullable LivingEntity player, boolean force) {
        if (!this.isDamageableItem()) {
            return 0;
        }
        if (player instanceof ServerPlayer && player.hasInfiniteMaterials() && !force) {
            return 0;
        }
        return damage > 0 ? EnchantmentHelper.processDurabilityChange(level, this, damage) : damage;
    }

    private void applyDamage(int damage, @Nullable LivingEntity player, Consumer<Item> onBreak) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.ITEM_DURABILITY_CHANGED.trigger(serverPlayer, this, damage);
        }
        this.setDamageValue(damage);
        if (this.isBroken()) {
            Item item = this.getItem();
            if (this.count == 1 && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CraftEventFactory.callPlayerItemBreakEvent(serverPlayer, this);
            }
            this.shrink(1);
            onBreak.accept(item);
        }
    }

    public void hurtWithoutBreaking(int damage, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int i = this.processDurabilityChange(damage, serverPlayer.serverLevel(), serverPlayer);
            if (i == 0) {
                return;
            }
            int min = Math.min(this.getDamageValue() + i, this.getMaxDamage() - 1);
            if (min - this.getDamageValue() > 0) {
                PlayerItemDamageEvent event = new PlayerItemDamageEvent((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), min - this.getDamageValue(), damage);
                if (!event.callEvent() || event.getDamage() == 0) {
                    return;
                }
                min = Math.min(this.getDamageValue() + event.getDamage(), this.getMaxDamage() - 1);
            }
            this.applyDamage(min, serverPlayer, item -> {});
        }
    }

    public void hurtAndBreak(int amount, LivingEntity entity, EquipmentSlot slot) {
        this.hurtAndBreak(amount, entity, slot, false);
    }

    public void hurtAndBreak(int amount, LivingEntity entity, EquipmentSlot slot, boolean force) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.hurtAndBreak(amount, serverLevel, entity, item -> {
                if (slot != null) {
                    entity.onEquippedItemBroken((Item)item, slot);
                }
            }, force);
        }
    }

    public ItemStack hurtAndConvertOnBreak(int amount, ItemLike item, LivingEntity entity, EquipmentSlot slot) {
        this.hurtAndBreak(amount, entity, slot);
        if (this.isEmpty()) {
            ItemStack itemStack = this.transmuteCopyIgnoreEmpty(item, 1);
            if (itemStack.isDamageableItem()) {
                itemStack.setDamageValue(0);
            }
            return itemStack;
        }
        return this;
    }

    public boolean isBarVisible() {
        return this.getItem().isBarVisible(this);
    }

    public int getBarWidth() {
        return this.getItem().getBarWidth(this);
    }

    public int getBarColor() {
        return this.getItem().getBarColor(this);
    }

    public boolean overrideStackedOnOther(Slot slot, ClickAction action, Player player) {
        return this.getItem().overrideStackedOnOther(this, slot, action, player);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        return this.getItem().overrideOtherStackedOnMe(this, stack, slot, action, player, access);
    }

    public boolean hurtEnemy(LivingEntity enemy, LivingEntity attacker) {
        Item item = this.getItem();
        item.hurtEnemy(this, enemy, attacker);
        if (this.has(DataComponents.WEAPON)) {
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                player.awardStat(Stats.ITEM_USED.get(item));
            }
            return true;
        }
        return false;
    }

    public void postHurtEnemy(LivingEntity enemy, LivingEntity attacker) {
        this.getItem().postHurtEnemy(this, enemy, attacker);
        Weapon weapon = this.get(DataComponents.WEAPON);
        if (weapon != null) {
            this.hurtAndBreak(weapon.itemDamagePerAttack(), attacker, EquipmentSlot.MAINHAND);
        }
    }

    public void mineBlock(Level level, net.minecraft.world.level.block.state.BlockState state, BlockPos pos, Player player) {
        Item item = this.getItem();
        if (item.mineBlock(this, level, state, pos, player)) {
            player.awardStat(Stats.ITEM_USED.get(item));
        }
    }

    public boolean isCorrectToolForDrops(net.minecraft.world.level.block.state.BlockState state) {
        return this.getItem().isCorrectToolForDrops(this, state);
    }

    public InteractionResult interactLivingEntity(Player player, LivingEntity entity, InteractionHand usedHand) {
        InteractionResult interactionResult;
        Equippable equippable = this.get(DataComponents.EQUIPPABLE);
        if (equippable != null && equippable.equipOnInteract() && (interactionResult = equippable.equipOnTarget(player, entity, this)) != InteractionResult.PASS) {
            return interactionResult;
        }
        return this.getItem().interactLivingEntity(this, player, entity, usedHand);
    }

    public ItemStack copy() {
        return this.copy(false);
    }

    public ItemStack copy(boolean originalItem) {
        if (!originalItem && this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemStack = new ItemStack(originalItem ? this.item : this.getItem(), this.count, this.components.copy());
        itemStack.setPopTime(this.getPopTime());
        return itemStack;
    }

    public ItemStack copyWithCount(int count) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemStack = this.copy();
        itemStack.setCount(count);
        return itemStack;
    }

    public ItemStack transmuteCopy(ItemLike item) {
        return this.transmuteCopy(item, this.getCount());
    }

    public ItemStack transmuteCopy(ItemLike item, int count) {
        return this.isEmpty() ? EMPTY : this.transmuteCopyIgnoreEmpty(item, count);
    }

    private ItemStack transmuteCopyIgnoreEmpty(ItemLike item, int count) {
        return new ItemStack(item.asItem().builtInRegistryHolder(), count, this.components.asPatch());
    }

    public static boolean matches(ItemStack stack, ItemStack other) {
        return stack == other || stack.getCount() == other.getCount() && ItemStack.isSameItemSameComponents(stack, other);
    }

    @Deprecated
    public static boolean listMatches(List<ItemStack> list, List<ItemStack> other) {
        if (list.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (ItemStack.matches(list.get(i), other.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameItem(ItemStack stack, ItemStack other) {
        return stack.is(other.getItem());
    }

    public static boolean isSameItemSameComponents(ItemStack stack, ItemStack other) {
        return stack.is(other.getItem()) && (stack.isEmpty() && other.isEmpty() || Objects.equals(stack.components, other.components));
    }

    public static MapCodec<ItemStack> lenientOptionalFieldOf(String fieldName) {
        return CODEC.lenientOptionalFieldOf(fieldName).xmap(optional -> optional.orElse(EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack));
    }

    public static int hashItemAndComponents(@Nullable ItemStack stack) {
        if (stack != null) {
            int i = 31 + stack.getItem().hashCode();
            return 31 * i + stack.getComponents().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int hashStackList(List<ItemStack> list) {
        int i = 0;
        for (ItemStack itemStack : list) {
            i = i * 31 + ItemStack.hashItemAndComponents(itemStack);
        }
        return i;
    }

    public String toString() {
        return this.getCount() + " " + String.valueOf(this.getItem());
    }

    public void inventoryTick(Level level, net.minecraft.world.entity.Entity entity, @Nullable EquipmentSlot slot) {
        if (this.popTime > 0) {
            --this.popTime;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.getItem().inventoryTick(this, serverLevel, entity, slot);
        }
    }

    public void onCraftedBy(Player player, int amount) {
        player.awardStat(Stats.ITEM_CRAFTED.get(this.getItem()), amount);
        this.getItem().onCraftedBy(this, player);
    }

    public void onCraftedBySystem(Level level) {
        this.getItem().onCraftedPostProcess(this, level);
    }

    public int getUseDuration(LivingEntity entity) {
        return this.getItem().getUseDuration(this, entity);
    }

    public ItemUseAnimation getUseAnimation() {
        return this.getItem().getUseAnimation(this);
    }

    public void releaseUsing(Level level, LivingEntity livingEntity, int timeLeft) {
        ItemStack itemStack1;
        ItemStack itemStack = this.copy();
        if (this.getItem().releaseUsing(this, level, livingEntity, timeLeft) && (itemStack1 = this.applyAfterUseComponentSideEffects(livingEntity, itemStack)) != this) {
            livingEntity.setItemInHand(livingEntity.getUsedItemHand(), itemStack1);
        }
    }

    public boolean useOnRelease() {
        return this.getItem().useOnRelease(this);
    }

    public void restorePatch(DataComponentPatch datacomponentpatch) {
        this.components.restorePatch(datacomponentpatch);
    }

    @Nullable
    public <T> T set(DataComponentType<T> component, @Nullable T value) {
        return this.components.set(component, value);
    }

    public <T> void copyFrom(DataComponentType<T> componentType, DataComponentGetter componentGetter) {
        this.set(componentType, componentGetter.get(componentType));
    }

    @Nullable
    public <T, U> T update(DataComponentType<T> component, T defaultValue, U updateValue, BiFunction<T, U, T> updater) {
        return this.set(component, updater.apply(this.getOrDefault(component, defaultValue), updateValue));
    }

    @Nullable
    public <T> T update(DataComponentType<T> component, T defaultValue, UnaryOperator<T> updater) {
        T orDefault = this.getOrDefault(component, defaultValue);
        return this.set(component, updater.apply(orDefault));
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> component) {
        return this.components.remove(component);
    }

    public void applyComponentsAndValidate(DataComponentPatch components) {
        DataComponentPatch patch = this.components.asPatch();
        this.components.applyPatch(components);
        Optional optional = ItemStack.validateStrict(this).error();
        if (optional.isPresent()) {
            LOGGER.error("Failed to apply component patch '{}' to item: '{}'", (Object)components, (Object)((DataResult.Error)optional.get()).message());
            this.components.restorePatch(patch);
        } else {
            this.getItem().verifyComponentsAfterLoad(this);
        }
    }

    public void applyComponents(DataComponentPatch components) {
        this.components.applyPatch(components);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public void applyComponents(DataComponentMap components) {
        this.components.setAll(components);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public org.bukkit.inventory.ItemStack asBukkitMirror() {
        return CraftItemStack.asCraftMirror(this);
    }

    public org.bukkit.inventory.ItemStack asBukkitCopy() {
        return CraftItemStack.asCraftMirror(this.copy());
    }

    public static ItemStack fromBukkitCopy(org.bukkit.inventory.ItemStack itemstack) {
        return CraftItemStack.asNMSCopy(itemstack);
    }

    public org.bukkit.inventory.ItemStack getBukkitStack() {
        if (this.bukkitStack == null || this.bukkitStack.handle != this) {
            this.bukkitStack = CraftItemStack.asCraftMirror(this);
        }
        return this.bukkitStack;
    }

    public Component getHoverName() {
        Component customName = this.getCustomName();
        return customName != null ? customName : this.getItemName();
    }

    @Nullable
    public Component getCustomName() {
        String string;
        Component component = this.get(DataComponents.CUSTOM_NAME);
        if (component != null) {
            return component;
        }
        WrittenBookContent writtenBookContent = this.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (writtenBookContent != null && !StringUtil.isBlank(string = writtenBookContent.title().raw())) {
            return Component.literal(string);
        }
        return null;
    }

    public Component getItemName() {
        return this.getItem().getName(this);
    }

    public Component getStyledHoverName() {
        MutableComponent mutableComponent = Component.empty().append(this.getHoverName()).withStyle(this.getRarity().color());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            mutableComponent.withStyle(ChatFormatting.ITALIC);
        }
        return mutableComponent;
    }

    public <T extends TooltipProvider> void addToTooltip(DataComponentType<T> component, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        TooltipProvider tooltipProvider = (TooltipProvider)this.get(component);
        if (tooltipProvider != null && tooltipDisplay.shows(component)) {
            tooltipProvider.addToTooltip(context, tooltipAdder, tooltipFlag, this.components);
        }
    }

    public List<Component> getTooltipLines(Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        TooltipDisplay tooltipDisplay = this.getOrDefault(DataComponents.TOOLTIP_DISPLAY, TooltipDisplay.DEFAULT);
        if (!tooltipFlag.isCreative() && tooltipDisplay.hideTooltip()) {
            boolean shouldPrintOpWarning = this.getItem().shouldPrintOpWarning(this, player);
            return shouldPrintOpWarning ? OP_NBT_WARNING : List.of();
        }
        ArrayList list = Lists.newArrayList();
        list.add(this.getStyledHoverName());
        this.addDetailsToTooltip(tooltipContext, tooltipDisplay, player, tooltipFlag, list::add);
        return list;
    }

    public void addDetailsToTooltip(Item.TooltipContext context, TooltipDisplay tooltipDisplay, @Nullable Player playef, TooltipFlag tooltipFlag, Consumer<Component> tooltipAdder) {
        boolean shouldPrintOpWarning;
        AdventureModePredicate adventureModePredicate1;
        AdventureModePredicate adventureModePredicate;
        this.getItem().appendHoverText(this, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.TROPICAL_FISH_PATTERN, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.INSTRUMENT, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.MAP_ID, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.BEES, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.CONTAINER_LOOT, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.CONTAINER, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.BANNER_PATTERNS, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.POT_DECORATIONS, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.WRITTEN_BOOK_CONTENT, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.CHARGED_PROJECTILES, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.FIREWORKS, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.FIREWORK_EXPLOSION, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.POTION_CONTENTS, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.JUKEBOX_PLAYABLE, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.TRIM, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.STORED_ENCHANTMENTS, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.ENCHANTMENTS, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.DYED_COLOR, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.LORE, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addAttributeTooltips(tooltipAdder, tooltipDisplay, playef);
        if (this.has(DataComponents.UNBREAKABLE) && tooltipDisplay.shows(DataComponents.UNBREAKABLE)) {
            tooltipAdder.accept(UNBREAKABLE_TOOLTIP);
        }
        this.addToTooltip(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.SUSPICIOUS_STEW_EFFECTS, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.addToTooltip(DataComponents.BLOCK_STATE, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        if ((this.is(Items.SPAWNER) || this.is(Items.TRIAL_SPAWNER)) && tooltipDisplay.shows(DataComponents.BLOCK_ENTITY_DATA)) {
            CustomData customData = this.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY);
            Spawner.appendHoverText(customData, tooltipAdder, "SpawnData");
        }
        if ((adventureModePredicate = this.get(DataComponents.CAN_BREAK)) != null && tooltipDisplay.shows(DataComponents.CAN_BREAK)) {
            tooltipAdder.accept(CommonComponents.EMPTY);
            tooltipAdder.accept(AdventureModePredicate.CAN_BREAK_HEADER);
            adventureModePredicate.addToTooltip(tooltipAdder);
        }
        if ((adventureModePredicate1 = this.get(DataComponents.CAN_PLACE_ON)) != null && tooltipDisplay.shows(DataComponents.CAN_PLACE_ON)) {
            tooltipAdder.accept(CommonComponents.EMPTY);
            tooltipAdder.accept(AdventureModePredicate.CAN_PLACE_HEADER);
            adventureModePredicate1.addToTooltip(tooltipAdder);
        }
        if (tooltipFlag.isAdvanced()) {
            if (this.isDamaged() && tooltipDisplay.shows(DataComponents.DAMAGE)) {
                tooltipAdder.accept(Component.translatable("item.durability", this.getMaxDamage() - this.getDamageValue(), this.getMaxDamage()));
            }
            tooltipAdder.accept(Component.literal(BuiltInRegistries.ITEM.getKey(this.getItem()).toString()).withStyle(ChatFormatting.DARK_GRAY));
            int size = this.components.size();
            if (size > 0) {
                tooltipAdder.accept(Component.translatable("item.components", size).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        if (playef != null && !this.getItem().isEnabled(playef.level().enabledFeatures())) {
            tooltipAdder.accept(DISABLED_ITEM_TOOLTIP);
        }
        if (shouldPrintOpWarning = this.getItem().shouldPrintOpWarning(this, playef)) {
            OP_NBT_WARNING.forEach(tooltipAdder);
        }
    }

    private void addAttributeTooltips(Consumer<Component> tooltipAdder, TooltipDisplay tooltipDisplay, @Nullable Player player) {
        if (tooltipDisplay.shows(DataComponents.ATTRIBUTE_MODIFIERS)) {
            for (EquipmentSlotGroup equipmentSlotGroup : EquipmentSlotGroup.values()) {
                MutableBoolean mutableBoolean = new MutableBoolean(true);
                this.forEachModifier(equipmentSlotGroup, (Holder<Attribute> attribute, AttributeModifier modifier) -> {
                    if (mutableBoolean.isTrue()) {
                        tooltipAdder.accept(CommonComponents.EMPTY);
                        tooltipAdder.accept(Component.translatable("item.modifiers." + equipmentSlotGroup.getSerializedName()).withStyle(ChatFormatting.GRAY));
                        mutableBoolean.setFalse();
                    }
                    this.addModifierTooltip(tooltipAdder, player, (Holder<Attribute>)attribute, (AttributeModifier)modifier);
                });
            }
        }
    }

    private void addModifierTooltip(Consumer<Component> tooltipAdder, @Nullable Player player, Holder<Attribute> attribute, AttributeModifier modifier) {
        double amount = modifier.amount();
        boolean flag = false;
        if (player != null) {
            if (modifier.is(Item.BASE_ATTACK_DAMAGE_ID)) {
                amount += player.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                flag = true;
            } else if (modifier.is(Item.BASE_ATTACK_SPEED_ID)) {
                amount += player.getAttributeBaseValue(Attributes.ATTACK_SPEED);
                flag = true;
            }
        }
        double d = modifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || modifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? amount * 100.0 : (attribute.is(Attributes.KNOCKBACK_RESISTANCE) ? amount * 10.0 : amount);
        if (flag) {
            tooltipAdder.accept(CommonComponents.space().append(Component.translatable("attribute.modifier.equals." + modifier.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d), Component.translatable(attribute.value().getDescriptionId()))).withStyle(ChatFormatting.DARK_GREEN));
        } else if (amount > 0.0) {
            tooltipAdder.accept(Component.translatable("attribute.modifier.plus." + modifier.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d), Component.translatable(attribute.value().getDescriptionId())).withStyle(attribute.value().getStyle(true)));
        } else if (amount < 0.0) {
            tooltipAdder.accept(Component.translatable("attribute.modifier.take." + modifier.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-d), Component.translatable(attribute.value().getDescriptionId())).withStyle(attribute.value().getStyle(false)));
        }
    }

    public boolean hasFoil() {
        Boolean _boolean = this.get(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        return _boolean != null ? _boolean.booleanValue() : this.getItem().isFoil(this);
    }

    public Rarity getRarity() {
        Rarity rarity = this.getOrDefault(DataComponents.RARITY, Rarity.COMMON);
        if (!this.isEnchanted()) {
            return rarity;
        }
        return switch (rarity) {
            case Rarity.COMMON, Rarity.UNCOMMON -> Rarity.RARE;
            case Rarity.RARE -> Rarity.EPIC;
            default -> rarity;
        };
    }

    public boolean isEnchantable() {
        if (!this.has(DataComponents.ENCHANTABLE)) {
            return false;
        }
        ItemEnchantments itemEnchantments = this.get(DataComponents.ENCHANTMENTS);
        return itemEnchantments != null && itemEnchantments.isEmpty();
    }

    public void enchant(Holder<Enchantment> enchantment, int level) {
        EnchantmentHelper.updateEnchantments(this, enchantments -> enchantments.upgrade(enchantment, level));
    }

    public boolean isEnchanted() {
        return !this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public ItemEnchantments getEnchantments() {
        return this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
    }

    public boolean isFramed() {
        return this.entityRepresentation instanceof ItemFrame;
    }

    public void setEntityRepresentation(@Nullable net.minecraft.world.entity.Entity entity) {
        if (!this.isEmpty()) {
            this.entityRepresentation = entity;
        }
    }

    @Nullable
    public ItemFrame getFrame() {
        return this.entityRepresentation instanceof ItemFrame ? (ItemFrame)this.getEntityRepresentation() : null;
    }

    @Nullable
    public net.minecraft.world.entity.Entity getEntityRepresentation() {
        return !this.isEmpty() ? this.entityRepresentation : null;
    }

    public void forEachModifier(EquipmentSlotGroup slotGroup, BiConsumer<Holder<Attribute>, AttributeModifier> action) {
        ItemAttributeModifiers itemAttributeModifiers = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        itemAttributeModifiers.forEach(slotGroup, action);
        EnchantmentHelper.forEachModifier(this, slotGroup, action);
    }

    public void forEachModifier(EquipmentSlot equipmentSLot, BiConsumer<Holder<Attribute>, AttributeModifier> action) {
        ItemAttributeModifiers itemAttributeModifiers = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        itemAttributeModifiers.forEach(equipmentSLot, action);
        EnchantmentHelper.forEachModifier(this, equipmentSLot, action);
    }

    @Deprecated
    public void setItem(Item item) {
        this.bukkitStack = null;
        this.item = item;
        DataComponentPatch patch = this.getComponentsPatch();
        this.components = new PatchedDataComponentMap(this.item.components());
        this.applyComponents(patch);
    }

    public Component getDisplayName() {
        MutableComponent mutableComponent = Component.empty().append(this.getHoverName());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            mutableComponent.withStyle(ChatFormatting.ITALIC);
        }
        MutableComponent mutableComponent1 = ComponentUtils.wrapInSquareBrackets(mutableComponent);
        if (!this.isEmpty()) {
            mutableComponent1.withStyle(this.getRarity().color()).withStyle(style -> style.withHoverEvent(new HoverEvent.ShowItem(this)));
        }
        return mutableComponent1;
    }

    public boolean canPlaceOnBlockInAdventureMode(BlockInWorld block) {
        AdventureModePredicate adventureModePredicate = this.get(DataComponents.CAN_PLACE_ON);
        return adventureModePredicate != null && adventureModePredicate.test(block);
    }

    public boolean canBreakBlockInAdventureMode(BlockInWorld block) {
        AdventureModePredicate adventureModePredicate = this.get(DataComponents.CAN_BREAK);
        return adventureModePredicate != null && adventureModePredicate.test(block);
    }

    public int getPopTime() {
        return this.popTime;
    }

    public void setPopTime(int popTime) {
        this.popTime = popTime;
    }

    public int getCount() {
        return this.isEmpty() ? 0 : this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void limitSize(int maxSize) {
        if (!this.isEmpty() && this.getCount() > maxSize) {
            this.setCount(maxSize);
        }
    }

    public void grow(int increment) {
        this.setCount(this.getCount() + increment);
    }

    public void shrink(int decrement) {
        this.grow(-decrement);
    }

    public void consume(int amount, @Nullable LivingEntity entity) {
        if (!(entity != null && entity.hasInfiniteMaterials() || this == EMPTY)) {
            this.shrink(amount);
        }
    }

    public ItemStack consumeAndReturn(int amount, @Nullable LivingEntity entity) {
        ItemStack itemStack = this.copyWithCount(amount);
        this.consume(amount, entity);
        return itemStack;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, int remainingUseDuration) {
        Consumable consumable = this.get(DataComponents.CONSUMABLE);
        if (consumable != null && consumable.shouldEmitParticlesAndSounds(remainingUseDuration)) {
            consumable.emitParticlesAndSounds(livingEntity.getRandom(), livingEntity, this, 5);
        }
        this.getItem().onUseTick(level, livingEntity, this, remainingUseDuration);
    }

    public void onDestroyed(ItemEntity itemEntity) {
        this.getItem().onDestroyed(itemEntity);
    }

    public boolean canBeHurtBy(DamageSource damageSource) {
        DamageResistant damageResistant = this.get(DataComponents.DAMAGE_RESISTANT);
        return damageResistant == null || !damageResistant.isResistantTo(damageSource);
    }

    public boolean isValidRepairItem(ItemStack item) {
        Repairable repairable = this.get(DataComponents.REPAIRABLE);
        return repairable != null && repairable.isValidRepairItem(item);
    }

    public boolean canDestroyBlock(net.minecraft.world.level.block.state.BlockState state, Level level, BlockPos pos, Player player) {
        return this.getItem().canDestroyBlock(this, state, level, pos, player);
    }
}

