/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.state.BlockState;

public class ScaffoldingBlockItem
extends BlockItem {
    public ScaffoldingBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        Block block;
        BlockPos clickedPos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(clickedPos);
        if (!blockState.is(block = this.getBlock())) {
            return ScaffoldingBlock.getDistance(level, clickedPos) == 7 ? null : context;
        }
        Direction direction = context.isSecondaryUseActive() ? (context.isInside() ? context.getClickedFace().getOpposite() : context.getClickedFace()) : (context.getClickedFace() == Direction.UP ? context.getHorizontalDirection() : Direction.UP);
        int i = 0;
        BlockPos.MutableBlockPos mutableBlockPos = clickedPos.mutable().move(direction);
        while (i < 7) {
            if (!level.isClientSide && !level.isInWorldBounds(mutableBlockPos)) {
                Player player = context.getPlayer();
                int maxY = level.getMaxY();
                if (!(player instanceof ServerPlayer) || mutableBlockPos.getY() <= maxY) break;
                ((ServerPlayer)player).sendSystemMessage(Component.translatable("build.tooHigh", maxY).withStyle(ChatFormatting.RED), true);
                break;
            }
            blockState = level.getBlockState(mutableBlockPos);
            if (!blockState.is(this.getBlock())) {
                if (!blockState.canBeReplaced(context)) break;
                return BlockPlaceContext.at(context, mutableBlockPos, direction);
            }
            mutableBlockPos.move(direction);
            if (!direction.getAxis().isHorizontal()) continue;
            ++i;
        }
        return null;
    }

    @Override
    protected boolean mustSurvive() {
        return false;
    }
}

