/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SpawnEggItem
extends Item {
    private static final Map<EntityType<? extends Mob>, SpawnEggItem> BY_ID = Maps.newIdentityHashMap();
    private final EntityType<?> defaultType;

    public SpawnEggItem(EntityType<? extends Mob> defaultType, Item.Properties properties) {
        super(properties);
        this.defaultType = defaultType;
        BY_ID.put(defaultType, this);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemInHand = context.getItemInHand();
        BlockPos clickedPos = context.getClickedPos();
        Direction clickedFace = context.getClickedFace();
        BlockState blockState = level.getBlockState(clickedPos);
        BlockEntity blockEntity = level.getBlockEntity(clickedPos);
        if (blockEntity instanceof Spawner) {
            Spawner spawner = (Spawner)((Object)blockEntity);
            if (level.paperConfig().entities.spawning.disableMobSpawnerSpawnEggTransformation) {
                return InteractionResult.FAIL;
            }
            EntityType<?> type = this.getType(level.registryAccess(), itemInHand);
            spawner.setEntityId(type, level.getRandom());
            level.sendBlockUpdated(clickedPos, blockState, blockState, 3);
            level.gameEvent((Entity)context.getPlayer(), GameEvent.BLOCK_CHANGE, clickedPos);
            itemInHand.shrink(1);
            return InteractionResult.SUCCESS;
        }
        BlockPos blockPos = blockState.getCollisionShape(level, clickedPos).isEmpty() ? clickedPos : clickedPos.relative(clickedFace);
        EntityType<?> type = this.getType(level.registryAccess(), itemInHand);
        if (type.spawn((ServerLevel)level, itemInHand, context.getPlayer(), blockPos, EntitySpawnReason.SPAWN_ITEM_USE, true, !Objects.equals(clickedPos, blockPos) && clickedFace == Direction.UP) != null) {
            itemInHand.shrink(1);
            level.gameEvent((Entity)context.getPlayer(), GameEvent.ENTITY_PLACE, clickedPos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        BlockHitResult playerPovHitResult = SpawnEggItem.getPlayerPOVHitResult(level, player, ClipContext.Fluid.SOURCE_ONLY);
        if (playerPovHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = playerPovHitResult.getBlockPos();
            if (!(level.getBlockState(blockPos).getBlock() instanceof LiquidBlock)) {
                return InteractionResult.PASS;
            }
            if (level.mayInteract(player, blockPos) && player.mayUseItemAt(blockPos, playerPovHitResult.getDirection(), itemInHand)) {
                EntityType<?> type = this.getType(serverLevel.registryAccess(), itemInHand);
                Object entity = type.spawn(serverLevel, itemInHand, player, blockPos, EntitySpawnReason.SPAWN_ITEM_USE, false, false);
                if (entity == null) {
                    return InteractionResult.PASS;
                }
                itemInHand.consume(1, player);
                player.awardStat(Stats.ITEM_USED.get(this));
                level.gameEvent((Entity)player, GameEvent.ENTITY_PLACE, ((Entity)entity).position());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean spawnsEntity(HolderLookup.Provider registries, ItemStack stack, EntityType<?> entityType) {
        return Objects.equals(this.getType(registries, stack), entityType);
    }

    @Nullable
    public static SpawnEggItem byId(@Nullable EntityType<?> type) {
        return BY_ID.get(type);
    }

    public static Iterable<SpawnEggItem> eggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }

    public EntityType<?> getType(HolderLookup.Provider registries, ItemStack provider) {
        EntityType<?> entityType;
        CustomData customData = provider.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
        if (!customData.isEmpty() && (entityType = customData.parseEntityType(registries, Registries.ENTITY_TYPE)) != null) {
            return entityType;
        }
        return this.defaultType;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.defaultType.requiredFeatures();
    }

    public Optional<Mob> spawnOffspringFromSpawnEgg(Player player, Mob mob, EntityType<? extends Mob> entityType, ServerLevel serverLevel, Vec3 pos, ItemStack stack) {
        if (!this.spawnsEntity(serverLevel.registryAccess(), stack, entityType)) {
            return Optional.empty();
        }
        Mob breedOffspring = mob instanceof AgeableMob ? ((AgeableMob)mob).getBreedOffspring(serverLevel, (AgeableMob)mob) : entityType.create(serverLevel, EntitySpawnReason.SPAWN_ITEM_USE);
        if (breedOffspring == null) {
            return Optional.empty();
        }
        breedOffspring.setBaby(true);
        if (!breedOffspring.isBaby()) {
            return Optional.empty();
        }
        breedOffspring.snapTo(pos.x(), pos.y(), pos.z(), 0.0f, 0.0f);
        breedOffspring.applyComponentsFromItemStack(stack);
        serverLevel.addFreshEntityWithPassengers(breedOffspring, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        stack.consume(1, player);
        return Optional.of(breedOffspring);
    }

    @Override
    public boolean shouldPrintOpWarning(ItemStack stack, @Nullable Player player) {
        CustomData customData;
        if (player != null && player.getPermissionLevel() >= 2 && (customData = stack.get(DataComponents.ENTITY_DATA)) != null) {
            EntityType<?> entityType = customData.parseEntityType(player.level().registryAccess(), Registries.ENTITY_TYPE);
            return entityType != null && entityType.onlyOpCanSetNbt();
        }
        return false;
    }
}

