/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.consume_effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.player.PlayerTeleportEvent;

public record TeleportRandomlyConsumeEffect(float diameter) implements ConsumeEffect
{
    private static final float DEFAULT_DIAMETER = 16.0f;
    public static final MapCodec<TeleportRandomlyConsumeEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("diameter", (Object)Float.valueOf(16.0f)).forGetter(TeleportRandomlyConsumeEffect::diameter)).apply((Applicative)instance, TeleportRandomlyConsumeEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TeleportRandomlyConsumeEffect> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, TeleportRandomlyConsumeEffect::diameter, TeleportRandomlyConsumeEffect::new);

    public TeleportRandomlyConsumeEffect() {
        this(16.0f);
    }

    public ConsumeEffect.Type<TeleportRandomlyConsumeEffect> getType() {
        return ConsumeEffect.Type.TELEPORT_RANDOMLY;
    }

    @Override
    public boolean apply(Level level, ItemStack stack, LivingEntity entity) {
        boolean flag = false;
        for (int i = 0; i < 16; ++i) {
            SoundSource soundSource;
            SoundEvent soundEvent;
            double d = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * (double)this.diameter;
            double d1 = Mth.clamp(entity.getY() + (entity.getRandom().nextDouble() - 0.5) * (double)this.diameter, (double)level.getMinY(), (double)(level.getMinY() + ((ServerLevel)level).getLogicalHeight() - 1));
            double d2 = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * (double)this.diameter;
            if (entity.isPassenger()) {
                entity.stopRiding();
            }
            Vec3 vec3 = entity.position();
            Optional<Boolean> status = entity.randomTeleport(d, d1, d2, true, PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT);
            if (status.isEmpty()) break;
            if (!status.get().booleanValue()) continue;
            level.gameEvent(GameEvent.TELEPORT, vec3, GameEvent.Context.of(entity));
            if (entity instanceof Fox) {
                soundEvent = SoundEvents.FOX_TELEPORT;
                soundSource = SoundSource.NEUTRAL;
            } else {
                soundEvent = SoundEvents.CHORUS_FRUIT_TELEPORT;
                soundSource = SoundSource.PLAYERS;
            }
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), soundEvent, soundSource);
            entity.resetFallDistance();
            flag = true;
            break;
        }
        if (flag && entity instanceof Player) {
            Player player = (Player)entity;
            player.resetCurrentImpulseContext();
        }
        return flag;
    }
}

