/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record SpawnParticlesEffect(ParticleOptions particle, PositionSource horizontalPosition, PositionSource verticalPosition, VelocitySource horizontalVelocity, VelocitySource verticalVelocity, FloatProvider speed) implements EnchantmentEntityEffect
{
    public static final MapCodec<SpawnParticlesEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ParticleTypes.CODEC.fieldOf("particle").forGetter(SpawnParticlesEffect::particle), (App)PositionSource.CODEC.fieldOf("horizontal_position").forGetter(SpawnParticlesEffect::horizontalPosition), (App)PositionSource.CODEC.fieldOf("vertical_position").forGetter(SpawnParticlesEffect::verticalPosition), (App)VelocitySource.CODEC.fieldOf("horizontal_velocity").forGetter(SpawnParticlesEffect::horizontalVelocity), (App)VelocitySource.CODEC.fieldOf("vertical_velocity").forGetter(SpawnParticlesEffect::verticalVelocity), (App)FloatProvider.CODEC.optionalFieldOf("speed", (Object)ConstantFloat.ZERO).forGetter(SpawnParticlesEffect::speed)).apply((Applicative)instance, SpawnParticlesEffect::new));

    public static PositionSource offsetFromEntityPosition(float offset) {
        return new PositionSource(PositionSourceType.ENTITY_POSITION, offset, 1.0f);
    }

    public static PositionSource inBoundingBox() {
        return new PositionSource(PositionSourceType.BOUNDING_BOX, 0.0f, 1.0f);
    }

    public static VelocitySource movementScaled(float movementScale) {
        return new VelocitySource(movementScale, ConstantFloat.ZERO);
    }

    public static VelocitySource fixedVelocity(FloatProvider velocity) {
        return new VelocitySource(0.0f, velocity);
    }

    @Override
    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3 origin) {
        RandomSource random = entity.getRandom();
        Vec3 knownMovement = entity.getKnownMovement();
        float bbWidth = entity.getBbWidth();
        float bbHeight = entity.getBbHeight();
        level.sendParticlesSource(entity, this.particle, false, false, this.horizontalPosition.getCoordinate(origin.x(), origin.x(), bbWidth, random), this.verticalPosition.getCoordinate(origin.y(), origin.y() + (double)(bbHeight / 2.0f), bbHeight, random), this.horizontalPosition.getCoordinate(origin.z(), origin.z(), bbWidth, random), 0, this.horizontalVelocity.getVelocity(knownMovement.x(), random), this.verticalVelocity.getVelocity(knownMovement.y(), random), this.horizontalVelocity.getVelocity(knownMovement.z(), random), this.speed.sample(random));
    }

    public MapCodec<SpawnParticlesEffect> codec() {
        return CODEC;
    }

    public record PositionSource(PositionSourceType type, float offset, float scale) {
        public static final MapCodec<PositionSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PositionSourceType.CODEC.fieldOf("type").forGetter(PositionSource::type), (App)Codec.FLOAT.optionalFieldOf("offset", (Object)Float.valueOf(0.0f)).forGetter(PositionSource::offset), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(PositionSource::scale)).apply((Applicative)instance, PositionSource::new)).validate(sourceType -> sourceType.type() == PositionSourceType.ENTITY_POSITION && sourceType.scale() != 1.0f ? DataResult.error(() -> "Cannot scale an entity position coordinate source") : DataResult.success((Object)sourceType));

        public double getCoordinate(double position, double center, float size, RandomSource random) {
            return this.type.getCoordinate(position, center, size * this.scale, random) + (double)this.offset;
        }
    }

    public record VelocitySource(float movementScale, FloatProvider base) {
        public static final MapCodec<VelocitySource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("movement_scale", (Object)Float.valueOf(0.0f)).forGetter(VelocitySource::movementScale), (App)FloatProvider.CODEC.optionalFieldOf("base", (Object)ConstantFloat.ZERO).forGetter(VelocitySource::base)).apply((Applicative)instance, VelocitySource::new));

        public double getVelocity(double scale, RandomSource random) {
            return scale * (double)this.movementScale + (double)this.base.sample(random);
        }
    }

    public static enum PositionSourceType implements StringRepresentable
    {
        ENTITY_POSITION("entity_position", (position, center, size, random) -> position),
        BOUNDING_BOX("in_bounding_box", (position, center, size, random) -> center + (random.nextDouble() - 0.5) * (double)size);

        public static final Codec<PositionSourceType> CODEC;
        private final String id;
        private final CoordinateSource source;

        private PositionSourceType(String id, CoordinateSource source) {
            this.id = id;
            this.source = source;
        }

        public double getCoordinate(double position, double center, float size, RandomSource random) {
            return this.source.getCoordinate(position, center, size, random);
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(PositionSourceType::values);
        }

        @FunctionalInterface
        static interface CoordinateSource {
            public double getCoordinate(double var1, double var3, float var5, RandomSource var6);
        }
    }
}

