/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.destroystokyo.paper.event.entity.PreSpawnerSpawnEvent;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.World;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.event.entity.CreatureSpawnEvent;

public abstract class BaseSpawner {
    public static final String SPAWN_DATA_TAG = "SpawnData";
    private static final int EVENT_SPAWN = 1;
    private static final int DEFAULT_SPAWN_DELAY = 20;
    private static final int DEFAULT_MIN_SPAWN_DELAY = 200;
    private static final int DEFAULT_MAX_SPAWN_DELAY = 800;
    private static final int DEFAULT_SPAWN_COUNT = 4;
    private static final int DEFAULT_MAX_NEARBY_ENTITIES = 6;
    private static final int DEFAULT_REQUIRED_PLAYER_RANGE = 16;
    private static final int DEFAULT_SPAWN_RANGE = 4;
    public int spawnDelay = 20;
    public WeightedList<SpawnData> spawnPotentials = WeightedList.of();
    @Nullable
    public SpawnData nextSpawnData;
    private double spin;
    private double oSpin;
    public int minSpawnDelay = 200;
    public int maxSpawnDelay = 800;
    public int spawnCount = 4;
    @Nullable
    private Entity displayEntity;
    public int maxNearbyEntities = 6;
    public int requiredPlayerRange = 16;
    public int spawnRange = 4;
    private int tickDelay = 0;

    public void setEntityId(EntityType<?> type, @Nullable Level level, RandomSource random, BlockPos pos) {
        this.getOrCreateNextSpawnData(level, random, pos).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(type).toString());
        this.spawnPotentials = WeightedList.of();
    }

    public boolean isNearPlayer(Level level, BlockPos pos) {
        return level.hasNearbyAlivePlayerThatAffectsSpawning((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, this.requiredPlayerRange);
    }

    public void clientTick(Level level, BlockPos pos) {
        if (!this.isNearPlayer(level, pos)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            RandomSource random = level.getRandom();
            double d = (double)pos.getX() + random.nextDouble();
            double d1 = (double)pos.getY() + random.nextDouble();
            double d2 = (double)pos.getZ() + random.nextDouble();
            level.addParticle(ParticleTypes.SMOKE, d, d1, d2, 0.0, 0.0, 0.0);
            level.addParticle(ParticleTypes.FLAME, d, d1, d2, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(ServerLevel serverLevel, BlockPos pos) {
        if (this.spawnCount <= 0 || this.maxNearbyEntities <= 0) {
            return;
        }
        if (this.spawnDelay > 0 && --this.tickDelay > 0) {
            return;
        }
        this.tickDelay = serverLevel.paperConfig().tickRates.mobSpawner;
        if (this.tickDelay == -1) {
            return;
        }
        if (this.isNearPlayer(serverLevel, pos)) {
            if (this.spawnDelay < -this.tickDelay) {
                this.delay(serverLevel, pos);
            }
            if (this.spawnDelay > 0) {
                this.spawnDelay -= this.tickDelay;
            } else {
                boolean flag = false;
                RandomSource random = serverLevel.getRandom();
                SpawnData nextSpawnData = this.getOrCreateNextSpawnData(serverLevel, random, pos);
                for (int i = 0; i < this.spawnCount; ++i) {
                    SpawnData.CustomSpawnRules customSpawnRules;
                    CompoundTag entityToSpawn = nextSpawnData.getEntityToSpawn();
                    Optional<EntityType<?>> optional = EntityType.by(entityToSpawn);
                    if (optional.isEmpty()) {
                        this.delay(serverLevel, pos);
                        return;
                    }
                    Vec3 vec3 = entityToSpawn.read("Pos", Vec3.CODEC).orElseGet(() -> new Vec3((double)pos.getX() + (random.nextDouble() - random.nextDouble()) * (double)this.spawnRange + 0.5, pos.getY() + random.nextInt(3) - 1, (double)pos.getZ() + (random.nextDouble() - random.nextDouble()) * (double)this.spawnRange + 0.5));
                    if (!serverLevel.noCollision(optional.get().getSpawnAABB(vec3.x, vec3.y, vec3.z))) continue;
                    BlockPos blockPos = BlockPos.containing(vec3);
                    if (!nextSpawnData.getCustomSpawnRules().isPresent() ? !SpawnPlacements.checkSpawnRules(optional.get(), serverLevel, EntitySpawnReason.SPAWNER, blockPos, serverLevel.getRandom()) : !optional.get().getCategory().isFriendly() && serverLevel.getDifficulty() == Difficulty.PEACEFUL || !(customSpawnRules = nextSpawnData.getCustomSpawnRules().get()).isValidPosition(blockPos, serverLevel)) continue;
                    PreSpawnerSpawnEvent event = new PreSpawnerSpawnEvent(CraftLocation.toBukkit(vec3, (World)serverLevel.getWorld()), CraftEntityType.minecraftToBukkit(optional.get()), CraftLocation.toBukkit(pos, (Level)serverLevel));
                    if (!event.callEvent()) {
                        flag = true;
                        if (!event.shouldAbortSpawn()) continue;
                        break;
                    }
                    Entity entity = EntityType.loadEntityRecursive(entityToSpawn, serverLevel, EntitySpawnReason.SPAWNER, entity1 -> {
                        entity1.snapTo(vec3.x, vec3.y, vec3.z, entity1.getYRot(), entity1.getXRot());
                        return entity1;
                    });
                    if (entity == null) {
                        this.delay(serverLevel, pos);
                        return;
                    }
                    int size = serverLevel.getEntities(EntityTypeTest.forExactClass(entity.getClass()), new AABB(pos.getX(), pos.getY(), pos.getZ(), pos.getX() + 1, pos.getY() + 1, pos.getZ() + 1).inflate(this.spawnRange), EntitySelector.NO_SPECTATORS).size();
                    if (size >= this.maxNearbyEntities) {
                        this.delay(serverLevel, pos);
                        return;
                    }
                    entity.preserveMotion = true;
                    entity.snapTo(entity.getX(), entity.getY(), entity.getZ(), random.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof Mob) {
                        boolean flag1;
                        Mob mob = (Mob)entity;
                        if (nextSpawnData.getCustomSpawnRules().isEmpty() && !mob.checkSpawnRules(serverLevel, EntitySpawnReason.SPAWNER) || !mob.checkSpawnObstruction(serverLevel)) continue;
                        boolean bl = flag1 = nextSpawnData.getEntityToSpawn().size() == 1 && nextSpawnData.getEntityToSpawn().getString("id").isPresent();
                        if (flag1) {
                            ((Mob)entity).finalizeSpawn(serverLevel, serverLevel.getCurrentDifficultyAt(entity.blockPosition()), EntitySpawnReason.SPAWNER, null);
                        }
                        nextSpawnData.getEquipment().ifPresent(mob::equip);
                        if (mob.level().spigotConfig.nerfSpawnerMobs) {
                            mob.aware = false;
                        }
                    }
                    entity.spawnedViaMobSpawner = true;
                    entity.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                    flag = true;
                    if (CraftEventFactory.callSpawnerSpawnEvent(entity, pos).isCancelled()) continue;
                    if (!serverLevel.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                        this.delay(serverLevel, pos);
                        return;
                    }
                    serverLevel.levelEvent(2004, pos, 0);
                    serverLevel.gameEvent(entity, GameEvent.ENTITY_PLACE, blockPos);
                    if (!(entity instanceof Mob)) continue;
                    ((Mob)entity).spawnAnim();
                }
                if (flag) {
                    this.delay(serverLevel, pos);
                }
            }
        }
    }

    public void delay(Level level, BlockPos pos) {
        RandomSource randomSource = level.random;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + randomSource.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom(randomSource).ifPresent(spawnData -> this.setNextSpawnData(level, pos, (SpawnData)spawnData));
        this.broadcastEvent(level, pos, 1);
    }

    public void load(@Nullable Level level, BlockPos pos, CompoundTag tag) {
        this.spawnDelay = tag.getIntOr("Paper.Delay", tag.getShortOr("Delay", (short)20));
        tag.read(SPAWN_DATA_TAG, SpawnData.CODEC).ifPresent(spawnData -> this.setNextSpawnData(level, pos, (SpawnData)spawnData));
        this.spawnPotentials = tag.read("SpawnPotentials", SpawnData.LIST_CODEC).orElseGet(() -> WeightedList.of(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData()));
        this.minSpawnDelay = tag.getIntOr("Paper.MinSpawnDelay", tag.getIntOr("MinSpawnDelay", 200));
        this.maxSpawnDelay = tag.getIntOr("Paper.MaxSpawnDelay", tag.getIntOr("MaxSpawnDelay", 800));
        this.spawnCount = tag.getIntOr("SpawnCount", 4);
        this.maxNearbyEntities = tag.getIntOr("MaxNearbyEntities", 6);
        this.requiredPlayerRange = tag.getIntOr("RequiredPlayerRange", 16);
        this.spawnRange = tag.getIntOr("SpawnRange", 4);
        this.displayEntity = null;
    }

    public CompoundTag save(CompoundTag tag) {
        if (this.spawnDelay > Short.MAX_VALUE) {
            tag.putInt("Paper.Delay", this.spawnDelay);
        }
        tag.putShort("Delay", (short)Math.min(Short.MAX_VALUE, this.spawnDelay));
        if (this.minSpawnDelay > Short.MAX_VALUE || this.maxSpawnDelay > Short.MAX_VALUE) {
            tag.putInt("Paper.MinSpawnDelay", this.minSpawnDelay);
            tag.putInt("Paper.MaxSpawnDelay", this.maxSpawnDelay);
        }
        tag.putShort("MinSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.minSpawnDelay));
        tag.putShort("MaxSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.maxSpawnDelay));
        tag.putShort("SpawnCount", (short)this.spawnCount);
        tag.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        tag.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        tag.putShort("SpawnRange", (short)this.spawnRange);
        tag.storeNullable(SPAWN_DATA_TAG, SpawnData.CODEC, this.nextSpawnData);
        tag.store("SpawnPotentials", SpawnData.LIST_CODEC, this.spawnPotentials);
        return tag;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level level, BlockPos pos) {
        if (this.displayEntity == null) {
            CompoundTag entityToSpawn = this.getOrCreateNextSpawnData(level, level.getRandom(), pos).getEntityToSpawn();
            if (entityToSpawn.getString("id").isEmpty()) {
                return null;
            }
            this.displayEntity = EntityType.loadEntityRecursive(entityToSpawn, level, EntitySpawnReason.SPAWNER, Function.identity());
            if (entityToSpawn.size() != 1 || this.displayEntity instanceof Mob) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(Level level, int id) {
        if (id == 1) {
            if (level.isClientSide) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    public void setNextSpawnData(@Nullable Level level, BlockPos pos, SpawnData nextSpawnData) {
        this.nextSpawnData = nextSpawnData;
    }

    private SpawnData getOrCreateNextSpawnData(@Nullable Level level, RandomSource random, BlockPos pos) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(level, pos, this.spawnPotentials.getRandom(random).orElseGet(SpawnData::new));
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(Level var1, BlockPos var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }
}

