/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevelReader;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public interface LevelReader
extends ChunkSystemLevelReader,
BlockAndTintGetter,
CollisionGetter,
SignalGetter,
BiomeManager.NoiseBiomeSource {
    @Override
    default public ChunkAccess moonrise$syncLoadNonFull(int chunkX, int chunkZ, ChunkStatus status) {
        if (status == null || status.isOrAfter(ChunkStatus.FULL)) {
            throw new IllegalArgumentException("Status: " + status.toString());
        }
        return this.getChunk(chunkX, chunkZ, status, true);
    }

    @Nullable
    public ChunkAccess getChunk(int var1, int var2, ChunkStatus var3, boolean var4);

    @Nullable
    public ChunkAccess getChunkIfLoadedImmediately(int var1, int var2);

    @Nullable
    default public ChunkAccess getChunkIfLoadedImmediately(BlockPos pos) {
        return this.getChunkIfLoadedImmediately(pos.getX() >> 4, pos.getZ() >> 4);
    }

    @Deprecated
    public boolean hasChunk(int var1, int var2);

    public int getHeight(Heightmap.Types var1, int var2, int var3);

    default public int getHeight(Heightmap.Types heightmapType, BlockPos pos) {
        return this.getHeight(heightmapType, pos.getX(), pos.getZ());
    }

    public int getSkyDarken();

    public BiomeManager getBiomeManager();

    default public Holder<Biome> getBiome(BlockPos pos) {
        return this.getBiomeManager().getBiome(pos);
    }

    default public Stream<BlockState> getBlockStatesIfLoaded(AABB aabb) {
        int floor5;
        int floor = Mth.floor(aabb.minX);
        int floor1 = Mth.floor(aabb.maxX);
        int floor2 = Mth.floor(aabb.minY);
        int floor3 = Mth.floor(aabb.maxY);
        int floor4 = Mth.floor(aabb.minZ);
        return this.hasChunksAt(floor, floor2, floor4, floor1, floor3, floor5 = Mth.floor(aabb.maxZ)) ? this.getBlockStates(aabb) : Stream.empty();
    }

    @Override
    default public int getBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        return colorResolver.getColor(this.getBiome(blockPos).value(), blockPos.getX(), blockPos.getZ());
    }

    @Override
    default public Holder<Biome> getNoiseBiome(int x, int y, int z) {
        ChunkAccess chunk = this.getChunk(QuartPos.toSection(x), QuartPos.toSection(z), ChunkStatus.BIOMES, false);
        return chunk != null ? chunk.getNoiseBiome(x, y, z) : this.getUncachedNoiseBiome(x, y, z);
    }

    public Holder<Biome> getUncachedNoiseBiome(int var1, int var2, int var3);

    public boolean isClientSide();

    public int getSeaLevel();

    public DimensionType dimensionType();

    @Override
    default public int getMinY() {
        return this.dimensionType().minY();
    }

    @Override
    default public int getHeight() {
        return this.dimensionType().height();
    }

    default public BlockPos getHeightmapPos(Heightmap.Types heightmapType, BlockPos pos) {
        return new BlockPos(pos.getX(), this.getHeight(heightmapType, pos.getX(), pos.getZ()), pos.getZ());
    }

    default public boolean isEmptyBlock(BlockPos pos) {
        return this.getBlockState(pos).isAir();
    }

    default public boolean canSeeSkyFromBelowWater(BlockPos pos) {
        if (pos.getY() >= this.getSeaLevel()) {
            return this.canSeeSky(pos);
        }
        BlockPos blockPos = new BlockPos(pos.getX(), this.getSeaLevel(), pos.getZ());
        if (!this.canSeeSky(blockPos)) {
            return false;
        }
        BlockPos var4 = blockPos.below();
        while (var4.getY() > pos.getY()) {
            BlockState blockState = this.getBlockState(var4);
            if (blockState.getLightBlock() > 0 && !blockState.liquid()) {
                return false;
            }
            var4 = var4.below();
        }
        return true;
    }

    default public float getPathfindingCostFromLightLevels(BlockPos pos) {
        return this.getLightLevelDependentMagicValue(pos) - 0.5f;
    }

    @Deprecated
    default public float getLightLevelDependentMagicValue(BlockPos pos) {
        float f = (float)this.getMaxLocalRawBrightness(pos) / 15.0f;
        float f1 = f / (4.0f - 3.0f * f);
        return Mth.lerp(this.dimensionType().ambientLight(), f1, 1.0f);
    }

    default public ChunkAccess getChunk(BlockPos pos) {
        return this.getChunk(SectionPos.blockToSectionCoord(pos.getX()), SectionPos.blockToSectionCoord(pos.getZ()));
    }

    default public ChunkAccess getChunk(int chunkX, int chunkZ) {
        return this.getChunk(chunkX, chunkZ, ChunkStatus.FULL, true);
    }

    default public ChunkAccess getChunk(int chunkX, int chunkZ, ChunkStatus chunkStatus) {
        return this.getChunk(chunkX, chunkZ, chunkStatus, true);
    }

    @Override
    @Nullable
    default public BlockGetter getChunkForCollisions(int chunkX, int chunkZ) {
        return this.getChunk(chunkX, chunkZ, ChunkStatus.EMPTY, false);
    }

    default public boolean isWaterAt(BlockPos pos) {
        return this.getFluidState(pos).is(FluidTags.WATER);
    }

    default public boolean containsAnyLiquid(AABB bb) {
        int floor = Mth.floor(bb.minX);
        int ceil = Mth.ceil(bb.maxX);
        int floor1 = Mth.floor(bb.minY);
        int ceil1 = Mth.ceil(bb.maxY);
        int floor2 = Mth.floor(bb.minZ);
        int ceil2 = Mth.ceil(bb.maxZ);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = floor; i < ceil; ++i) {
            for (int i1 = floor1; i1 < ceil1; ++i1) {
                for (int i2 = floor2; i2 < ceil2; ++i2) {
                    BlockState blockState = this.getBlockState(mutableBlockPos.set(i, i1, i2));
                    if (blockState.getFluidState().isEmpty()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    default public int getMaxLocalRawBrightness(BlockPos pos) {
        return this.getMaxLocalRawBrightness(pos, this.getSkyDarken());
    }

    default public int getMaxLocalRawBrightness(BlockPos pos, int amount) {
        return pos.getX() >= -30000000 && pos.getZ() >= -30000000 && pos.getX() < 30000000 && pos.getZ() < 30000000 ? this.getRawBrightness(pos, amount) : 15;
    }

    @Deprecated
    default public boolean hasChunkAt(int x, int z) {
        return this.hasChunk(SectionPos.blockToSectionCoord(x), SectionPos.blockToSectionCoord(z));
    }

    @Deprecated
    default public boolean hasChunkAt(BlockPos pos) {
        return this.hasChunkAt(pos.getX(), pos.getZ());
    }

    @Deprecated
    default public boolean hasChunksAt(BlockPos from, BlockPos to) {
        return this.hasChunksAt(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
    }

    @Deprecated
    default public boolean hasChunksAt(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        return toY >= this.getMinY() && fromY <= this.getMaxY() && this.hasChunksAt(fromX, fromZ, toX, toZ);
    }

    @Deprecated
    default public boolean hasChunksAt(int fromX, int fromZ, int toX, int toZ) {
        int sectionPosCoord = SectionPos.blockToSectionCoord(fromX);
        int sectionPosCoord1 = SectionPos.blockToSectionCoord(toX);
        int sectionPosCoord2 = SectionPos.blockToSectionCoord(fromZ);
        int sectionPosCoord3 = SectionPos.blockToSectionCoord(toZ);
        for (int i = sectionPosCoord; i <= sectionPosCoord1; ++i) {
            for (int i1 = sectionPosCoord2; i1 <= sectionPosCoord3; ++i1) {
                if (this.hasChunk(i, i1)) continue;
                return false;
            }
        }
        return true;
    }

    public RegistryAccess registryAccess();

    public FeatureFlagSet enabledFeatures();

    default public <T> HolderLookup<T> holderLookup(ResourceKey<? extends Registry<? extends T>> registryKey) {
        HolderLookup.RegistryLookup registry = this.registryAccess().lookupOrThrow((ResourceKey)registryKey);
        return registry.filterFeatures(this.enabledFeatures());
    }
}

