/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketStorage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;

public class TicketStorage
extends SavedData
implements ChunkSystemTicketStorage {
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Pair<ChunkPos, Ticket>> TICKET_ENTRY = Codec.mapPair((MapCodec)ChunkPos.CODEC.fieldOf("chunk_pos"), Ticket.CODEC).codec();
    public static final Codec<TicketStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TICKET_ENTRY.listOf().optionalFieldOf("tickets", List.of()).forGetter(TicketStorage::packTickets)).apply((Applicative)instance, TicketStorage::fromPacked));
    public static final SavedDataType<TicketStorage> TYPE = new SavedDataType<TicketStorage>("chunks", TicketStorage::new, CODEC, DataFixTypes.SAVED_DATA_FORCED_CHUNKS);
    private final Long2ObjectOpenHashMap<List<Ticket>> deactivatedTickets;
    @Nullable
    private ChunkUpdated loadingChunkUpdatedListener;
    @Nullable
    private ChunkUpdated simulationChunkUpdatedListener;
    private ChunkMap chunkMap;

    @Override
    public final ChunkMap moonrise$getChunkMap() {
        return this.chunkMap;
    }

    @Override
    public final void moonrise$setChunkMap(ChunkMap chunkMap) {
        this.chunkMap = chunkMap;
    }

    private TicketStorage(Long2ObjectOpenHashMap<List<Ticket>> tickets, Long2ObjectOpenHashMap<List<Ticket>> deactivatedTickets) {
        this.deactivatedTickets = deactivatedTickets;
    }

    public TicketStorage() {
        this((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap());
    }

    private static TicketStorage fromPacked(List<Pair<ChunkPos, Ticket>> packed) {
        Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
        for (Pair<ChunkPos, Ticket> pair : packed) {
            ChunkPos chunkPos = (ChunkPos)pair.getFirst();
            List list = (List)map.computeIfAbsent(chunkPos.toLong(), l -> new ObjectArrayList(4));
            list.add((Ticket)pair.getSecond());
        }
        return new TicketStorage((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)map);
    }

    private List<Pair<ChunkPos, Ticket>> packTickets() {
        ArrayList<Pair<ChunkPos, Ticket>> list = new ArrayList<Pair<ChunkPos, Ticket>>();
        this.forEachTicket((chunkPos, ticket) -> {
            if (ticket.getType().persist()) {
                list.add(new Pair(chunkPos, ticket));
            }
        });
        return list;
    }

    private void redirectRegularTickets(BiConsumer<ChunkPos, Ticket> consumer, Long2ObjectOpenHashMap<List<Ticket>> ticketsParam) {
        if (ticketsParam != null) {
            throw new IllegalStateException("Bad injection point");
        }
        Long2ObjectOpenHashMap<SortedArraySet<Ticket>> tickets = this.chunkMap.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketsCopy();
        ObjectIterator iterator = tickets.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long pos = entry.getLongKey();
            SortedArraySet chunkTickets = (SortedArraySet)entry.getValue();
            ChunkPos chunkPos = new ChunkPos(pos);
            for (Ticket ticket : chunkTickets) {
                consumer.accept(chunkPos, ticket);
            }
        }
    }

    private void forEachTicket(BiConsumer<ChunkPos, Ticket> action) {
        this.redirectRegularTickets(action, null);
        TicketStorage.forEachTicket(action, this.deactivatedTickets);
    }

    private static void forEachTicket(BiConsumer<ChunkPos, Ticket> action, Long2ObjectOpenHashMap<List<Ticket>> tickets) {
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(tickets)) {
            ChunkPos chunkPos = new ChunkPos(entry.getLongKey());
            for (Ticket ticket : (List)entry.getValue()) {
                action.accept(chunkPos, ticket);
            }
        }
    }

    public void activateAllDeactivatedTickets() {
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.deactivatedTickets)) {
            for (Ticket ticket : (List)entry.getValue()) {
                this.addTicket(entry.getLongKey(), ticket);
            }
        }
        this.deactivatedTickets.clear();
    }

    public void setLoadingChunkUpdatedListener(@Nullable ChunkUpdated loadingChunkUpdatedListener) {
    }

    public void setSimulationChunkUpdatedListener(@Nullable ChunkUpdated simulationChunkUpdatedListener) {
    }

    public boolean hasTickets() {
        return this.chunkMap.level.moonrise$getChunkTaskScheduler().chunkHolderManager.hasTickets();
    }

    public List<Ticket> getTickets(long chunkPos) {
        return this.chunkMap.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketsAt(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos));
    }

    private List<Ticket> getOrCreateTickets(long chunkPos) {
        throw new UnsupportedOperationException();
    }

    public void addTicketWithRadius(TicketType ticketType, ChunkPos chunkPos, int radius) {
        Ticket ticket = new Ticket(ticketType, ChunkLevel.byStatus(FullChunkStatus.FULL) - radius);
        this.addTicket(chunkPos.toLong(), ticket);
    }

    public void addTicket(Ticket ticket, ChunkPos chunkPos) {
        this.addTicket(chunkPos.toLong(), ticket);
    }

    public boolean addTicket(long chunkPos, Ticket ticket) {
        boolean ret = this.chunkMap.level.moonrise$getChunkTaskScheduler().chunkHolderManager.addTicketAtLevel(ticket.getType(), chunkPos, ticket.getTicketLevel(), ticket.moonrise$getIdentifier());
        this.setDirty();
        return ret;
    }

    private static boolean isTicketSameTypeAndLevel(Ticket first, Ticket second) {
        return second.getType() == first.getType() && second.getTicketLevel() == first.getTicketLevel() && Objects.equals(second.getIdentifier(), first.getIdentifier());
    }

    public int getTicketLevelAt(long chunkPos, boolean requireSimulation) {
        return TicketStorage.getTicketLevelAt(this.getTickets(chunkPos), requireSimulation);
    }

    private static int getTicketLevelAt(List<Ticket> tickets, boolean requireSimulation) {
        Ticket lowestTicket = TicketStorage.getLowestTicket(tickets, requireSimulation);
        return lowestTicket == null ? ChunkLevel.MAX_LEVEL + 1 : lowestTicket.getTicketLevel();
    }

    @Nullable
    private static Ticket getLowestTicket(@Nullable List<Ticket> tickets, boolean requireSimulation) {
        if (tickets == null) {
            return null;
        }
        Ticket ticket = null;
        for (Ticket ticket1 : tickets) {
            if (ticket != null && ticket1.getTicketLevel() >= ticket.getTicketLevel()) continue;
            if (requireSimulation && ticket1.getType().doesSimulate()) {
                ticket = ticket1;
                continue;
            }
            if (requireSimulation || !ticket1.getType().doesLoad()) continue;
            ticket = ticket1;
        }
        return ticket;
    }

    public void removeTicketWithRadius(TicketType ticketType, ChunkPos chunkPos, int radius) {
        Ticket ticket = new Ticket(ticketType, ChunkLevel.byStatus(FullChunkStatus.FULL) - radius);
        this.removeTicket(chunkPos.toLong(), ticket);
    }

    public void removeTicket(Ticket ticket, ChunkPos chunkPos) {
        this.removeTicket(chunkPos.toLong(), ticket);
    }

    public boolean removeTicket(long chunkPos, Ticket ticket) {
        boolean ret = this.chunkMap.level.moonrise$getChunkTaskScheduler().chunkHolderManager.removeTicketAtLevel(ticket.getType(), chunkPos, ticket.getTicketLevel(), ticket.moonrise$getIdentifier());
        if (ret) {
            this.setDirty();
        }
        return ret;
    }

    private void updateForcedChunks() {
        throw new UnsupportedOperationException();
    }

    public String getTicketDebugString(long chunkPos, boolean requireSimulation) {
        List<Ticket> tickets = this.getTickets(chunkPos);
        Ticket lowestTicket = TicketStorage.getLowestTicket(tickets, requireSimulation);
        return lowestTicket == null ? "no_ticket" : lowestTicket.toString();
    }

    public void purgeStaleTickets() {
        this.chunkMap.level.moonrise$getChunkTaskScheduler().chunkHolderManager.tick();
        this.setDirty();
    }

    public void deactivateTicketsOnClosing() {
    }

    public void removeTicketIf(Predicate<Ticket> predicate, @Nullable Long2ObjectOpenHashMap<List<Ticket>> tickets) {
        throw new UnsupportedOperationException();
    }

    public void replaceTicketLevelOfType(int level, TicketType type) {
        throw new UnsupportedOperationException();
    }

    public boolean updateChunkForced(ChunkPos chunkPos, boolean add) {
        Ticket ticket = new Ticket(TicketType.FORCED, ChunkMap.FORCED_TICKET_LEVEL);
        return add ? this.addTicket(chunkPos.toLong(), ticket) : this.removeTicket(chunkPos.toLong(), ticket);
    }

    public LongSet getForceLoadedChunks() {
        Long2IntOpenHashMap forced = this.chunkMap.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketCounters(0L);
        if (forced == null) {
            return LongSet.of();
        }
        return forced.keySet();
    }

    private LongSet getAllChunksWithTicketThat(Predicate<Ticket> predicate) {
        throw new UnsupportedOperationException();
    }

    public boolean addPluginRegionTicket(ChunkPos pos, Plugin value) {
        return this.addTicket(pos.toLong(), new Ticket(TicketType.PLUGIN_TICKET, ChunkMap.FORCED_TICKET_LEVEL, value));
    }

    public boolean removePluginRegionTicket(ChunkPos pos, Plugin value) {
        return this.removeTicket(pos.toLong(), new Ticket(TicketType.PLUGIN_TICKET, ChunkMap.FORCED_TICKET_LEVEL, value));
    }

    public void removeAllPluginRegionTickets(TicketType ticketType, int ticketLevel, Plugin ticketIdentifier) {
        this.chunkMap.level.moonrise$getChunkTaskScheduler().chunkHolderManager.removeAllTicketsFor(ticketType, ticketLevel, ticketIdentifier);
    }

    @FunctionalInterface
    public static interface ChunkUpdated {
        public void update(long var1, int var3, boolean var4);
    }
}

