/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DoubleBlockCombiner {
    public static <S extends BlockEntity> NeighborCombineResult<S> combineWithNeigbour(BlockEntityType<S> blockEntityType, Function<BlockState, BlockType> doubleBlockTypeGetter, Function<BlockState, Direction> directionGetter, Property<Direction> directionProperty, BlockState state, LevelAccessor level, BlockPos pos, BiPredicate<LevelAccessor, BlockPos> blockedChestTest) {
        BlockType blockType1;
        boolean flag1;
        S blockEntity = blockEntityType.getBlockEntity(level, pos);
        if (blockEntity == null) {
            return Combiner::acceptNone;
        }
        if (blockedChestTest.test(level, pos)) {
            return Combiner::acceptNone;
        }
        BlockType blockType = doubleBlockTypeGetter.apply(state);
        boolean flag = blockType == BlockType.SINGLE;
        boolean bl = flag1 = blockType == BlockType.FIRST;
        if (flag) {
            return new NeighborCombineResult.Single<S>(blockEntity);
        }
        BlockPos blockPos = pos.relative(directionGetter.apply(state));
        BlockState blockState = level.getBlockStateIfLoaded(blockPos);
        if (blockState == null) {
            return new NeighborCombineResult.Single<S>(blockEntity);
        }
        if (blockState.is(state.getBlock()) && (blockType1 = doubleBlockTypeGetter.apply(blockState)) != BlockType.SINGLE && blockType != blockType1 && blockState.getValue(directionProperty) == state.getValue(directionProperty)) {
            if (blockedChestTest.test(level, blockPos)) {
                return Combiner::acceptNone;
            }
            S blockEntity1 = blockEntityType.getBlockEntity(level, blockPos);
            if (blockEntity1 != null) {
                S blockEntity2 = flag1 ? blockEntity : blockEntity1;
                S blockEntity3 = flag1 ? blockEntity1 : blockEntity;
                return new NeighborCombineResult.Double<S>(blockEntity2, blockEntity3);
            }
        }
        return new NeighborCombineResult.Single<S>(blockEntity);
    }

    public static interface NeighborCombineResult<S> {
        public <T> T apply(Combiner<? super S, T> var1);

        public static final class Single<S>
        implements NeighborCombineResult<S> {
            private final S single;

            public Single(S single) {
                this.single = single;
            }

            @Override
            public <T> T apply(Combiner<? super S, T> combiner) {
                return combiner.acceptSingle(this.single);
            }
        }

        public static final class Double<S>
        implements NeighborCombineResult<S> {
            private final S first;
            private final S second;

            public Double(S first, S second) {
                this.first = first;
                this.second = second;
            }

            @Override
            public <T> T apply(Combiner<? super S, T> combiner) {
                return combiner.acceptDouble(this.first, this.second);
            }
        }
    }

    public static enum BlockType {
        SINGLE,
        FIRST,
        SECOND;

    }

    public static interface Combiner<S, T> {
        public T acceptDouble(S var1, S var2);

        public T acceptSingle(S var1);

        public T acceptNone();
    }
}

