/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;

public class PressurePlateBlock
extends BasePressurePlateBlock {
    public static final MapCodec<PressurePlateBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(pressurePlate -> pressurePlate.type), PressurePlateBlock.propertiesCodec()).apply((Applicative)instance, PressurePlateBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<PressurePlateBlock> codec() {
        return CODEC;
    }

    protected PressurePlateBlock(BlockSetType type, BlockBehaviour.Properties properties) {
        super(properties, type);
        this.registerDefaultState((BlockState)this.stateDefinition.any().setValue(POWERED, false));
    }

    @Override
    protected int getSignalForState(BlockState state) {
        return state.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected BlockState setSignalForState(BlockState state, int strength) {
        return (BlockState)state.setValue(POWERED, strength > 0);
    }

    @Override
    protected int getSignalStrength(Level level, BlockPos pos) {
        Class<net.minecraft.world.entity.Entity> clazz = switch (this.type.pressurePlateSensitivity()) {
            default -> throw new MatchException(null, null);
            case BlockSetType.PressurePlateSensitivity.EVERYTHING -> net.minecraft.world.entity.Entity.class;
            case BlockSetType.PressurePlateSensitivity.MOBS -> LivingEntity.class;
        };
        for (net.minecraft.world.entity.Entity entity : PressurePlateBlock.getEntities(level, BasePressurePlateBlock.TOUCH_AABB.move(pos), clazz)) {
            if (this.getSignalForState(level.getBlockState(pos)) == 0) {
                EntityInteractEvent cancellable;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    cancellable = CraftEventFactory.callPlayerInteractEvent(player, Action.PHYSICAL, pos, null, null, null);
                } else {
                    cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos));
                    level.getCraftServer().getPluginManager().callEvent((Event)cancellable);
                }
                if (cancellable.isCancelled()) continue;
            }
            return 15;
        }
        return 0;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(POWERED);
    }
}

