/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.math.OctahedralGroup;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;

public enum Rotation implements StringRepresentable
{
    NONE(0, "none", OctahedralGroup.IDENTITY),
    CLOCKWISE_90(1, "clockwise_90", OctahedralGroup.ROT_90_Y_NEG),
    CLOCKWISE_180(2, "180", OctahedralGroup.ROT_180_FACE_XZ),
    COUNTERCLOCKWISE_90(3, "counterclockwise_90", OctahedralGroup.ROT_90_Y_POS);

    public static final IntFunction<Rotation> BY_ID;
    public static final Codec<Rotation> CODEC;
    public static final StreamCodec<ByteBuf, Rotation> STREAM_CODEC;
    @Deprecated
    public static final Codec<Rotation> LEGACY_CODEC;
    private final int index;
    private final String id;
    private final OctahedralGroup rotation;

    private Rotation(int index, String id, OctahedralGroup rotation) {
        this.index = index;
        this.id = id;
        this.rotation = rotation;
    }

    public Rotation getRotated(Rotation rotation) {
        return switch (rotation.ordinal()) {
            case 1 -> {
                switch (this.ordinal()) {
                    case 0: {
                        yield CLOCKWISE_90;
                    }
                    case 1: {
                        yield CLOCKWISE_180;
                    }
                    case 2: {
                        yield COUNTERCLOCKWISE_90;
                    }
                    case 3: {
                        yield NONE;
                    }
                }
                throw new MatchException(null, null);
            }
            case 2 -> {
                switch (this.ordinal()) {
                    case 0: {
                        yield CLOCKWISE_180;
                    }
                    case 1: {
                        yield COUNTERCLOCKWISE_90;
                    }
                    case 2: {
                        yield NONE;
                    }
                    case 3: {
                        yield CLOCKWISE_90;
                    }
                }
                throw new MatchException(null, null);
            }
            case 3 -> {
                switch (this.ordinal()) {
                    case 0: {
                        yield COUNTERCLOCKWISE_90;
                    }
                    case 1: {
                        yield NONE;
                    }
                    case 2: {
                        yield CLOCKWISE_90;
                    }
                    case 3: {
                        yield CLOCKWISE_180;
                    }
                }
                throw new MatchException(null, null);
            }
            default -> this;
        };
    }

    public OctahedralGroup rotation() {
        return this.rotation;
    }

    public Direction rotate(Direction facing) {
        if (facing.getAxis() == Direction.Axis.Y) {
            return facing;
        }
        return switch (this.ordinal()) {
            case 1 -> facing.getClockWise();
            case 2 -> facing.getOpposite();
            case 3 -> facing.getCounterClockWise();
            default -> facing;
        };
    }

    public int rotate(int rotation, int positionCount) {
        return switch (this.ordinal()) {
            case 1 -> (rotation + positionCount / 4) % positionCount;
            case 2 -> (rotation + positionCount / 2) % positionCount;
            case 3 -> (rotation + positionCount * 3 / 4) % positionCount;
            default -> rotation;
        };
    }

    public static Rotation getRandom(RandomSource random) {
        return Util.getRandom(Rotation.values(), random);
    }

    public static List<Rotation> getShuffled(RandomSource random) {
        return Util.shuffledCopy(Rotation.values(), random);
    }

    @Override
    public String getSerializedName() {
        return this.id;
    }

    private int getIndex() {
        return this.index;
    }

    static {
        BY_ID = ByIdMap.continuous(Rotation::getIndex, Rotation.values(), ByIdMap.OutOfBoundsStrategy.WRAP);
        CODEC = StringRepresentable.fromEnum(Rotation::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Rotation::getIndex);
        LEGACY_CODEC = ExtraCodecs.legacyEnum(Rotation::valueOf);
    }
}

