/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreadeableBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class SculkVeinBlock
extends MultifaceSpreadeableBlock
implements SculkBehaviour {
    public static final MapCodec<SculkVeinBlock> CODEC = SculkVeinBlock.simpleCodec(SculkVeinBlock::new);
    private final MultifaceSpreader veinSpreader = new MultifaceSpreader(new SculkVeinSpreaderConfig(this, MultifaceSpreader.DEFAULT_SPREAD_ORDER));
    private final MultifaceSpreader sameSpaceSpreader = new MultifaceSpreader(new SculkVeinSpreaderConfig(this, MultifaceSpreader.SpreadType.SAME_POSITION));

    public MapCodec<SculkVeinBlock> codec() {
        return CODEC;
    }

    public SculkVeinBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public MultifaceSpreader getSpreader() {
        return this.veinSpreader;
    }

    public MultifaceSpreader getSameSpaceSpreader() {
        return this.sameSpaceSpreader;
    }

    public static boolean regrow(LevelAccessor level, BlockPos pos, BlockState state, Collection<Direction> directions) {
        boolean flag = false;
        BlockState blockState = Blocks.SCULK_VEIN.defaultBlockState();
        for (Direction direction : directions) {
            if (!SculkVeinBlock.canAttachTo(level, pos, direction)) continue;
            blockState = (BlockState)blockState.setValue(SculkVeinBlock.getFaceProperty(direction), true);
            flag = true;
        }
        if (!flag) {
            return false;
        }
        if (!state.getFluidState().isEmpty()) {
            blockState = (BlockState)blockState.setValue(MultifaceBlock.WATERLOGGED, true);
        }
        level.setBlock(pos, blockState, 3);
        return true;
    }

    @Override
    public void onDischarged(LevelAccessor level, BlockState state, BlockPos pos, RandomSource random) {
        if (state.is(this)) {
            for (Direction direction : MultifaceBlock.DIRECTIONS) {
                BooleanProperty faceProperty = SculkVeinBlock.getFaceProperty(direction);
                if (!state.getValue(faceProperty).booleanValue() || !level.getBlockState(pos.relative(direction)).is(Blocks.SCULK)) continue;
                state = (BlockState)state.setValue(faceProperty, false);
            }
            if (!SculkVeinBlock.hasAnyFace(state)) {
                FluidState fluidState = level.getFluidState(pos);
                state = (fluidState.isEmpty() ? Blocks.AIR : Blocks.WATER).defaultBlockState();
            }
            level.setBlock(pos, state, 3);
            SculkBehaviour.super.onDischarged(level, state, pos, random);
        }
    }

    @Override
    public int attemptUseCharge(SculkSpreader.ChargeCursor cursor, LevelAccessor level, BlockPos pos, RandomSource random, SculkSpreader spreader, boolean shouldConvertBlocks) {
        if (shouldConvertBlocks && this.attemptPlaceSculk(spreader, level, cursor.getPos(), random, pos)) {
            return cursor.getCharge() - 1;
        }
        return random.nextInt(spreader.chargeDecayRate()) == 0 ? Mth.floor((float)cursor.getCharge() * 0.5f) : cursor.getCharge();
    }

    private boolean attemptPlaceSculk(SculkSpreader spreader, LevelAccessor level, BlockPos pos, RandomSource random, BlockPos sourceBlock) {
        BlockState blockState = level.getBlockState(pos);
        TagKey<Block> tagKey = spreader.replaceableBlocks();
        for (Direction direction : Direction.allShuffled(random)) {
            BlockPos blockPos;
            BlockState blockState1;
            if (!SculkVeinBlock.hasFace(blockState, direction) || !(blockState1 = level.getBlockState(blockPos = pos.relative(direction))).is(tagKey)) continue;
            BlockState blockState2 = Blocks.SCULK.defaultBlockState();
            if (!CraftEventFactory.handleBlockSpreadEvent(level, sourceBlock, blockPos, blockState2, 3)) {
                return false;
            }
            Block.pushEntitiesUp(blockState1, blockState2, level, blockPos);
            level.playSound(null, blockPos, SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.veinSpreader.spreadAll(blockState2, level, blockPos, spreader.isWorldGeneration());
            Direction opposite = direction.getOpposite();
            for (Direction direction1 : MultifaceBlock.DIRECTIONS) {
                BlockPos blockPos1;
                BlockState blockState3;
                if (direction1 == opposite || !(blockState3 = level.getBlockState(blockPos1 = blockPos.relative(direction1))).is(this)) continue;
                this.onDischarged(level, blockState3, blockPos1, random);
            }
            return true;
        }
        return false;
    }

    public static boolean hasSubstrateAccess(LevelAccessor level, BlockState state, BlockPos pos) {
        if (!state.is(Blocks.SCULK_VEIN)) {
            return false;
        }
        for (Direction direction : MultifaceBlock.DIRECTIONS) {
            if (!SculkVeinBlock.hasFace(state, direction) || !level.getBlockState(pos.relative(direction)).is(BlockTags.SCULK_REPLACEABLE)) continue;
            return true;
        }
        return false;
    }

    class SculkVeinSpreaderConfig
    extends MultifaceSpreader.DefaultSpreaderConfig {
        private final MultifaceSpreader.SpreadType[] spreadTypes;

        public SculkVeinSpreaderConfig(SculkVeinBlock this$0, MultifaceSpreader.SpreadType ... spreadTypes) {
            super(this$0);
            this.spreadTypes = spreadTypes;
        }

        @Override
        public boolean stateCanBeReplaced(BlockGetter level, BlockPos pos, BlockPos spreadPos, Direction direction, BlockState state) {
            BlockState blockState = level.getBlockState(spreadPos.relative(direction));
            if (!(blockState.is(Blocks.SCULK) || blockState.is(Blocks.SCULK_CATALYST) || blockState.is(Blocks.MOVING_PISTON))) {
                BlockPos blockPos;
                if (pos.distManhattan(spreadPos) == 2 && level.getBlockState(blockPos = pos.relative(direction.getOpposite())).isFaceSturdy(level, blockPos, direction)) {
                    return false;
                }
                FluidState fluidState = state.getFluidState();
                return !(!fluidState.isEmpty() && !fluidState.is(Fluids.WATER) || state.is(BlockTags.FIRE) || !state.canBeReplaced() && !super.stateCanBeReplaced(level, pos, spreadPos, direction, state));
            }
            return false;
        }

        @Override
        public MultifaceSpreader.SpreadType[] getSpreadTypes() {
            return this.spreadTypes;
        }

        @Override
        public boolean isOtherBlockValidAsSource(BlockState otherBlock) {
            return !otherBlock.is(Blocks.SCULK_VEIN);
        }
    }
}

