/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    private static final Codec<Map<ResourceKey<Recipe<?>>, Integer>> RECIPES_USED_CODEC = Codec.unboundedMap(Recipe.KEY_CODEC, (Codec)Codec.INT);
    private static final short DEFAULT_COOKING_TIMER = 0;
    private static final short DEFAULT_COOKING_TOTAL_TIME = 0;
    private static final short DEFAULT_LIT_TIME_REMAINING = 0;
    private static final short DEFAULT_LIT_TOTAL_TIME = 0;
    protected NonNullList<net.minecraft.world.item.ItemStack> items = NonNullList.withSize(3, net.minecraft.world.item.ItemStack.EMPTY);
    public int litTimeRemaining;
    int litTotalTime;
    public int cookingTimer;
    public int cookingTotalTime;
    protected final ContainerData dataAccess = new ContainerData(){

        @Override
        public int get(int index) {
            switch (index) {
                case 0: {
                    return AbstractFurnaceBlockEntity.this.litTimeRemaining;
                }
                case 1: {
                    return AbstractFurnaceBlockEntity.this.litTotalTime;
                }
                case 2: {
                    return AbstractFurnaceBlockEntity.this.cookingTimer;
                }
                case 3: {
                    return AbstractFurnaceBlockEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        @Override
        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractFurnaceBlockEntity.this.litTimeRemaining = value;
                    break;
                }
                case 1: {
                    AbstractFurnaceBlockEntity.this.litTotalTime = value;
                    break;
                }
                case 2: {
                    AbstractFurnaceBlockEntity.this.cookingTimer = value;
                    break;
                }
                case 3: {
                    AbstractFurnaceBlockEntity.this.cookingTotalTime = value;
                }
            }
        }

        @Override
        public int getCount() {
            return 4;
        }
    };
    public final Reference2IntOpenHashMap<ResourceKey<Recipe<?>>> recipesUsed = new Reference2IntOpenHashMap();
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck;
    public final RecipeType<? extends AbstractCookingRecipe> recipeType;
    public double cookSpeedMultiplier = 1.0;
    private int maxStack = 99;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    protected AbstractFurnaceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        super(type, pos, blockState);
        this.quickCheck = RecipeManager.createCheck(recipeType);
        this.recipeType = recipeType;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity player) {
        this.transaction.add(player);
    }

    @Override
    public void onClose(CraftHumanEntity player) {
        this.transaction.remove(player);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    private boolean isLit() {
        return this.litTimeRemaining > 0;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize(this.getContainerSize(), net.minecraft.world.item.ItemStack.EMPTY);
        ContainerHelper.loadAllItems(tag, this.items, registries);
        this.cookingTimer = tag.getShortOr("cooking_time_spent", (short)0);
        this.cookingTotalTime = tag.getShortOr("cooking_total_time", (short)0);
        this.litTimeRemaining = tag.getShortOr("lit_time_remaining", (short)0);
        this.litTotalTime = tag.getShortOr("lit_total_time", (short)0);
        this.recipesUsed.clear();
        this.recipesUsed.putAll(tag.read("RecipesUsed", RECIPES_USED_CODEC).orElse(Map.of()));
        this.cookSpeedMultiplier = tag.getDoubleOr("Paper.CookSpeedMultiplier", 1.0);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putShort("cooking_time_spent", (short)this.cookingTimer);
        tag.putShort("cooking_total_time", (short)this.cookingTotalTime);
        tag.putShort("lit_time_remaining", (short)this.litTimeRemaining);
        tag.putShort("lit_total_time", (short)this.litTotalTime);
        tag.putDouble("Paper.CookSpeedMultiplier", this.cookSpeedMultiplier);
        ContainerHelper.saveAllItems(tag, this.items, registries);
        tag.store("RecipesUsed", RECIPES_USED_CODEC, this.recipesUsed);
    }

    public static void serverTick(ServerLevel level, BlockPos pos, BlockState state, AbstractFurnaceBlockEntity furnace) {
        boolean flag2;
        boolean isLit = furnace.isLit();
        boolean flag = false;
        if (furnace.isLit()) {
            --furnace.litTimeRemaining;
        }
        net.minecraft.world.item.ItemStack itemStack = furnace.items.get(1);
        net.minecraft.world.item.ItemStack itemStack1 = furnace.items.get(0);
        boolean flag1 = !itemStack1.isEmpty();
        boolean bl = flag2 = !itemStack.isEmpty();
        if (furnace.isLit() || flag2 && flag1) {
            SingleRecipeInput singleRecipeInput = new SingleRecipeInput(itemStack1);
            RecipeHolder recipeHolder = flag1 ? (RecipeHolder)furnace.quickCheck.getRecipeFor(singleRecipeInput, level).orElse(null) : null;
            int maxStackSize = furnace.getMaxStackSize();
            if (!furnace.isLit() && AbstractFurnaceBlockEntity.canBurn(level.registryAccess(), recipeHolder, singleRecipeInput, furnace.items, maxStackSize)) {
                CraftItemStack fuel = CraftItemStack.asCraftMirror(itemStack);
                FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent((Block)CraftBlock.at(level, pos), (ItemStack)fuel, furnace.getBurnDuration(level.fuelValues(), itemStack));
                if (!furnaceBurnEvent.callEvent()) {
                    return;
                }
                furnace.litTotalTime = furnace.litTimeRemaining = furnaceBurnEvent.getBurnTime();
                if (furnace.isLit() && furnaceBurnEvent.isBurning()) {
                    flag = true;
                    if (flag2 && furnaceBurnEvent.willConsumeFuel()) {
                        Item item = itemStack.getItem();
                        itemStack.shrink(1);
                        if (itemStack.isEmpty()) {
                            furnace.items.set(1, item.getCraftingRemainder());
                        }
                    }
                }
            }
            if (furnace.isLit() && AbstractFurnaceBlockEntity.canBurn(level.registryAccess(), recipeHolder, singleRecipeInput, furnace.items, maxStackSize)) {
                if (recipeHolder != null && furnace.cookingTimer == 0) {
                    CraftItemStack source = CraftItemStack.asCraftMirror(furnace.items.get(0));
                    CookingRecipe recipe = (CookingRecipe)recipeHolder.toBukkitRecipe();
                    FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent((Block)CraftBlock.at(level, pos), (ItemStack)source, recipe, AbstractFurnaceBlockEntity.getTotalCookTime(level, furnace, furnace.recipeType, furnace.cookSpeedMultiplier));
                    event.callEvent();
                    furnace.cookingTotalTime = event.getTotalCookTime();
                }
                ++furnace.cookingTimer;
                if (furnace.cookingTimer >= furnace.cookingTotalTime) {
                    furnace.cookingTimer = 0;
                    furnace.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime(level, furnace, furnace.recipeType, furnace.cookSpeedMultiplier);
                    if (AbstractFurnaceBlockEntity.burn(level.registryAccess(), recipeHolder, singleRecipeInput, furnace.items, maxStackSize, level, furnace.worldPosition)) {
                        furnace.setRecipeUsed(recipeHolder);
                    }
                    flag = true;
                }
            } else {
                furnace.cookingTimer = 0;
            }
        } else if (!furnace.isLit() && furnace.cookingTimer > 0) {
            furnace.cookingTimer = Mth.clamp(furnace.cookingTimer - 2, 0, furnace.cookingTotalTime);
        }
        if (isLit != furnace.isLit()) {
            flag = true;
            state = (BlockState)state.setValue(AbstractFurnaceBlock.LIT, furnace.isLit());
            level.setBlock(pos, state, 3);
        }
        if (flag) {
            AbstractFurnaceBlockEntity.setChanged(level, pos, state);
        }
    }

    private static boolean canBurn(RegistryAccess registryAccess, @Nullable RecipeHolder<? extends AbstractCookingRecipe> recipe, SingleRecipeInput recipeInput, NonNullList<net.minecraft.world.item.ItemStack> items, int maxStackSize) {
        if (!items.get(0).isEmpty() && recipe != null) {
            net.minecraft.world.item.ItemStack itemStack = recipe.value().assemble(recipeInput, (HolderLookup.Provider)registryAccess);
            if (itemStack.isEmpty()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemStack1 = items.get(2);
            return itemStack1.isEmpty() || net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemStack1, itemStack) && (itemStack1.getCount() < maxStackSize && itemStack1.getCount() < itemStack1.getMaxStackSize() || itemStack1.getCount() < itemStack.getMaxStackSize());
        }
        return false;
    }

    private static boolean burn(RegistryAccess registryAccess, @Nullable RecipeHolder<? extends AbstractCookingRecipe> recipe, SingleRecipeInput recipeInput, NonNullList<net.minecraft.world.item.ItemStack> items, int maxStackSize, Level level, BlockPos blockPos) {
        if (recipe != null && AbstractFurnaceBlockEntity.canBurn(registryAccess, recipe, recipeInput, items, maxStackSize)) {
            net.minecraft.world.item.ItemStack itemStack2;
            net.minecraft.world.item.ItemStack itemStack1;
            net.minecraft.world.item.ItemStack itemStack;
            net.minecraft.world.item.ItemStack ingredient = itemStack = items.get(0);
            net.minecraft.world.item.ItemStack result = itemStack1 = recipe.value().assemble(recipeInput, (HolderLookup.Provider)registryAccess);
            net.minecraft.world.item.ItemStack existingResults = itemStack2 = items.get(2);
            CraftItemStack apiIngredient = CraftItemStack.asCraftMirror(ingredient);
            ItemStack apiResult = CraftItemStack.asBukkitCopy(result);
            FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent((Block)CraftBlock.at(level, blockPos), (ItemStack)apiIngredient, apiResult, (CookingRecipe)recipe.toBukkitRecipe());
            if (!furnaceSmeltEvent.callEvent()) {
                return false;
            }
            apiResult = furnaceSmeltEvent.getResult();
            itemStack1 = result = CraftItemStack.asNMSCopy(apiResult);
            if (!result.isEmpty()) {
                if (existingResults.isEmpty()) {
                    items.set(2, result.copy());
                } else if (CraftItemStack.asCraftMirror(existingResults).isSimilar(apiResult)) {
                    existingResults.grow(result.getCount());
                } else {
                    return false;
                }
            }
            if (itemStack.is(Blocks.WET_SPONGE.asItem()) && !items.get(1).isEmpty() && items.get(1).is(Items.BUCKET)) {
                items.set(1, new net.minecraft.world.item.ItemStack(Items.WATER_BUCKET));
            }
            itemStack.shrink(1);
            return true;
        }
        return false;
    }

    protected int getBurnDuration(FuelValues fuelValues, net.minecraft.world.item.ItemStack stack) {
        return fuelValues.burnDuration(stack);
    }

    public static int getTotalCookTime(@Nullable ServerLevel level, AbstractFurnaceBlockEntity furnace, RecipeType<? extends AbstractCookingRecipe> recipeType, double cookSpeedMultiplier) {
        SingleRecipeInput singleRecipeInput = new SingleRecipeInput(furnace.getItem(0));
        int cookTime = level != null ? furnace.quickCheck.getRecipeFor(singleRecipeInput, level).map(recipeHolder -> ((AbstractCookingRecipe)recipeHolder.value()).cookingTime()).orElse(200) : MinecraftServer.getServer().getRecipeManager().getRecipeFor(recipeType, singleRecipeInput, level).map(recipeHolder -> ((AbstractCookingRecipe)recipeHolder.value()).cookingTime()).orElse(200);
        return (int)Math.ceil((double)cookTime / cookSpeedMultiplier);
    }

    @Override
    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return side == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    @Override
    public boolean canPlaceItemThroughFace(int index, net.minecraft.world.item.ItemStack itemStack, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStack);
    }

    @Override
    public boolean canTakeItemThroughFace(int index, net.minecraft.world.item.ItemStack stack, Direction direction) {
        return direction != Direction.DOWN || index != 1 || stack.is(Items.WATER_BUCKET) || stack.is(Items.BUCKET);
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<net.minecraft.world.item.ItemStack> items) {
        this.items = items;
    }

    @Override
    public void setItem(int index, net.minecraft.world.item.ItemStack stack) {
        Level level;
        net.minecraft.world.item.ItemStack itemStack = this.items.get(index);
        boolean flag = !stack.isEmpty() && net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemStack, stack);
        this.items.set(index, stack);
        stack.limitSize(this.getMaxStackSize(stack));
        if (index == 0 && !flag && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime(serverLevel, this, this.recipeType, this.cookSpeedMultiplier);
            this.cookingTimer = 0;
            this.setChanged();
        }
    }

    @Override
    public boolean canPlaceItem(int index, net.minecraft.world.item.ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        net.minecraft.world.item.ItemStack itemStack = this.items.get(1);
        return this.level.fuelValues().isFuel(stack) || stack.is(Items.BUCKET) && !itemStack.is(Items.BUCKET);
    }

    @Override
    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceKey<Recipe<?>> resourceKey = recipe.id();
            this.recipesUsed.addTo(resourceKey, 1);
        }
    }

    @Override
    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    @Override
    public void awardUsedRecipes(Player player, List<net.minecraft.world.item.ItemStack> items) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player, net.minecraft.world.item.ItemStack itemstack, int amount) {
        List<RecipeHolder<?>> recipesToAwardAndPopExperience = this.getRecipesToAwardAndPopExperience(player.serverLevel(), player.position(), this.worldPosition, player, itemstack, amount);
        player.awardRecipes(recipesToAwardAndPopExperience);
        for (RecipeHolder<?> recipeHolder : recipesToAwardAndPopExperience) {
            if (recipeHolder == null) continue;
            player.triggerRecipeCrafted(recipeHolder, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 popVec) {
        return this.getRecipesToAwardAndPopExperience(level, popVec, this.worldPosition, null, null, 0);
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 popVec, BlockPos blockPos, ServerPlayer serverPlayer, net.minecraft.world.item.ItemStack itemStack, int amount) {
        ArrayList list = Lists.newArrayList();
        for (Reference2IntMap.Entry entry : this.recipesUsed.reference2IntEntrySet()) {
            level.recipeAccess().byKey((ResourceKey)entry.getKey()).ifPresent(recipeHolder -> {
                if (!(recipeHolder.value() instanceof AbstractCookingRecipe)) {
                    return;
                }
                list.add(recipeHolder);
                AbstractFurnaceBlockEntity.createExperience(level, popVec, entry.getIntValue(), ((AbstractCookingRecipe)recipeHolder.value()).experience(), blockPos, serverPlayer, itemStack, amount);
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel level, Vec3 popVec, int recipeIndex, float experience, BlockPos blockPos, ServerPlayer serverPlayer, net.minecraft.world.item.ItemStack itemStack, int amount) {
        int floor = Mth.floor((float)recipeIndex * experience);
        float fraction = Mth.frac((float)recipeIndex * experience);
        if (fraction != 0.0f && Math.random() < (double)fraction) {
            ++floor;
        }
        Object event = amount != 0 ? new FurnaceExtractEvent((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), (Block)CraftBlock.at(level, blockPos), CraftItemType.minecraftToBukkit(itemStack.getItem()), amount, floor) : new BlockExpEvent((Block)CraftBlock.at(level, blockPos), floor);
        event.callEvent();
        floor = event.getExpToDrop();
        ExperienceOrb.award(level, popVec, floor, ExperienceOrb.SpawnReason.FURNACE, serverPlayer);
    }

    @Override
    public void fillStackedContents(StackedItemContents stackedContents) {
        stackedContents.accountStack(this.items.get(0));
        stackedContents.accountStack(this.items.get(2));
        for (net.minecraft.world.item.ItemStack itemStack : this.items) {
            stackedContents.accountStack(itemStack);
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.getRecipesToAwardAndPopExperience(serverLevel, Vec3.atCenterOf(pos));
        }
    }
}

