/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.block.BellRevealRaiderEvent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableInt;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Raider;

public class BellBlockEntity
extends BlockEntity {
    private static final int DURATION = 50;
    private static final int GLOW_DURATION = 60;
    private static final int MIN_TICKS_BETWEEN_SEARCHES = 60;
    private static final int MAX_RESONATION_TICKS = 40;
    private static final int TICKS_BEFORE_RESONATION = 5;
    private static final int SEARCH_RADIUS = 48;
    private static final int HEAR_BELL_RADIUS = 32;
    private static final int HIGHLIGHT_RAIDERS_RADIUS = 48;
    private long lastRingTimestamp;
    public int ticks;
    public boolean shaking;
    public Direction clickDirection;
    private List<net.minecraft.world.entity.LivingEntity> nearbyEntities;
    public boolean resonating;
    public int resonationTicks;

    public BellBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityType.BELL, pos, blockState);
    }

    @Override
    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.updateEntities();
            this.resonationTicks = 0;
            this.clickDirection = Direction.from3DDataValue(type);
            this.ticks = 0;
            this.shaking = true;
            return true;
        }
        return super.triggerEvent(id, type);
    }

    private static void tick(Level level, BlockPos pos, BlockState state, BellBlockEntity blockEntity, ResonationEndAction resonationEndAction) {
        if (blockEntity.shaking) {
            ++blockEntity.ticks;
        }
        if (blockEntity.ticks >= 50) {
            blockEntity.shaking = false;
            if (!blockEntity.resonating) {
                blockEntity.nearbyEntities.clear();
            }
            blockEntity.ticks = 0;
        }
        if (blockEntity.ticks >= 5 && blockEntity.resonationTicks == 0 && BellBlockEntity.areRaidersNearby(pos, blockEntity.nearbyEntities)) {
            blockEntity.resonating = true;
            level.playSound(null, pos, SoundEvents.BELL_RESONATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (blockEntity.resonating) {
            if (blockEntity.resonationTicks < 40) {
                ++blockEntity.resonationTicks;
            } else {
                resonationEndAction.run(level, pos, blockEntity.nearbyEntities);
                blockEntity.nearbyEntities.clear();
                blockEntity.resonating = false;
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BellBlockEntity blockEntity) {
        BellBlockEntity.tick(level, pos, state, blockEntity, BellBlockEntity::showBellParticles);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BellBlockEntity blockEntity) {
        BellBlockEntity.tick(level, pos, state, blockEntity, BellBlockEntity::makeRaidersGlow);
    }

    public void onHit(Direction direction) {
        BlockPos blockPos = this.getBlockPos();
        this.clickDirection = direction;
        if (this.shaking) {
            this.ticks = 0;
        } else {
            this.shaking = true;
        }
        this.level.blockEvent(blockPos, this.getBlockState().getBlock(), 1, direction.get3DDataValue());
    }

    private void updateEntities() {
        BlockPos blockPos = this.getBlockPos();
        if (this.level.getGameTime() > this.lastRingTimestamp + 60L || this.nearbyEntities == null) {
            this.lastRingTimestamp = this.level.getGameTime();
            AABB aabb = new AABB(blockPos).inflate(48.0);
            this.nearbyEntities = this.level.getEntitiesOfClass(net.minecraft.world.entity.LivingEntity.class, aabb);
        }
        if (!this.level.isClientSide) {
            for (net.minecraft.world.entity.LivingEntity livingEntity : this.nearbyEntities) {
                if (!livingEntity.isAlive() || livingEntity.isRemoved() || !blockPos.closerToCenterThan(livingEntity.position(), 32.0)) continue;
                livingEntity.getBrain().setMemory(MemoryModuleType.HEARD_BELL_TIME, this.level.getGameTime());
            }
        }
        this.nearbyEntities.removeIf(e -> !e.isAlive());
    }

    private static boolean areRaidersNearby(BlockPos pos, List<net.minecraft.world.entity.LivingEntity> raiders) {
        for (net.minecraft.world.entity.LivingEntity livingEntity : raiders) {
            if (!livingEntity.isAlive() || livingEntity.isRemoved() || !pos.closerToCenterThan(livingEntity.position(), 32.0) || !livingEntity.getType().is(EntityTypeTags.RAIDERS)) continue;
            return true;
        }
        return false;
    }

    private static void makeRaidersGlow(Level level, BlockPos pos, List<net.minecraft.world.entity.LivingEntity> raiders) {
        List<LivingEntity> inRangeRaiders = raiders.stream().filter(raider -> BellBlockEntity.isRaiderWithinRange(pos, raider)).map(e -> (LivingEntity)e.getBukkitEntity()).toList();
        CraftEventFactory.handleBellResonateEvent(level, pos, inRangeRaiders).forEach(e -> BellBlockEntity.glow(e, pos));
    }

    private static void showBellParticles(Level level, BlockPos pos, List<net.minecraft.world.entity.LivingEntity> raiders) {
        MutableInt mutableInt = new MutableInt(16700985);
        int i = (int)raiders.stream().filter(raider -> pos.closerToCenterThan(raider.position(), 48.0)).count();
        raiders.stream().filter(raider -> BellBlockEntity.isRaiderWithinRange(pos, raider)).forEach(raider -> {
            float f = 1.0f;
            double squareRoot = Math.sqrt((raider.getX() - (double)pos.getX()) * (raider.getX() - (double)pos.getX()) + (raider.getZ() - (double)pos.getZ()) * (raider.getZ() - (double)pos.getZ()));
            double d = (double)((float)pos.getX() + 0.5f) + 1.0 / squareRoot * (raider.getX() - (double)pos.getX());
            double d1 = (double)((float)pos.getZ() + 0.5f) + 1.0 / squareRoot * (raider.getZ() - (double)pos.getZ());
            int i1 = Mth.clamp((i - 21) / -2, 3, 15);
            for (int i2 = 0; i2 < i1; ++i2) {
                int i3 = mutableInt.addAndGet(5);
                level.addParticle(ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, i3), d, (float)pos.getY() + 0.5f, d1, 0.0, 0.0, 0.0);
            }
        });
    }

    private static boolean isRaiderWithinRange(BlockPos pos, net.minecraft.world.entity.LivingEntity raider) {
        return raider.isAlive() && !raider.isRemoved() && pos.closerToCenterThan(raider.position(), 48.0) && raider.getType().is(EntityTypeTags.RAIDERS);
    }

    @Deprecated
    @DoNotUse
    private static void glow(net.minecraft.world.entity.LivingEntity entity) {
        BellBlockEntity.glow(entity, null);
    }

    private static void glow(net.minecraft.world.entity.LivingEntity entity, @Nullable BlockPos pos) {
        if (pos != null && !new BellRevealRaiderEvent((Block)CraftBlock.at(entity.level(), pos), (Raider)entity.getBukkitEntity()).callEvent()) {
            return;
        }
        entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 60));
    }

    @FunctionalInterface
    static interface ResonationEndAction {
        public void run(Level var1, BlockPos var2, List<net.minecraft.world.entity.LivingEntity> var3);
    }
}

