/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;

public abstract class BlockEntity {
    static boolean ignoreBlockEntityUpdates;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    public final CraftPersistentDataContainer persistentDataContainer;
    private static final Codec<BlockEntityType<?>> TYPE_CODEC;
    private static final Logger LOGGER;
    private final BlockEntityType<?> type;
    @Nullable
    protected Level level;
    protected final BlockPos worldPosition;
    protected boolean remove;
    private net.minecraft.world.level.block.state.BlockState blockState;
    private DataComponentMap components = DataComponentMap.EMPTY;

    public BlockEntity(BlockEntityType<?> type, BlockPos pos, net.minecraft.world.level.block.state.BlockState blockState) {
        this.type = type;
        this.worldPosition = pos.immutable();
        this.validateBlockState(blockState);
        this.blockState = blockState;
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    }

    private void validateBlockState(net.minecraft.world.level.block.state.BlockState state) {
        if (!this.isValidBlockState(state)) {
            throw new IllegalStateException("Invalid block entity " + this.getNameForReporting() + " state at " + String.valueOf(this.worldPosition) + ", got " + String.valueOf(state));
        }
    }

    public boolean isValidBlockState(net.minecraft.world.level.block.state.BlockState state) {
        return this.type.isValid(state);
    }

    public static BlockPos getPosFromTag(ChunkPos chunkPos, CompoundTag tag) {
        int intOr = tag.getIntOr("x", 0);
        int intOr1 = tag.getIntOr("y", 0);
        int intOr2 = tag.getIntOr("z", 0);
        if (chunkPos != null) {
            int sectionPosCoord = SectionPos.blockToSectionCoord(intOr);
            int sectionPosCoord1 = SectionPos.blockToSectionCoord(intOr2);
            if (sectionPosCoord != chunkPos.x || sectionPosCoord1 != chunkPos.z) {
                LOGGER.warn("Block entity {} found in a wrong chunk, expected position from chunk {}", (Object)tag, (Object)chunkPos);
                intOr = chunkPos.getBlockX(SectionPos.sectionRelative(intOr));
                intOr2 = chunkPos.getBlockZ(SectionPos.sectionRelative(intOr2));
            }
        }
        return new BlockPos(intOr, intOr1, intOr2);
    }

    @Nullable
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.persistentDataContainer.clear();
        Tag persistentDataTag = tag.get("PublicBukkitValues");
        if (persistentDataTag instanceof CompoundTag) {
            this.persistentDataContainer.putAll((CompoundTag)persistentDataTag);
        }
    }

    public final void loadWithComponents(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
        this.components = tag.read(ComponentHelper.COMPONENTS_CODEC, registries.createSerializationContext(NbtOps.INSTANCE)).orElse(DataComponentMap.EMPTY);
    }

    public final void loadCustomOnly(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
    }

    public final CompoundTag saveWithFullMetadata(HolderLookup.Provider registries) {
        CompoundTag compoundTag = this.saveWithoutMetadata(registries);
        this.saveMetadata(compoundTag);
        return compoundTag;
    }

    public final CompoundTag saveWithId(HolderLookup.Provider registries) {
        CompoundTag compoundTag = this.saveWithoutMetadata(registries);
        this.saveId(compoundTag);
        return compoundTag;
    }

    public final CompoundTag saveWithoutMetadata(HolderLookup.Provider registries) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, registries);
        compoundTag.store(ComponentHelper.COMPONENTS_CODEC, registries.createSerializationContext(NbtOps.INSTANCE), this.components);
        if (!this.persistentDataContainer.isEmpty()) {
            compoundTag.put("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return compoundTag;
    }

    public final CompoundTag saveCustomOnly(HolderLookup.Provider registries) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, registries);
        if (!this.persistentDataContainer.isEmpty()) {
            compoundTag.put("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return compoundTag;
    }

    public final CompoundTag saveCustomAndMetadata(HolderLookup.Provider registries) {
        CompoundTag compoundTag = this.saveCustomOnly(registries);
        this.saveMetadata(compoundTag);
        return compoundTag;
    }

    public void saveId(CompoundTag tag) {
        BlockEntity.addEntityType(tag, this.getType());
    }

    public static void addEntityType(CompoundTag tag, BlockEntityType<?> entityType) {
        tag.store("id", TYPE_CODEC, entityType);
    }

    private void saveMetadata(CompoundTag tag) {
        this.saveId(tag);
        tag.putInt("x", this.worldPosition.getX());
        tag.putInt("y", this.worldPosition.getY());
        tag.putInt("z", this.worldPosition.getZ());
    }

    @Nullable
    public static BlockEntity loadStatic(BlockPos pos, net.minecraft.world.level.block.state.BlockState state, CompoundTag tag, HolderLookup.Provider registries) {
        Object blockEntity;
        BlockEntityType blockEntityType = tag.read("id", TYPE_CODEC).orElse(null);
        if (blockEntityType == null) {
            LOGGER.error("Skipping block entity with invalid type: {}", (Object)tag.get("id"));
            return null;
        }
        try {
            blockEntity = blockEntityType.create(pos, state);
        }
        catch (Throwable var8) {
            LOGGER.error("Failed to create block entity {} for block {} at position {} ", new Object[]{blockEntityType, pos, state, var8});
            return null;
        }
        try {
            ((BlockEntity)blockEntity).loadWithComponents(tag, registries);
            return blockEntity;
        }
        catch (Throwable var7) {
            LOGGER.error("Failed to load data for block entity {} for block {} at position {}", new Object[]{blockEntityType, pos, state, var7});
            return null;
        }
    }

    public void setChanged() {
        if (this.level != null) {
            if (ignoreBlockEntityUpdates) {
                return;
            }
            BlockEntity.setChanged(this.level, this.worldPosition, this.blockState);
        }
    }

    protected static void setChanged(Level level, BlockPos pos, net.minecraft.world.level.block.state.BlockState state) {
        level.blockEntityChanged(pos);
        if (!state.isAir()) {
            level.updateNeighbourForOutputSignal(pos, state.getBlock());
        }
    }

    public BlockPos getBlockPos() {
        return this.worldPosition;
    }

    public net.minecraft.world.level.block.state.BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return new CompoundTag();
    }

    public boolean isRemoved() {
        return this.remove;
    }

    public void setRemoved() {
        this.remove = true;
    }

    public void clearRemoved() {
        this.remove = false;
    }

    public void preRemoveSideEffects(BlockPos pos, net.minecraft.world.level.block.state.BlockState state) {
        BlockEntity blockEntity = this;
        if (blockEntity instanceof Container) {
            Container container = (Container)((Object)blockEntity);
            if (this.level != null) {
                Containers.dropContents(this.level, pos, container);
            }
        }
    }

    public boolean triggerEvent(int id, int type) {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory reportCategory) {
        reportCategory.setDetail("Name", this::getNameForReporting);
        reportCategory.setDetail("Cached block", this.getBlockState()::toString);
        if (this.level == null) {
            reportCategory.setDetail("Block location", () -> String.valueOf(this.worldPosition) + " (world missing)");
        } else {
            reportCategory.setDetail("Actual block", this.level.getBlockState(this.worldPosition)::toString);
            CrashReportCategory.populateBlockLocationDetails(reportCategory, this.level, this.worldPosition);
        }
    }

    private String getNameForReporting() {
        return String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.getType())) + " // " + this.getClass().getCanonicalName();
    }

    public BlockEntityType<?> getType() {
        return this.type;
    }

    @Deprecated
    public void setBlockState(net.minecraft.world.level.block.state.BlockState blockState) {
        this.validateBlockState(blockState);
        this.blockState = blockState;
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
    }

    public final void applyComponentsFromItemStack(ItemStack stack) {
        this.applyComponents(stack.getPrototype(), stack.getComponentsPatch());
    }

    public final void applyComponents(DataComponentMap components, DataComponentPatch patch) {
        this.applyComponentsSet(components, patch);
    }

    public final Set<DataComponentType<?>> applyComponentsSet(DataComponentMap components, DataComponentPatch patch) {
        final HashSet set = new HashSet();
        set.add(DataComponents.BLOCK_ENTITY_DATA);
        set.add(DataComponents.BLOCK_STATE);
        final PatchedDataComponentMap dataComponentMap = PatchedDataComponentMap.fromPatch(components, patch);
        this.applyImplicitComponents(new DataComponentGetter(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> component) {
                set.add(component);
                return dataComponentMap.get(component);
            }

            @Override
            public <T> T getOrDefault(DataComponentType<? extends T> component, T defaultValue) {
                set.add(component);
                return dataComponentMap.getOrDefault(component, defaultValue);
            }
        });
        DataComponentPatch dataComponentPatch = patch.forget(set::contains);
        this.components = dataComponentPatch.split().added();
        set.remove(DataComponents.BLOCK_ENTITY_DATA);
        return set;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
    }

    @Deprecated
    public void removeComponentsFromTag(CompoundTag tag) {
    }

    public final DataComponentMap collectComponents() {
        DataComponentMap.Builder builder = DataComponentMap.builder();
        builder.addAll(this.components);
        this.collectImplicitComponents(builder);
        return builder.build();
    }

    public DataComponentMap components() {
        return this.components;
    }

    public void setComponents(DataComponentMap components) {
        this.components = components;
    }

    @Nullable
    public static Component parseCustomNameSafe(@Nullable Tag tag, HolderLookup.Provider registries) {
        return tag == null ? null : (Component)ComponentSerialization.CODEC.parse(registries.createSerializationContext(NbtOps.INSTANCE), (Object)tag).resultOrPartial(string -> LOGGER.warn("Failed to parse custom name, discarding: {}", string)).orElse(null);
    }

    public InventoryHolder getOwner() {
        return this.getOwner(true);
    }

    public InventoryHolder getOwner(boolean useSnapshot) {
        InventoryHolder inventoryHolder;
        if (this.level == null) {
            return null;
        }
        CraftBlock block = CraftBlock.at(this.level, this.worldPosition);
        BlockState state = block.getState(useSnapshot);
        return state instanceof InventoryHolder ? (inventoryHolder = (InventoryHolder)state) : null;
    }

    public CompoundTag sanitizeSentNbt(CompoundTag tag) {
        tag.remove("PublicBukkitValues");
        return tag;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
        TYPE_CODEC = BuiltInRegistries.BLOCK_ENTITY_TYPE.byNameCodec();
        LOGGER = LogUtils.getLogger();
    }

    static class ComponentHelper {
        public static final MapCodec<DataComponentMap> COMPONENTS_CODEC = DataComponentMap.CODEC.optionalFieldOf("components", (Object)DataComponentMap.EMPTY);

        private ComponentHelper() {
        }
    }
}

