/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import io.papermc.paper.event.inventory.PaperInventoryMoveItemEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.Inventory;

public class HopperBlockEntity
extends RandomizableContainerBlockEntity
implements Hopper {
    public static final int MOVE_ITEM_SPEED = 8;
    public static final int HOPPER_CONTAINER_SIZE = 5;
    private static final int[][] CACHED_SLOTS = new int[54][];
    private static final int NO_COOLDOWN_TIME = -1;
    private NonNullList<ItemStack> items = NonNullList.withSize(5, ItemStack.EMPTY);
    public int cooldownTime = -1;
    private long tickedGameTime;
    private Direction facing;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;
    private static final int HOPPER_EMPTY = 0;
    private static final int HOPPER_HAS_ITEMS = 1;
    private static final int HOPPER_IS_FULL = 2;
    public static boolean skipHopperEvents;
    private static boolean skipPullModeEventFire;
    private static boolean skipPushModeEventFire;
    private static final BiPredicate<ItemStack, Integer> STACK_SIZE_TEST;
    private static final BiPredicate<ItemStack, Integer> IS_EMPTY_TEST;

    @Override
    public List<ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity player) {
        this.transaction.add(player);
    }

    @Override
    public void onClose(CraftHumanEntity player) {
        this.transaction.remove(player);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public HopperBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityType.HOPPER, pos, blockState);
        this.facing = blockState.getValue(HopperBlock.FACING);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems(tag, this.items, registries);
        }
        this.cooldownTime = tag.getIntOr("TransferCooldown", -1);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems(tag, this.items, registries);
        }
        tag.putInt("TransferCooldown", this.cooldownTime);
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    public ItemStack removeItem(int index, int count) {
        this.unpackLootTable(null);
        return ContainerHelper.removeItem(this.getItems(), index, count);
    }

    @Override
    public void setItem(int index, ItemStack stack) {
        this.unpackLootTable(null);
        this.getItems().set(index, stack);
        stack.limitSize(this.getMaxStackSize(stack));
    }

    @Override
    public void setBlockState(BlockState blockState) {
        super.setBlockState(blockState);
        this.facing = blockState.getValue(HopperBlock.FACING);
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable("container.hopper");
    }

    public static void pushItemsTick(Level level, BlockPos pos, BlockState state, HopperBlockEntity blockEntity) {
        --blockEntity.cooldownTime;
        blockEntity.tickedGameTime = level.getGameTime();
        if (!blockEntity.isOnCooldown()) {
            blockEntity.setCooldown(0);
            boolean result = HopperBlockEntity.tryMoveItems(level, pos, state, blockEntity, () -> HopperBlockEntity.suckInItems(level, blockEntity));
            if (!result && blockEntity.level.spigotConfig.hopperCheck > 1) {
                blockEntity.setCooldown(blockEntity.level.spigotConfig.hopperCheck);
            }
        }
    }

    private static int getFullState(HopperBlockEntity hopper) {
        hopper.unpackLootTable(null);
        NonNullList<ItemStack> hopperItems = hopper.items;
        boolean empty = true;
        boolean full = true;
        int len = hopperItems.size();
        for (int i = 0; i < len; ++i) {
            ItemStack stack = (ItemStack)hopperItems.get(i);
            if (stack.isEmpty()) {
                full = false;
                continue;
            }
            if (!full) {
                return 1;
            }
            empty = false;
            if (stack.getCount() == stack.getMaxStackSize()) continue;
            return 1;
        }
        return empty ? 0 : (full ? 2 : 1);
    }

    private static boolean tryMoveItems(Level level, BlockPos pos, BlockState state, HopperBlockEntity blockEntity, BooleanSupplier validator) {
        if (level.isClientSide) {
            return false;
        }
        if (!blockEntity.isOnCooldown() && state.getValue(HopperBlock.ENABLED).booleanValue()) {
            boolean flag = false;
            int fullState = HopperBlockEntity.getFullState(blockEntity);
            if (fullState != 0) {
                flag = HopperBlockEntity.ejectItems(level, pos, blockEntity);
            }
            if (fullState != 2 || flag) {
                flag |= validator.getAsBoolean();
            }
            if (flag) {
                blockEntity.setCooldown(level.spigotConfig.hopperTransfer);
                HopperBlockEntity.setChanged(level, pos, state);
                return true;
            }
        }
        return false;
    }

    private boolean inventoryFull() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.isEmpty() && itemStack.getCount() == itemStack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    private static boolean hopperPush(Level level, Container destination, Direction direction, HopperBlockEntity hopper) {
        skipPushModeEventFire = skipHopperEvents;
        boolean foundItem = false;
        for (int i = 0; i < hopper.getContainerSize(); ++i) {
            ItemStack origItemStack;
            ItemStack item = hopper.getItem(i);
            if (item.isEmpty()) continue;
            foundItem = true;
            ItemStack movedItem = origItemStack = item;
            int originalItemCount = origItemStack.getCount();
            int movedItemCount = Math.min(level.spigotConfig.hopperAmount, originalItemCount);
            origItemStack.setCount(movedItemCount);
            if (!skipPushModeEventFire && (movedItem = HopperBlockEntity.callPushMoveEvent(destination, movedItem, hopper)) == null) {
                origItemStack.setCount(originalItemCount);
                return false;
            }
            ItemStack remainingItem = HopperBlockEntity.addItem(hopper, destination, movedItem, direction);
            int remainingItemCount = remainingItem.getCount();
            if (remainingItemCount != movedItemCount) {
                origItemStack = origItemStack.copy(true);
                origItemStack.setCount(originalItemCount);
                if (!origItemStack.isEmpty()) {
                    origItemStack.setCount(originalItemCount - movedItemCount + remainingItemCount);
                }
                hopper.setItem(i, origItemStack);
                destination.setChanged();
                return true;
            }
            origItemStack.setCount(originalItemCount);
        }
        if (foundItem && level.paperConfig().hopper.cooldownWhenFull) {
            hopper.setCooldown(level.spigotConfig.hopperTransfer);
        }
        return false;
    }

    private static boolean hopperPull(Level level, Hopper hopper, Container container, ItemStack origItemStack, int i) {
        ItemStack movedItem = origItemStack;
        int originalItemCount = origItemStack.getCount();
        int movedItemCount = Math.min(level.spigotConfig.hopperAmount, originalItemCount);
        container.setChanged();
        movedItem.setCount(movedItemCount);
        if (!skipPullModeEventFire && (movedItem = HopperBlockEntity.callPullMoveEvent(hopper, container, movedItem)) == null) {
            origItemStack.setCount(originalItemCount);
            return true;
        }
        ItemStack remainingItem = HopperBlockEntity.addItem(container, hopper, movedItem, null);
        int remainingItemCount = remainingItem.getCount();
        if (remainingItemCount != movedItemCount) {
            origItemStack = origItemStack.copy(true);
            origItemStack.setCount(originalItemCount);
            if (!origItemStack.isEmpty()) {
                origItemStack.setCount(originalItemCount - movedItemCount + remainingItemCount);
            }
            BlockEntity.ignoreBlockEntityUpdates = true;
            container.setItem(i, origItemStack);
            BlockEntity.ignoreBlockEntityUpdates = false;
            container.setChanged();
            return true;
        }
        origItemStack.setCount(originalItemCount);
        if (level.paperConfig().hopper.cooldownWhenFull) {
            HopperBlockEntity.applyCooldown(hopper);
        }
        return false;
    }

    @Nullable
    private static ItemStack callPushMoveEvent(Container destination, ItemStack itemStack, HopperBlockEntity hopper) {
        Inventory destinationInventory = HopperBlockEntity.getInventory(destination);
        PaperInventoryMoveItemEvent event = new PaperInventoryMoveItemEvent(hopper.getOwner(false).getInventory(), CraftItemStack.asCraftMirror(itemStack), destinationInventory, true);
        boolean result = event.callEvent();
        if (!event.calledGetItem && !event.calledSetItem) {
            skipPushModeEventFire = true;
        }
        if (!result) {
            HopperBlockEntity.applyCooldown(hopper);
            return null;
        }
        if (event.calledSetItem) {
            return CraftItemStack.asNMSCopy(event.getItem());
        }
        return itemStack;
    }

    @Nullable
    private static ItemStack callPullMoveEvent(Hopper hopper, Container container, ItemStack itemstack) {
        Inventory sourceInventory = HopperBlockEntity.getInventory(container);
        Inventory destination = HopperBlockEntity.getInventory(hopper);
        PaperInventoryMoveItemEvent event = new PaperInventoryMoveItemEvent(sourceInventory, CraftItemStack.asCraftMirror(itemstack), destination, false);
        boolean result = event.callEvent();
        if (!event.calledGetItem && !event.calledSetItem) {
            skipPullModeEventFire = true;
        }
        if (!result) {
            HopperBlockEntity.applyCooldown(hopper);
            return null;
        }
        if (event.calledSetItem) {
            return CraftItemStack.asNMSCopy(event.getItem());
        }
        return itemstack;
    }

    private static Inventory getInventory(Container container) {
        CraftInventory sourceInventory;
        if (container instanceof CompoundContainer) {
            CompoundContainer compoundContainer = (CompoundContainer)container;
            sourceInventory = new CraftInventoryDoubleChest(compoundContainer);
        } else if (container instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)((Object)container);
            sourceInventory = blockEntity.getOwner(false).getInventory();
        } else {
            sourceInventory = container.getOwner() != null ? container.getOwner().getInventory() : new CraftInventory(container);
        }
        return sourceInventory;
    }

    private static void applyCooldown(Hopper hopper) {
        HopperBlockEntity blockEntity;
        if (hopper instanceof HopperBlockEntity && (blockEntity = (HopperBlockEntity)hopper).getLevel() != null) {
            blockEntity.setCooldown(blockEntity.getLevel().spigotConfig.hopperTransfer);
        }
    }

    private static boolean allMatch(Container container, Direction direction, BiPredicate<ItemStack, Integer> test) {
        if (container instanceof WorldlyContainer) {
            for (int slot : ((WorldlyContainer)container).getSlotsForFace(direction)) {
                if (test.test(container.getItem(slot), slot)) continue;
                return false;
            }
        } else {
            int size = container.getContainerSize();
            for (int slot = 0; slot < size; ++slot) {
                if (test.test(container.getItem(slot), slot)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean anyMatch(Container container, Direction direction, BiPredicate<ItemStack, Integer> test) {
        if (container instanceof WorldlyContainer) {
            for (int slot : ((WorldlyContainer)container).getSlotsForFace(direction)) {
                if (!test.test(container.getItem(slot), slot)) continue;
                return true;
            }
        } else {
            int size = container.getContainerSize();
            for (int slot = 0; slot < size; ++slot) {
                if (!test.test(container.getItem(slot), slot)) continue;
                return true;
            }
        }
        return true;
    }

    private static boolean ejectItems(Level level, BlockPos pos, HopperBlockEntity blockEntity) {
        Container attachedContainer = HopperBlockEntity.getAttachedContainer(level, pos, blockEntity);
        if (attachedContainer == null) {
            return false;
        }
        Direction opposite = blockEntity.facing.getOpposite();
        if (HopperBlockEntity.isFullContainer(attachedContainer, opposite)) {
            return false;
        }
        return HopperBlockEntity.hopperPush(level, attachedContainer, opposite, blockEntity);
    }

    private static int[] getSlots(Container container, Direction direction) {
        if (container instanceof WorldlyContainer) {
            WorldlyContainer worldlyContainer = (WorldlyContainer)container;
            return worldlyContainer.getSlotsForFace(direction);
        }
        int containerSize = container.getContainerSize();
        if (containerSize < CACHED_SLOTS.length) {
            int[] ints = CACHED_SLOTS[containerSize];
            if (ints != null) {
                return ints;
            }
            int[] ints1 = HopperBlockEntity.createFlatSlots(containerSize);
            HopperBlockEntity.CACHED_SLOTS[containerSize] = ints1;
            return ints1;
        }
        return HopperBlockEntity.createFlatSlots(containerSize);
    }

    private static int[] createFlatSlots(int size) {
        int[] ints = new int[size];
        int i = 0;
        while (i < ints.length) {
            ints[i] = i++;
        }
        return ints;
    }

    private static boolean isFullContainer(Container container, Direction direction) {
        int[] slots;
        for (int i : slots = HopperBlockEntity.getSlots(container, direction)) {
            ItemStack item = container.getItem(i);
            if (item.getCount() >= item.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public static boolean suckInItems(Level level, Hopper hopper) {
        boolean flag;
        BlockState blockState;
        BlockPos blockPos = BlockPos.containing(hopper.getLevelX(), hopper.getLevelY() + 1.0, hopper.getLevelZ());
        Container sourceContainer = HopperBlockEntity.getSourceContainer(level, hopper, blockPos, blockState = level.getBlockState(blockPos));
        if (sourceContainer != null) {
            Direction direction = Direction.DOWN;
            skipPullModeEventFire = skipHopperEvents;
            for (int i : HopperBlockEntity.getSlots(sourceContainer, direction)) {
                if (!HopperBlockEntity.tryTakeInItemFromSlot(hopper, sourceContainer, i, direction, level)) continue;
                return true;
            }
            return false;
        }
        boolean bl = flag = hopper.isGridAligned() && blockState.isCollisionShapeFullBlock(level, blockPos) && !blockState.is(BlockTags.DOES_NOT_BLOCK_HOPPERS);
        if (!flag) {
            for (ItemEntity itemEntity : HopperBlockEntity.getItemsAtAndAbove(level, hopper)) {
                if (!HopperBlockEntity.addItem(hopper, itemEntity)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(Hopper hopper, Container container, int slot, Direction direction, Level level) {
        ItemStack item = container.getItem(slot);
        if (!item.isEmpty() && HopperBlockEntity.canTakeItemFromContainer(hopper, container, item, slot, direction)) {
            return HopperBlockEntity.hopperPull(level, hopper, container, item, slot);
        }
        return false;
    }

    public static boolean addItem(Container container, ItemEntity item) {
        InventoryPickupItemEvent event;
        boolean flag = false;
        if (InventoryPickupItemEvent.getHandlerList().getRegisteredListeners().length > 0 && !(event = new InventoryPickupItemEvent(HopperBlockEntity.getInventory(container), (Item)item.getBukkitEntity())).callEvent()) {
            return false;
        }
        ItemStack itemStack = item.getItem().copy();
        ItemStack itemStack1 = HopperBlockEntity.addItem(null, container, itemStack, null);
        if (itemStack1.isEmpty()) {
            flag = true;
            item.setItem(ItemStack.EMPTY);
            item.discard(EntityRemoveEvent.Cause.PICKUP);
        } else {
            item.setItem(itemStack1);
        }
        return flag;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static ItemStack addItem(@Nullable Container source, Container destination, ItemStack stack, @Nullable Direction direction) {
        if (destination instanceof WorldlyContainer) {
            WorldlyContainer worldlyContainer = (WorldlyContainer)destination;
            if (direction != null) {
                int[] slotsForFace = worldlyContainer.getSlotsForFace(direction);
                int i = 0;
                while (i < slotsForFace.length) {
                    if (stack.isEmpty()) return stack;
                    stack = HopperBlockEntity.tryMoveInItem(source, destination, stack, slotsForFace[i], direction);
                    ++i;
                }
                return stack;
            }
        }
        int containerSize = destination.getContainerSize();
        int i = 0;
        while (i < containerSize) {
            if (stack.isEmpty()) return stack;
            stack = HopperBlockEntity.tryMoveInItem(source, destination, stack, i, direction);
            ++i;
        }
        return stack;
    }

    private static boolean canPlaceItemInContainer(Container container, ItemStack stack, int slot, @Nullable Direction direction) {
        WorldlyContainer worldlyContainer;
        return container.canPlaceItem(slot, stack) && (!(container instanceof WorldlyContainer) || (worldlyContainer = (WorldlyContainer)container).canPlaceItemThroughFace(slot, stack, direction));
    }

    private static boolean canTakeItemFromContainer(Container source, Container destination, ItemStack stack, int slot, Direction direction) {
        WorldlyContainer worldlyContainer;
        return destination.canTakeItem(source, slot, stack) && (!(destination instanceof WorldlyContainer) || (worldlyContainer = (WorldlyContainer)destination).canTakeItemThroughFace(slot, stack, direction));
    }

    private static ItemStack tryMoveInItem(@Nullable Container source, Container destination, ItemStack stack, int slot, @Nullable Direction direction) {
        ItemStack item = destination.getItem(slot);
        if (HopperBlockEntity.canPlaceItemInContainer(destination, stack, slot, direction)) {
            int min;
            boolean flag = false;
            boolean isEmpty = destination.isEmpty();
            if (item.isEmpty()) {
                ItemStack leftover = ItemStack.EMPTY;
                if (!stack.isEmpty() && stack.getCount() > destination.getMaxStackSize()) {
                    leftover = stack;
                    stack = stack.split(destination.getMaxStackSize());
                }
                BlockEntity.ignoreBlockEntityUpdates = true;
                destination.setItem(slot, stack);
                BlockEntity.ignoreBlockEntityUpdates = false;
                stack = leftover;
                flag = true;
            } else if (HopperBlockEntity.canMergeItems(item, stack)) {
                int i = Math.min(stack.getMaxStackSize(), destination.getMaxStackSize()) - item.getCount();
                min = Math.min(stack.getCount(), i);
                stack.shrink(min);
                item.grow(min);
                boolean bl = flag = min > 0;
            }
            if (flag) {
                HopperBlockEntity hopperBlockEntity;
                if (isEmpty && destination instanceof HopperBlockEntity && !(hopperBlockEntity = (HopperBlockEntity)destination).isOnCustomCooldown()) {
                    min = 0;
                    if (source instanceof HopperBlockEntity) {
                        HopperBlockEntity hopperBlockEntity1 = (HopperBlockEntity)source;
                        if (hopperBlockEntity.tickedGameTime >= hopperBlockEntity1.tickedGameTime) {
                            min = 1;
                        }
                    }
                    hopperBlockEntity.setCooldown(hopperBlockEntity.level.spigotConfig.hopperTransfer - min);
                }
                destination.setChanged();
            }
        }
        return stack;
    }

    @Nullable
    private static Container runHopperInventorySearchEvent(Container container, CraftBlock hopper, CraftBlock searchLocation, HopperInventorySearchEvent.ContainerType containerType) {
        HopperInventorySearchEvent event = new HopperInventorySearchEvent((Inventory)(container != null ? new CraftInventory(container) : null), containerType, (org.bukkit.block.Block)hopper, (org.bukkit.block.Block)searchLocation);
        event.callEvent();
        return event.getInventory() != null ? ((CraftInventory)event.getInventory()).getInventory() : null;
    }

    @Nullable
    private static Container getAttachedContainer(Level level, BlockPos pos, HopperBlockEntity blockEntity) {
        BlockPos searchPosition = pos.relative(blockEntity.facing);
        Container inventory = HopperBlockEntity.getContainerAt(level, searchPosition);
        CraftBlock hopper = CraftBlock.at(level, pos);
        CraftBlock searchBlock = CraftBlock.at(level, searchPosition);
        return HopperBlockEntity.runHopperInventorySearchEvent(inventory, hopper, searchBlock, HopperInventorySearchEvent.ContainerType.DESTINATION);
    }

    @Nullable
    private static Container getSourceContainer(Level level, Hopper hopper, BlockPos pos, BlockState state) {
        Container inventory = HopperBlockEntity.getContainerAt(level, pos, state, hopper.getLevelX(), hopper.getLevelY() + 1.0, hopper.getLevelZ());
        BlockPos hopperPos = BlockPos.containing(hopper.getLevelX(), hopper.getLevelY(), hopper.getLevelZ());
        CraftBlock hopperBlock = CraftBlock.at(level, hopperPos);
        CraftBlock containerBlock = CraftBlock.at(level, hopperPos.above());
        return HopperBlockEntity.runHopperInventorySearchEvent(inventory, hopperBlock, containerBlock, HopperInventorySearchEvent.ContainerType.SOURCE);
    }

    public static List<ItemEntity> getItemsAtAndAbove(Level level, Hopper hopper) {
        AABB aabb = hopper.getSuckAabb().move(hopper.getLevelX() - 0.5, hopper.getLevelY() - 0.5, hopper.getLevelZ() - 0.5);
        return level.getEntitiesOfClass(ItemEntity.class, aabb, EntitySelector.ENTITY_STILL_ALIVE);
    }

    @Nullable
    public static Container getContainerAt(Level level, BlockPos pos) {
        return HopperBlockEntity.getContainerAt(level, pos, level.getBlockState(pos), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, true);
    }

    @Nullable
    private static Container getContainerAt(Level level, BlockPos pos, BlockState state, double x, double y, double z) {
        return HopperBlockEntity.getContainerAt(level, pos, state, x, y, z, false);
    }

    @Nullable
    private static Container getContainerAt(Level level, BlockPos pos, BlockState state, double x, double y, double z, boolean optimizeEntities) {
        Container blockContainer = HopperBlockEntity.getBlockContainer(level, pos, state);
        if (!(blockContainer != null || optimizeEntities && level.paperConfig().hopper.ignoreOccludingBlocks && state.getBukkitMaterial().isOccluding())) {
            blockContainer = HopperBlockEntity.getEntityContainer(level, x, y, z);
        }
        return blockContainer;
    }

    @Nullable
    private static Container getBlockContainer(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (!level.spigotConfig.hopperCanLoadChunks && !level.hasChunkAt(pos)) {
            return null;
        }
        Block block = state.getBlock();
        if (block instanceof WorldlyContainerHolder) {
            return ((WorldlyContainerHolder)((Object)block)).getContainer(state, level, pos);
        }
        if (state.hasBlockEntity() && (blockEntity = level.getBlockEntity(pos)) instanceof Container) {
            Container container = (Container)((Object)blockEntity);
            if (container instanceof ChestBlockEntity && block instanceof ChestBlock) {
                container = ChestBlock.getContainer((ChestBlock)block, state, level, pos, true);
            }
            return container;
        }
        return null;
    }

    @Nullable
    private static Container getEntityContainer(Level level, double x, double y, double z) {
        List<Entity> entities = level.getEntitiesOfClass(Container.class, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntitySelector.CONTAINER_ENTITY_SELECTOR);
        return !entities.isEmpty() ? (Container)((Object)entities.get(level.random.nextInt(entities.size()))) : null;
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        return stack1.getCount() < stack1.getMaxStackSize() && ItemStack.isSameItemSameComponents(stack1, stack2);
    }

    @Override
    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    @Override
    public boolean isGridAligned() {
        return true;
    }

    public void setCooldown(int cooldownTime) {
        this.cooldownTime = cooldownTime;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    private boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public static void entityInside(Level level, BlockPos pos, BlockState state, Entity entity, HopperBlockEntity blockEntity) {
        ItemEntity itemEntity;
        if (entity instanceof ItemEntity && !(itemEntity = (ItemEntity)entity).getItem().isEmpty() && entity.getBoundingBox().move(-pos.getX(), -pos.getY(), -pos.getZ()).intersects(blockEntity.getSuckAabb())) {
            HopperBlockEntity.tryMoveItems(level, pos, state, blockEntity, () -> HopperBlockEntity.addItem(blockEntity, itemEntity));
        }
    }

    @Override
    protected AbstractContainerMenu createMenu(int id, net.minecraft.world.entity.player.Inventory player) {
        return new HopperMenu(id, player, this);
    }

    static {
        STACK_SIZE_TEST = (itemStack, i) -> itemStack.getCount() >= itemStack.getMaxStackSize();
        IS_EMPTY_TEST = (itemStack, i) -> itemStack.isEmpty();
    }
}

