/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public interface PlayerDetector {
    public static final PlayerDetector NO_CREATIVE_PLAYERS = (level, entitySelector, pos, maxDistance, requireLineOfSight) -> entitySelector.getPlayers(level, player -> player.blockPosition().closerThan(pos, maxDistance) && !player.isCreative() && !player.isSpectator()).stream().filter(player -> !requireLineOfSight || PlayerDetector.inLineOfSight(level, pos.getCenter(), player.getEyePosition())).map(Entity::getUUID).toList();
    public static final PlayerDetector INCLUDING_CREATIVE_PLAYERS = (level, entitySelector, pos, maxDistance, requireLineOfSight) -> entitySelector.getPlayers(level, player -> player.blockPosition().closerThan(pos, maxDistance) && !player.isSpectator()).stream().filter(player -> !requireLineOfSight || PlayerDetector.inLineOfSight(level, pos.getCenter(), player.getEyePosition())).map(Entity::getUUID).toList();
    public static final PlayerDetector SHEEP = (level, entitySelector, pos, maxDistance, requireLineOfSight) -> {
        AABB aabb = new AABB(pos).inflate(maxDistance);
        return entitySelector.getEntities(level, EntityType.SHEEP, aabb, LivingEntity::isAlive).stream().filter(sheep -> !requireLineOfSight || PlayerDetector.inLineOfSight(level, pos.getCenter(), sheep.getEyePosition())).map(Entity::getUUID).toList();
    };

    public List<UUID> detect(ServerLevel var1, EntitySelector var2, BlockPos var3, double var4, boolean var6);

    private static boolean inLineOfSight(Level level, Vec3 pos, Vec3 targetPos) {
        BlockHitResult blockHitResult = level.clip(new ClipContext(targetPos, pos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return blockHitResult.getBlockPos().equals(BlockPos.containing(pos)) || blockHitResult.getType() == HitResult.Type.MISS;
    }

    public static interface EntitySelector {
        public static final EntitySelector SELECT_FROM_LEVEL = new EntitySelector(){

            public List<ServerPlayer> getPlayers(ServerLevel level, Predicate<? super Player> predicate) {
                return level.getPlayers(predicate);
            }

            @Override
            public <T extends Entity> List<T> getEntities(ServerLevel level, EntityTypeTest<Entity, T> typeTest, AABB boundingBox, Predicate<? super T> predicate) {
                return level.getEntities(typeTest, boundingBox, predicate);
            }
        };

        public List<? extends Player> getPlayers(ServerLevel var1, Predicate<? super Player> var2);

        public <T extends Entity> List<T> getEntities(ServerLevel var1, EntityTypeTest<Entity, T> var2, AABB var3, Predicate<? super T> var4);

        public static EntitySelector onlySelectPlayer(Player player) {
            return EntitySelector.onlySelectPlayers(List.of(player));
        }

        public static EntitySelector onlySelectPlayers(final List<Player> players) {
            return new EntitySelector(){

                public List<Player> getPlayers(ServerLevel level, Predicate<? super Player> predicate) {
                    return players.stream().filter(predicate).toList();
                }

                @Override
                public <T extends Entity> List<T> getEntities(ServerLevel level, EntityTypeTest<Entity, T> typeTest, AABB boundingBox, Predicate<? super T> predicate) {
                    return players.stream().map(typeTest::tryCast).filter(Objects::nonNull).filter(predicate).toList();
                }
            };
        }
    }
}

