/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class PistonBaseBlock
extends DirectionalBlock {
    public static final MapCodec<PistonBaseBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("sticky").forGetter(pistonBaseBlock -> pistonBaseBlock.isSticky), PistonBaseBlock.propertiesCodec()).apply((Applicative)instance, PistonBaseBlock::new));
    public static final BooleanProperty EXTENDED = BlockStateProperties.EXTENDED;
    public static final int TRIGGER_EXTEND = 0;
    public static final int TRIGGER_CONTRACT = 1;
    public static final int TRIGGER_DROP = 2;
    public static final int PLATFORM_THICKNESS = 4;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateAll(Block.boxZ(16.0, 4.0, 16.0));
    private final boolean isSticky;

    public MapCodec<PistonBaseBlock> codec() {
        return CODEC;
    }

    public PistonBaseBlock(boolean isSticky, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any().setValue(DirectionalBlock.FACING, Direction.NORTH)).setValue(EXTENDED, false));
        this.isSticky = isSticky;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue(EXTENDED) != false ? SHAPES.get(state.getValue(DirectionalBlock.FACING)) : Shapes.block();
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!level.isClientSide) {
            this.checkIfExtend(level, pos, state);
        }
    }

    @Override
    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (!level.isClientSide) {
            this.checkIfExtend(level, pos, state);
        }
    }

    @Override
    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock()) && !level.isClientSide && level.getBlockEntity(pos) == null) {
            this.checkIfExtend(level, pos, state);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(DirectionalBlock.FACING, context.getNearestLookingDirection().getOpposite())).setValue(EXTENDED, false);
    }

    private void checkIfExtend(Level level, BlockPos pos, BlockState state) {
        Direction direction = state.getValue(DirectionalBlock.FACING);
        boolean neighborSignal = this.getNeighborSignal(level, pos, direction);
        if (neighborSignal && !state.getValue(EXTENDED).booleanValue()) {
            if (new PistonStructureResolver(level, pos, direction, true).resolve()) {
                level.blockEvent(pos, this, 0, direction.get3DDataValue());
            }
        } else if (!neighborSignal && state.getValue(EXTENDED).booleanValue()) {
            PistonMovingBlockEntity pistonMovingBlockEntity;
            BlockEntity blockEntity;
            BlockPos blockPos = pos.relative(direction, 2);
            BlockState blockState = level.getBlockState(blockPos);
            int i = 1;
            if (blockState.is(Blocks.MOVING_PISTON) && blockState.getValue(DirectionalBlock.FACING) == direction && (blockEntity = level.getBlockEntity(blockPos)) instanceof PistonMovingBlockEntity && (pistonMovingBlockEntity = (PistonMovingBlockEntity)blockEntity).isExtending() && (pistonMovingBlockEntity.getProgress(0.0f) < 0.5f || level.getGameTime() == pistonMovingBlockEntity.getLastTicked() || ((ServerLevel)level).isHandlingTick())) {
                i = 2;
            }
            level.blockEvent(pos, this, i, direction.get3DDataValue());
        }
    }

    private boolean getNeighborSignal(SignalGetter signalGetter, BlockPos pos, Direction direction) {
        for (Direction direction1 : Direction.values()) {
            if (direction1 == direction || !signalGetter.hasSignal(pos.relative(direction1), direction1)) continue;
            return true;
        }
        if (signalGetter.hasSignal(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos blockPos = pos.above();
        for (Direction direction2 : Direction.values()) {
            if (direction2 == Direction.DOWN || !signalGetter.hasSignal(blockPos.relative(direction2), direction2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        Direction direction = state.getValue(DirectionalBlock.FACING);
        Direction directionQueuedAs = Direction.from3DDataValue(param & 7);
        if (!GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits && direction != directionQueuedAs) {
            return false;
        }
        BlockState blockState = (BlockState)state.setValue(EXTENDED, true);
        if (!level.isClientSide) {
            boolean neighborSignal = this.getNeighborSignal(level, pos, direction);
            if (neighborSignal && (id == 1 || id == 2)) {
                level.setBlock(pos, blockState, 2);
                return false;
            }
            if (!neighborSignal && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (!this.moveBlocks(level, pos, direction, true)) {
                return false;
            }
            level.setBlock(pos, blockState, 67);
            level.playSound(null, pos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.25f + 0.6f);
            level.gameEvent(GameEvent.BLOCK_ACTIVATE, pos, GameEvent.Context.of(blockState));
        } else if (id == 1 || id == 2) {
            BlockEntity blockEntity = level.getBlockEntity(pos.relative(direction));
            if (blockEntity instanceof PistonMovingBlockEntity) {
                ((PistonMovingBlockEntity)blockEntity).finalTick();
            }
            BlockState blockState1 = (BlockState)((BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(MovingPistonBlock.FACING, direction)).setValue(MovingPistonBlock.TYPE, this.isSticky ? PistonType.STICKY : PistonType.DEFAULT);
            if (!this.isSticky && !new BlockPistonRetractEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), Collections.emptyList(), CraftBlock.notchToBlockFace(direction)).callEvent()) {
                return false;
            }
            level.setBlock(pos, blockState1, 276);
            level.setBlockEntity(MovingPistonBlock.newMovingBlockEntity(pos, blockState1, (BlockState)this.defaultBlockState().setValue(DirectionalBlock.FACING, Direction.from3DDataValue(param & 7)), direction, false, true));
            level.updateNeighborsAt(pos, blockState1.getBlock());
            blockState1.updateNeighbourShapes(level, pos, 2);
            if (this.isSticky) {
                PistonMovingBlockEntity pistonMovingBlockEntity;
                BlockEntity blockEntity2;
                BlockPos blockPos = pos.offset(direction.getStepX() * 2, direction.getStepY() * 2, direction.getStepZ() * 2);
                BlockState blockState2 = level.getBlockState(blockPos);
                boolean flag = false;
                if (blockState2.is(Blocks.MOVING_PISTON) && (blockEntity2 = level.getBlockEntity(blockPos)) instanceof PistonMovingBlockEntity && (pistonMovingBlockEntity = (PistonMovingBlockEntity)blockEntity2).getDirection() == direction && pistonMovingBlockEntity.isExtending()) {
                    pistonMovingBlockEntity.finalTick();
                    flag = true;
                }
                if (!flag) {
                    if (id != 1 || blockState2.isAir() || !PistonBaseBlock.isPushable(blockState2, level, blockPos, direction.getOpposite(), false, direction) || blockState2.getPistonPushReaction() != PushReaction.NORMAL && !blockState2.is(Blocks.PISTON) && !blockState2.is(Blocks.STICKY_PISTON)) {
                        if (id == 1 && blockState1.isAir() && !new BlockPistonRetractEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), Collections.emptyList(), CraftBlock.notchToBlockFace(direction)).callEvent()) {
                            return false;
                        }
                        level.removeBlock(pos.relative(direction), false);
                    } else {
                        this.moveBlocks(level, pos, direction, false);
                    }
                }
            } else {
                BlockPos headPos = pos.relative(direction);
                if (GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits || level.getBlockState(headPos) == Blocks.PISTON_HEAD.defaultBlockState().setValue(DirectionalBlock.FACING, direction)) {
                    level.removeBlock(headPos, false);
                } else {
                    ((ServerLevel)level).getChunkSource().blockChanged(headPos);
                }
            }
            level.playSound(null, pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 0.6f);
            level.gameEvent(GameEvent.BLOCK_DEACTIVATE, pos, GameEvent.Context.of(blockState1));
        }
        return true;
    }

    public static boolean isPushable(BlockState state, Level level, BlockPos pos, Direction movementDirection, boolean allowDestroy, Direction pistonFacing) {
        if (pos.getY() < level.getMinY() || pos.getY() > level.getMaxY() || !level.getWorldBorder().isWithinBounds(pos) || !level.getWorldBorder().isWithinBounds(pos.relative(movementDirection))) {
            return false;
        }
        if (state.isAir()) {
            return true;
        }
        if (state.is(Blocks.OBSIDIAN) || state.is(Blocks.CRYING_OBSIDIAN) || state.is(Blocks.RESPAWN_ANCHOR) || state.is(Blocks.REINFORCED_DEEPSLATE)) {
            return false;
        }
        if (movementDirection == Direction.DOWN && pos.getY() == level.getMinY()) {
            return false;
        }
        if (movementDirection == Direction.UP && pos.getY() == level.getMaxY()) {
            return false;
        }
        if (!state.is(Blocks.PISTON) && !state.is(Blocks.STICKY_PISTON)) {
            if (state.getDestroySpeed(level, pos) == -1.0f) {
                return false;
            }
            switch (state.getPistonPushReaction()) {
                case BLOCK: {
                    return false;
                }
                case DESTROY: {
                    return allowDestroy;
                }
                case PUSH_ONLY: {
                    return movementDirection == pistonFacing;
                }
            }
        } else if (state.getValue(EXTENDED).booleanValue()) {
            return false;
        }
        return !state.hasBlockEntity();
    }

    /*
     * WARNING - void declaration
     */
    private boolean moveBlocks(final Level level, BlockPos pos, Direction facing, boolean extending) {
        void var21_41;
        void var21_39;
        int i1;
        PistonStructureResolver pistonStructureResolver;
        BlockPos blockPos = pos.relative(facing);
        if (!extending && level.getBlockState(blockPos).is(Blocks.PISTON_HEAD)) {
            level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 276);
        }
        if (!(pistonStructureResolver = new PistonStructureResolver(level, pos, facing, extending)).resolve()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPos> toPush = pistonStructureResolver.getToPush();
        ArrayList list = Lists.newArrayList();
        for (BlockPos blockPos1 : toPush) {
            BlockState blockState = level.getBlockState(blockPos1);
            list.add(blockState);
            map.put(blockPos1, blockState);
        }
        List<BlockPos> toDestroy = pistonStructureResolver.getToDestroy();
        BlockState[] blockStates = new BlockState[toPush.size() + toDestroy.size()];
        Direction direction = extending ? facing : facing.getOpposite();
        int i = 0;
        CraftBlock bukkitBlock = CraftBlock.at(level, pos);
        final List<BlockPos> moved = pistonStructureResolver.getToPush();
        final List<BlockPos> broken = pistonStructureResolver.getToDestroy();
        AbstractList<org.bukkit.block.Block> blocks = new AbstractList<org.bukkit.block.Block>(this){

            @Override
            public int size() {
                return moved.size() + broken.size();
            }

            @Override
            public org.bukkit.block.Block get(int index) {
                if (index >= this.size() || index < 0) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                BlockPos pos = index < moved.size() ? (BlockPos)moved.get(index) : (BlockPos)broken.get(index - moved.size());
                return CraftBlock.at(level, pos);
            }
        };
        Object event = extending ? new BlockPistonExtendEvent((org.bukkit.block.Block)bukkitBlock, (List)blocks, CraftBlock.notchToBlockFace(direction)) : new BlockPistonRetractEvent((org.bukkit.block.Block)bukkitBlock, (List)blocks, CraftBlock.notchToBlockFace(direction));
        if (!event.callEvent()) {
            for (BlockPos brokenPos : broken) {
                level.sendBlockUpdated(brokenPos, Blocks.AIR.defaultBlockState(), level.getBlockState(brokenPos), 3);
            }
            for (BlockPos movedPos : moved) {
                level.sendBlockUpdated(movedPos, Blocks.AIR.defaultBlockState(), level.getBlockState(movedPos), 3);
                movedPos = movedPos.relative(direction);
                level.sendBlockUpdated(movedPos, Blocks.AIR.defaultBlockState(), level.getBlockState(movedPos), 3);
            }
            return false;
        }
        for (i1 = toDestroy.size() - 1; i1 >= 0; --i1) {
            BlockPos blockPos2 = toDestroy.get(i1);
            BlockState blockState = level.getBlockState(blockPos2);
            BlockEntity blockEntity = blockState.hasBlockEntity() ? level.getBlockEntity(blockPos2) : null;
            PistonBaseBlock.dropResources(blockState, level, blockPos2, blockEntity, pos);
            if (!blockState.is(BlockTags.FIRE) && level.isClientSide()) {
                level.levelEvent(2001, blockPos2, PistonBaseBlock.getId(blockState));
            }
            level.setBlock(blockPos2, Blocks.AIR.defaultBlockState(), 18);
            level.gameEvent(GameEvent.BLOCK_DESTROY, blockPos2, GameEvent.Context.of(blockState));
            blockStates[i++] = blockState;
        }
        for (i1 = toPush.size() - 1; i1 >= 0; --i1) {
            BlockPos blockPos2;
            boolean allowDesync = GlobalConfiguration.get().unsupportedSettings.allowPistonDuplication;
            BlockPos oldPos = blockPos2 = toPush.get(i1);
            BlockState blockState12 = allowDesync ? level.getBlockState(oldPos) : null;
            BlockPos blockPos3 = blockPos2.relative(direction);
            map.remove(blockPos3);
            BlockState blockState2 = (BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(DirectionalBlock.FACING, facing);
            level.setBlock(blockPos3, blockState2, 324);
            if (!allowDesync) {
                blockState12 = level.getBlockState(oldPos);
                map.replace(oldPos, blockState12);
            }
            level.setBlockEntity(MovingPistonBlock.newMovingBlockEntity(blockPos3, blockState2, allowDesync ? (BlockState)list.get(i1) : blockState12, facing, extending, false));
            if (!allowDesync) {
                level.setBlock(oldPos, Blocks.AIR.defaultBlockState(), 594);
            }
            blockStates[i++] = blockState12;
        }
        if (extending) {
            PistonType pistonType = this.isSticky ? PistonType.STICKY : PistonType.DEFAULT;
            BlockState blockState3 = (BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(DirectionalBlock.FACING, facing)).setValue(PistonHeadBlock.TYPE, pistonType);
            BlockState blockState = (BlockState)((BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(MovingPistonBlock.FACING, facing)).setValue(MovingPistonBlock.TYPE, this.isSticky ? PistonType.STICKY : PistonType.DEFAULT);
            map.remove(blockPos);
            level.setBlock(blockPos, blockState, 324);
            level.setBlockEntity(MovingPistonBlock.newMovingBlockEntity(blockPos, blockState, blockState3, facing, true, true));
        }
        BlockState blockState4 = Blocks.AIR.defaultBlockState();
        for (BlockPos blockPos4 : map.keySet()) {
            level.setBlock(blockPos4, blockState4, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPos blockPos4 = (BlockPos)entry.getKey();
            BlockState blockState5 = (BlockState)entry.getValue();
            blockState5.updateIndirectNeighbourShapes(level, blockPos4, 2);
            blockState4.updateNeighbourShapes(level, blockPos4, 2);
            blockState4.updateIndirectNeighbourShapes(level, blockPos4, 2);
        }
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(level, pistonStructureResolver.getPushDirection(), null);
        i = 0;
        int n = toDestroy.size() - 1;
        while (var21_39 >= 0) {
            BlockState blockState2 = blockStates[i++];
            BlockPos blockPos5 = toDestroy.get((int)var21_39);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                blockState2.affectNeighborsAfterRemoval(serverLevel, blockPos5, false);
            }
            blockState2.updateIndirectNeighbourShapes(level, blockPos5, 2);
            level.updateNeighborsAt(blockPos5, blockState2.getBlock(), orientation);
            --var21_39;
        }
        int n2 = toPush.size() - 1;
        while (var21_41 >= 0) {
            level.updateNeighborsAt(toPush.get((int)var21_41), blockStates[i++].getBlock(), orientation);
            --var21_41;
        }
        if (extending) {
            level.updateNeighborsAt(blockPos, Blocks.PISTON_HEAD, orientation);
        }
        return true;
    }

    @Override
    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(DirectionalBlock.FACING, rot.rotate(state.getValue(DirectionalBlock.FACING)));
    }

    @Override
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation(state.getValue(DirectionalBlock.FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(DirectionalBlock.FACING, EXTENDED);
    }

    @Override
    protected boolean useShapeForLightOcclusion(BlockState state) {
        return state.getValue(EXTENDED);
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

