/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.sounds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class AmbientDesertBlockSoundsPlayer {
    private static final int IDLE_SOUND_CHANCE = 1600;
    private static final int WIND_SOUND_CHANCE = 10000;
    private static final int SURROUNDING_BLOCKS_PLAY_SOUND_THRESHOLD = 3;
    private static final int SURROUNDING_BLOCKS_DISTANCE_CHECK = 8;

    public static void playAmbientBlockSounds(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (state.is(BlockTags.PLAYS_AMBIENT_DESERT_BLOCK_SOUNDS) && level.canSeeSky(pos.above())) {
            if (random.nextInt(1600) == 0 && AmbientDesertBlockSoundsPlayer.shouldPlayAmbientSound(level, pos)) {
                level.playLocalSound(pos.getX(), pos.getY(), pos.getZ(), SoundEvents.SAND_IDLE, SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
            if (random.nextInt(10000) == 0 && AmbientDesertBlockSoundsPlayer.isInAmbientSoundBiome(level.getBiome(pos)) && AmbientDesertBlockSoundsPlayer.shouldPlayAmbientSound(level, pos)) {
                level.playPlayerSound(SoundEvents.SAND_WIND, SoundSource.AMBIENT, 1.0f, 1.0f);
            }
        }
    }

    private static boolean isInAmbientSoundBiome(Holder<Biome> biome) {
        return biome.is(Biomes.DESERT) || biome.is(BiomeTags.IS_BADLANDS);
    }

    private static boolean shouldPlayAmbientSound(Level level, BlockPos pos) {
        int i = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = pos.relative(direction, 8);
            BlockState blockState = level.getBlockState(blockPos.atY(level.getHeight(Heightmap.Types.WORLD_SURFACE, blockPos) - 1));
            if (!blockState.is(BlockTags.PLAYS_AMBIENT_DESERT_BLOCK_SOUNDS) || ++i < 3) continue;
            return true;
        }
        return false;
    }
}

