/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.PropertyAccessStateHolder;
import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.util.ZeroCollidingReferenceStateTable;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class StateHolder<O, S>
implements PropertyAccessStateHolder {
    public static final String NAME_TAG = "Name";
    public static final String PROPERTIES_TAG = "Properties";
    public static final Function<Map.Entry<Property<?>, Comparable<?>>, String> PROPERTY_ENTRY_TO_STRING_FUNCTION = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> propertyEntry) {
            if (propertyEntry == null) {
                return "<NULL>";
            }
            Property<?> property = propertyEntry.getKey();
            return property.getName() + "=" + this.getName(property, propertyEntry.getValue());
        }

        private <T extends Comparable<T>> String getName(Property<T> property, Comparable<?> value) {
            return property.getName(value);
        }
    };
    protected final O owner;
    private Reference2ObjectArrayMap<Property<?>, Comparable<?>> values;
    private Map<Property<?>, S[]> neighbours;
    protected final MapCodec<S> propertiesCodec;
    protected ZeroCollidingReferenceStateTable<O, S> optimisedTable;
    protected final long tableIndex;

    @Override
    public final long moonrise$getTableIndex() {
        return this.tableIndex;
    }

    protected StateHolder(O owner, Reference2ObjectArrayMap<Property<?>, Comparable<?>> values, MapCodec<S> propertiesCodec) {
        this.owner = owner;
        this.values = values;
        this.propertiesCodec = propertiesCodec;
        this.optimisedTable = new ZeroCollidingReferenceStateTable((Collection<Property<?>>)this.values.keySet());
        this.tableIndex = this.optimisedTable.getIndex(this);
    }

    public <T extends Comparable<T>> S cycle(Property<T> property) {
        return this.setValue(property, (Comparable)StateHolder.findNextInCollection(property.getPossibleValues(), this.getValue(property)));
    }

    protected static <T> T findNextInCollection(List<T> possibleValues, T currentValue) {
        int i = possibleValues.indexOf(currentValue) + 1;
        return i == possibleValues.size() ? possibleValues.getFirst() : possibleValues.get(i);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.owner);
        if (!this.getValues().isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(this.getValues().entrySet().stream().map(PROPERTY_ENTRY_TO_STRING_FUNCTION).collect(Collectors.joining(",")));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public final boolean equals(Object other) {
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Collection<Property<?>> getProperties() {
        return this.optimisedTable.getProperties();
    }

    public boolean hasProperty(Property<?> property) {
        return property != null && this.optimisedTable.hasProperty(property);
    }

    public <T extends Comparable<T>> T getValue(Property<T> property) {
        T ret = this.optimisedTable.get(this.tableIndex, property);
        if (ret != null) {
            return ret;
        }
        throw new IllegalArgumentException("Cannot get property " + String.valueOf(property) + " as it does not exist in " + String.valueOf(this.owner));
    }

    public <T extends Comparable<T>> Optional<T> getOptionalValue(Property<T> property) {
        return Optional.ofNullable(this.getNullableValue(property));
    }

    public <T extends Comparable<T>> T getValueOrElse(Property<T> property, T defaultValue) {
        return (T)((Comparable)Objects.requireNonNullElse(this.getNullableValue(property), defaultValue));
    }

    @Nullable
    private <T extends Comparable<T>> T getNullableValue(Property<T> property) {
        return property == null ? null : (T)this.optimisedTable.get(this.tableIndex, property);
    }

    public <T extends Comparable<T>, V extends T> S setValue(Property<T> property, V value) {
        S ret = this.optimisedTable.set(this.tableIndex, property, value);
        if (ret != null) {
            return ret;
        }
        throw new IllegalArgumentException("Cannot set property " + String.valueOf(property) + " to " + String.valueOf(value) + " on " + String.valueOf(this.owner));
    }

    public <T extends Comparable<T>, V extends T> S trySetValue(Property<T> property, V value) {
        if (property == null) {
            return (S)this;
        }
        StateHolder ret = this.optimisedTable.trySet(this.tableIndex, property, value, this);
        if (ret != null) {
            return (S)ret;
        }
        throw new IllegalArgumentException("Cannot set property " + String.valueOf(property) + " to " + String.valueOf(value) + " on " + String.valueOf(this.owner));
    }

    private <T extends Comparable<T>, V extends T> S setValueInternal(Property<T> property, V value, Comparable<?> comparable) {
        if (comparable.equals(value)) {
            return (S)this;
        }
        int internalIndex = property.getInternalIndex(value);
        if (internalIndex < 0) {
            throw new IllegalArgumentException("Cannot set property " + String.valueOf(property) + " to " + String.valueOf(value) + " on " + String.valueOf(this.owner) + ", it is not an allowed value");
        }
        return this.neighbours.get(property)[internalIndex];
    }

    public void populateNeighbours(Map<Map<Property<?>, Comparable<?>>, S> possibleStateMap) {
        S value;
        Map<Map<Property<?>, Comparable<?>>, S> map = possibleStateMap;
        if (this.optimisedTable.isLoaded()) {
            return;
        }
        this.optimisedTable.loadInTable(map);
        for (Map.Entry<Map<Property<?>, Comparable<?>>, S> entry : map.entrySet()) {
            value = entry.getValue();
            ((StateHolder)value).optimisedTable = this.optimisedTable;
        }
        for (Map.Entry<Map<Property<?>, Comparable<?>>, S> entry : map.entrySet()) {
            value = entry.getValue();
            ((StateHolder)value).values = null;
        }
    }

    private Map<Property<?>, Comparable<?>> makeNeighbourValues(Property<?> property, Comparable<?> value) {
        Reference2ObjectArrayMap map = new Reference2ObjectArrayMap(this.values);
        map.put(property, value);
        return map;
    }

    public Map<Property<?>, Comparable<?>> getValues() {
        ZeroCollidingReferenceStateTable<O, S> table = this.optimisedTable;
        return table.isLoaded() ? table.getMapView(this.tableIndex) : this.values;
    }

    protected static <O, S extends StateHolder<O, S>> Codec<S> codec(Codec<O> propertyMap, Function<O, S> holderFunction) {
        return propertyMap.dispatch(NAME_TAG, stateHolder -> stateHolder.owner, object -> {
            StateHolder stateHolder = (StateHolder)holderFunction.apply(object);
            return stateHolder.getValues().isEmpty() ? MapCodec.unit((Object)stateHolder) : stateHolder.propertiesCodec.codec().lenientOptionalFieldOf(PROPERTIES_TAG).xmap(optional -> optional.orElse(stateHolder), Optional::of);
        });
    }
}

