/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemChunkBuffer;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemRegionFile;
import ca.spottedleaf.moonrise.patches.chunk_system.util.stream.ExternalChunkStreamMarker;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionBitmap;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionFileVersion;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import org.slf4j.Logger;

public class RegionFile
implements AutoCloseable,
ChunkSystemRegionFile {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MAX_CHUNK_SIZE = 524288000;
    private static final int SECTOR_BYTES = 4096;
    @VisibleForTesting
    protected static final int SECTOR_INTS = 1024;
    private static final int CHUNK_HEADER_SIZE = 5;
    private static final int HEADER_OFFSET = 0;
    private static final ByteBuffer PADDING_BUFFER = ByteBuffer.allocateDirect(1);
    private static final String EXTERNAL_FILE_EXTENSION = ".mcc";
    private static final int EXTERNAL_STREAM_FLAG = 128;
    private static final int EXTERNAL_CHUNK_THRESHOLD = 256;
    private static final int CHUNK_NOT_PRESENT = 0;
    final RegionStorageInfo info;
    private final Path path;
    private final FileChannel file;
    private final Path externalFileDir;
    final RegionFileVersion version;
    private final ByteBuffer header = ByteBuffer.allocateDirect(8192);
    private final IntBuffer offsets;
    private final IntBuffer timestamps;
    @VisibleForTesting
    protected final RegionBitmap usedSectors = new RegionBitmap();
    private static final CompoundTag OVERSIZED_COMPOUND = new CompoundTag();
    private final AtomicInteger recalculateCount = new AtomicInteger();
    final boolean canRecalcHeader;
    private final byte[] oversized = new byte[1024];
    private int oversizedCount;

    private static long roundToSectors(long bytes) {
        long sectors = bytes >>> 12;
        long remainingBytes = bytes & 0xFFFL;
        long sign = -remainingBytes;
        return sectors + (sign >>> 63);
    }

    @Nullable
    private CompoundTag attemptRead(long sector, int chunkDataLength, long fileLength) throws IOException {
        try {
            if (chunkDataLength < 0) {
                return null;
            }
            long offset = sector * 4096L + 4L;
            if (offset + (long)chunkDataLength > fileLength) {
                return null;
            }
            ByteBuffer chunkData = ByteBuffer.allocate(chunkDataLength);
            if (chunkDataLength != this.file.read(chunkData, offset)) {
                return null;
            }
            ((Buffer)chunkData).flip();
            byte compressionType = chunkData.get();
            if (compressionType < 0) {
                return OVERSIZED_COMPOUND;
            }
            RegionFileVersion compression = RegionFileVersion.fromId(compressionType);
            if (compression == null) {
                return null;
            }
            InputStream input = compression.wrap(new ByteArrayInputStream(chunkData.array(), chunkData.position(), chunkDataLength - chunkData.position()));
            return NbtIo.read(new DataInputStream(input));
        }
        catch (Exception ex) {
            return null;
        }
    }

    private int getLength(long sector) throws IOException {
        ByteBuffer length = ByteBuffer.allocate(4);
        if (4 != this.file.read(length, sector * 4096L)) {
            return -1;
        }
        return length.getInt(0);
    }

    private void backupRegionFile() {
        Path backup = this.path.getParent().resolve(String.valueOf(this.path.getFileName()) + "." + new Random().nextLong() + ".backup");
        this.backupRegionFile(backup);
    }

    private void backupRegionFile(Path to) {
        try {
            this.file.force(true);
            LOGGER.warn("Backing up regionfile \"" + String.valueOf(this.path.toAbsolutePath()) + "\" to " + String.valueOf(to.toAbsolutePath()));
            Files.copy(this.path, to, StandardCopyOption.COPY_ATTRIBUTES);
            LOGGER.warn("Backed up the regionfile to " + String.valueOf(to.toAbsolutePath()));
        }
        catch (IOException ex) {
            LOGGER.error("Failed to backup to " + String.valueOf(to.toAbsolutePath()), (Throwable)ex);
        }
    }

    private static boolean inSameRegionfile(ChunkPos first, ChunkPos second) {
        return (first.x & 0xFFFFFFE0) == (second.x & 0xFFFFFFE0) && (first.z & 0xFFFFFFE0) == (second.z & 0xFFFFFFE0);
    }

    public int getRecalculateCount() {
        return this.recalculateCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recalculateHeader() throws IOException {
        if (!this.canRecalcHeader) {
            return false;
        }
        ChunkPos ourLowerLeftPosition = RegionFileStorage.getRegionFileCoordinates(this.path);
        if (ourLowerLeftPosition == null) {
            LOGGER.error("Unable to get chunk location of regionfile " + String.valueOf(this.path.toAbsolutePath()) + ", cannot recover header");
            return false;
        }
        RegionFile regionFile = this;
        synchronized (regionFile) {
            int chunkZ;
            int chunkX;
            this.recalculateCount.getAndIncrement();
            LOGGER.warn("Corrupt regionfile header detected! Attempting to re-calculate header offsets for regionfile " + String.valueOf(this.path.toAbsolutePath()), new Throwable());
            this.backupRegionFile();
            CompoundTag[] compounds = new CompoundTag[1024];
            int[] rawLengths = new int[1024];
            int[] sectorOffsets = new int[1024];
            boolean[] hasAikarOversized = new boolean[1024];
            long fileLength = this.file.size();
            long totalSectors = RegionFile.roundToSectors(fileLength);
            long maxSector = Math.min(0x7FFFFFL, totalSectors);
            for (long i = 2L; i < maxSector; ++i) {
                int chunkDataLength = this.getLength(i);
                CompoundTag compound = this.attemptRead(i, chunkDataLength, fileLength);
                if (compound == null || compound == OVERSIZED_COMPOUND) continue;
                ChunkPos chunkPos = SerializableChunkData.getChunkCoordinate(compound);
                if (!RegionFile.inSameRegionfile(ourLowerLeftPosition, chunkPos)) {
                    LOGGER.error("Ignoring absolute chunk " + String.valueOf(chunkPos) + " in regionfile as it is not contained in the bounds of the regionfile '" + String.valueOf(this.path.toAbsolutePath()) + "'. It should be in regionfile (" + (chunkPos.x >> 5) + "," + (chunkPos.z >> 5) + ")");
                    continue;
                }
                int location = chunkPos.x & 0x1F | (chunkPos.z & 0x1F) << 5;
                CompoundTag compoundTag = compounds[location];
                if (compoundTag != null && SerializableChunkData.getLastWorldSaveTime(compoundTag) > SerializableChunkData.getLastWorldSaveTime(compound)) continue;
                Path aikarOversizedFile = this.getOversizedFile(chunkPos.x, chunkPos.z);
                int isAikarOversized = 0;
                if (Files.exists(aikarOversizedFile, new LinkOption[0])) {
                    try {
                        CompoundTag aikarOversizedCompound = this.getOversizedData(chunkPos.x, chunkPos.z);
                        if (SerializableChunkData.getLastWorldSaveTime(compound) == SerializableChunkData.getLastWorldSaveTime(aikarOversizedCompound)) {
                            isAikarOversized = 1;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to read aikar oversized data for absolute chunk (" + chunkPos.x + "," + chunkPos.z + ") in regionfile " + String.valueOf(this.path.toAbsolutePath()) + ", oversized data for this chunk will be lost", (Throwable)ex);
                    }
                }
                hasAikarOversized[location] = isAikarOversized;
                compounds[location] = compound;
                rawLengths[location] = chunkDataLength + 4;
                sectorOffsets[location] = (int)i;
                int chunkSectorLength = (int)RegionFile.roundToSectors(rawLengths[location]);
                i += (long)chunkSectorLength;
                --i;
            }
            Path containingFolder = this.externalFileDir;
            Path[] regionFiles = (Path[])Files.list(containingFolder).toArray(Path[]::new);
            boolean[] oversized = new boolean[1024];
            RegionFileVersion[] oversizedCompressionTypes = new RegionFileVersion[1024];
            if (regionFiles != null) {
                int lowerXBound = ourLowerLeftPosition.x;
                int lowerZBound = ourLowerLeftPosition.z;
                int upperXBound = lowerXBound + 32 - 1;
                int upperZBound = lowerZBound + 32 - 1;
                for (Path regionFile2 : regionFiles) {
                    byte[] chunkData;
                    ChunkPos oversizedCoords = RegionFile.getOversizedChunkPair(regionFile2);
                    if (oversizedCoords == null || oversizedCoords.x < lowerXBound || oversizedCoords.x > upperXBound || oversizedCoords.z < lowerZBound || oversizedCoords.z > upperZBound) continue;
                    int location = oversizedCoords.x & 0x1F | (oversizedCoords.z & 0x1F) << 5;
                    try {
                        chunkData = Files.readAllBytes(regionFile2);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to read oversized chunk data in file " + String.valueOf(regionFile2.toAbsolutePath()) + ", data will be lost", (Throwable)ex);
                        continue;
                    }
                    CompoundTag compound = null;
                    RegionFileVersion compression = null;
                    for (RegionFileVersion compressionType : RegionFileVersion.VERSIONS.values()) {
                        try {
                            DataInputStream in = new DataInputStream(compressionType.wrap(new ByteArrayInputStream(chunkData)));
                            compound = NbtIo.read(in);
                            compression = compressionType;
                            break;
                        }
                        catch (Exception ex) {
                        }
                    }
                    if (compound == null) {
                        LOGGER.error("Failed to read oversized chunk data in file " + String.valueOf(regionFile2.toAbsolutePath()) + ", it's corrupt. Its data will be lost");
                        continue;
                    }
                    if (!SerializableChunkData.getChunkCoordinate(compound).equals(oversizedCoords)) {
                        LOGGER.error("Can't use oversized chunk stored in " + String.valueOf(regionFile2.toAbsolutePath()) + ", got absolute chunkpos: " + String.valueOf(SerializableChunkData.getChunkCoordinate(compound)) + ", expected " + String.valueOf(oversizedCoords));
                        continue;
                    }
                    if (compounds[location] != null && SerializableChunkData.getLastWorldSaveTime(compound) <= SerializableChunkData.getLastWorldSaveTime(compounds[location])) continue;
                    oversized[location] = true;
                    oversizedCompressionTypes[location] = compression;
                }
            }
            int[] calculatedOffsets = new int[1024];
            RegionBitmap newSectorAllocations = new RegionBitmap();
            newSectorAllocations.force(0, 2);
            for (chunkX = 0; chunkX < 32; ++chunkX) {
                for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                    int n = chunkX | chunkZ << 5;
                    if (oversized[n]) continue;
                    int sectorOffset = sectorOffsets[n];
                    int rawLength = rawLengths[n];
                    int sectorLength = (int)RegionFile.roundToSectors(rawLength);
                    if (newSectorAllocations.tryAllocate(sectorOffset, sectorLength)) {
                        calculatedOffsets[n] = sectorOffset << 8 | (sectorLength > 255 ? 255 : sectorLength);
                        continue;
                    }
                    LOGGER.error("Failed to allocate space for local chunk (overlapping data??) at (" + chunkX + "," + chunkZ + ") in regionfile " + String.valueOf(this.path.toAbsolutePath()) + ", chunk will be regenerated");
                }
            }
            for (chunkX = 0; chunkX < 32; ++chunkX) {
                for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                    int n = chunkX | chunkZ << 5;
                    if (!oversized[n]) continue;
                    int sectorOffset = newSectorAllocations.allocate(1);
                    int sectorLength = 1;
                    try {
                        this.file.write(this.createExternalStub(oversizedCompressionTypes[n]), sectorOffset * 4096);
                        calculatedOffsets[n] = sectorOffset << 8 | (sectorLength > 255 ? 255 : sectorLength);
                        continue;
                    }
                    catch (IOException ex) {
                        newSectorAllocations.free(sectorOffset, sectorLength);
                        LOGGER.error("Failed to write new oversized chunk data holder, local chunk at (" + chunkX + "," + chunkZ + ") in regionfile " + String.valueOf(this.path.toAbsolutePath()) + " will be regenerated");
                    }
                }
            }
            this.oversizedCount = 0;
            for (chunkX = 0; chunkX < 32; ++chunkX) {
                for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                    int n = chunkX | chunkZ << 5;
                    int isAikarOversized = hasAikarOversized[n] ? 1 : 0;
                    this.oversizedCount += isAikarOversized;
                    this.oversized[n] = (byte)isAikarOversized;
                }
            }
            if (this.oversizedCount > 0) {
                try {
                    this.writeOversizedMeta();
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to write aikar oversized chunk meta, all aikar style oversized chunk data will be lost for regionfile " + String.valueOf(this.path.toAbsolutePath()), (Throwable)ex);
                    Files.deleteIfExists(this.getOversizedMetaFile());
                }
            } else {
                Files.deleteIfExists(this.getOversizedMetaFile());
            }
            this.usedSectors.copyFrom(newSectorAllocations);
            LOGGER.info("Starting summary of changes for regionfile " + String.valueOf(this.path.toAbsolutePath()));
            for (int chunkX2 = 0; chunkX2 < 32; ++chunkX2) {
                for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                    int newOffset;
                    int n = chunkX2 | chunkZ << 5;
                    int oldOffset = this.offsets.get(n);
                    if (oldOffset == (newOffset = calculatedOffsets[n])) continue;
                    this.offsets.put(n, newOffset);
                    if (oldOffset == 0) {
                        LOGGER.info("Found missing data for local chunk (" + chunkX2 + "," + chunkZ + ") in regionfile " + String.valueOf(this.path.toAbsolutePath()));
                        continue;
                    }
                    if (newOffset == 0) {
                        LOGGER.warn("Data for local chunk (" + chunkX2 + "," + chunkZ + ") could not be recovered in regionfile " + String.valueOf(this.path.toAbsolutePath()) + ", it will be regenerated");
                        continue;
                    }
                    LOGGER.info("Local chunk (" + chunkX2 + "," + chunkZ + ") changed to point to newer data or correct chunk in regionfile " + String.valueOf(this.path.toAbsolutePath()));
                }
            }
            LOGGER.info("End of change summary for regionfile " + String.valueOf(this.path.toAbsolutePath()));
            for (int i = 0; i < 1024; ++i) {
                this.timestamps.put(i, calculatedOffsets[i] != 0 ? RegionFile.getTimestamp() : 0);
            }
            try {
                this.flush();
                this.file.force(true);
                LOGGER.info("Successfully wrote new header to disk for regionfile " + String.valueOf(this.path.toAbsolutePath()));
            }
            catch (IOException ex) {
                LOGGER.error("Failed to write new header to disk for regionfile " + String.valueOf(this.path.toAbsolutePath()), (Throwable)ex);
            }
        }
        return true;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController.WriteData moonrise$startWrite(CompoundTag data, ChunkPos pos) throws IOException {
        RegionFile regionFile = this;
        Objects.requireNonNull(regionFile);
        ChunkBuffer buffer = regionFile.new ChunkBuffer(pos);
        buffer.moonrise$setWriteOnClose(false);
        DataOutputStream out = new DataOutputStream(this.version.wrap(buffer));
        return new MoonriseRegionFileIO.RegionDataController.WriteData(data, MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.WRITE, out, buffer::moonrise$write);
    }

    public RegionFile(RegionStorageInfo info, Path path, Path externalFileDir, boolean sync) throws IOException {
        this(info, path, externalFileDir, RegionFileVersion.getCompressionFormat(), sync);
    }

    public RegionFile(RegionStorageInfo info, Path path, Path externalFileDir, RegionFileVersion version, boolean sync) throws IOException {
        this.info = info;
        this.path = path;
        this.version = version;
        this.initOversizedState();
        if (!Files.isDirectory(externalFileDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory, got " + String.valueOf(externalFileDir.toAbsolutePath()));
        }
        this.externalFileDir = externalFileDir;
        this.canRecalcHeader = RegionFileStorage.isChunkDataFolder(this.externalFileDir);
        this.offsets = this.header.asIntBuffer();
        this.offsets.limit(1024);
        this.header.position(4096);
        this.timestamps = this.header.asIntBuffer();
        this.file = sync ? FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC) : FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.usedSectors.force(0, 2);
        this.header.position(0);
        int i = this.file.read(this.header, 0L);
        if (i != -1) {
            if (i != 8192) {
                LOGGER.warn("Region file {} has truncated header: {}", (Object)path, (Object)i);
            }
            long size = Files.size(path);
            boolean needsHeaderRecalc = false;
            boolean hasBackedUp = false;
            for (int i1 = 0; i1 < 1024; ++i1) {
                boolean failedToAllocate;
                int headerLocation = i1;
                int i2 = this.offsets.get(i1);
                if (i2 == 0) continue;
                int sectorNumber = RegionFile.getSectorNumber(i2);
                int numSectors = RegionFile.getNumSectors(i2);
                if (numSectors == 255) {
                    ByteBuffer realLen = ByteBuffer.allocate(4);
                    this.file.read(realLen, sectorNumber * 4096);
                    numSectors = (realLen.getInt(0) + 4) / 4096 + 1;
                }
                if (sectorNumber < 2) {
                    LOGGER.warn("Region file {} has invalid sector at index: {}; sector {} overlaps with header", new Object[]{path, i1, sectorNumber});
                } else if (numSectors == 0) {
                    LOGGER.warn("Region file {} has an invalid sector at index: {}; size has to be > 0", (Object)path, (Object)i1);
                } else if ((long)sectorNumber * 4096L > size) {
                    LOGGER.warn("Region file {} has an invalid sector at index: {}; sector {} is out of bounds", new Object[]{path, i1, sectorNumber});
                }
                if (sectorNumber < 2 || numSectors <= 0 || (long)sectorNumber * 4096L > size) {
                    if (this.canRecalcHeader) {
                        LOGGER.error("Detected invalid header for regionfile " + String.valueOf(this.path.toAbsolutePath()) + "! Recalculating header...");
                        needsHeaderRecalc = true;
                        break;
                    }
                    LOGGER.error("Detected invalid header for regionfile " + String.valueOf(this.path.toAbsolutePath()) + "! Cannot recalculate, removing local chunk (" + (headerLocation & 0x1F) + "," + (headerLocation >>> 5) + ") from header");
                    if (!hasBackedUp) {
                        hasBackedUp = true;
                        this.backupRegionFile();
                    }
                    this.timestamps.put(headerLocation, 0);
                    this.offsets.put(headerLocation, 0);
                    continue;
                }
                boolean bl = failedToAllocate = !this.usedSectors.tryAllocate(sectorNumber, numSectors);
                if (failedToAllocate) {
                    LOGGER.error("Overlapping allocation by local chunk (" + (headerLocation & 0x1F) + "," + (headerLocation >>> 5) + ") in regionfile " + String.valueOf(this.path.toAbsolutePath()));
                }
                if (failedToAllocate & !this.canRecalcHeader) {
                    LOGGER.error("Detected invalid header for regionfile " + String.valueOf(this.path.toAbsolutePath()) + "! Cannot recalculate, removing local chunk (" + (headerLocation & 0x1F) + "," + (headerLocation >>> 5) + ") from header");
                    if (!hasBackedUp) {
                        hasBackedUp = true;
                        this.backupRegionFile();
                    }
                    this.timestamps.put(headerLocation, 0);
                    this.offsets.put(headerLocation, 0);
                    continue;
                }
                needsHeaderRecalc |= failedToAllocate;
            }
            if (needsHeaderRecalc) {
                LOGGER.error("Recalculating regionfile " + String.valueOf(this.path.toAbsolutePath()) + ", header gave erroneous offsets & locations");
                this.recalculateHeader();
            }
        }
    }

    public Path getPath() {
        return this.path;
    }

    private Path getExternalChunkPath(ChunkPos chunkPos) {
        String string = "c." + chunkPos.x + "." + chunkPos.z + EXTERNAL_FILE_EXTENSION;
        return this.externalFileDir.resolve(string);
    }

    @Nullable
    private static ChunkPos getOversizedChunkPair(Path file) {
        String fileName = file.getFileName().toString();
        if (!fileName.startsWith("c.") || !fileName.endsWith(EXTERNAL_FILE_EXTENSION)) {
            return null;
        }
        String[] split = fileName.split("\\.");
        if (split.length != 4) {
            return null;
        }
        try {
            int x = Integer.parseInt(split[1]);
            int z = Integer.parseInt(split[2]);
            return new ChunkPos(x, z);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Nullable
    public synchronized DataInputStream getChunkDataInputStream(ChunkPos chunkPos) throws IOException {
        int offset = this.getOffset(chunkPos);
        if (offset == 0) {
            return null;
        }
        int sectorNumber = RegionFile.getSectorNumber(offset);
        int numSectors = RegionFile.getNumSectors(offset);
        if (numSectors == 255) {
            ByteBuffer realLen = ByteBuffer.allocate(4);
            this.file.read(realLen, sectorNumber * 4096);
            numSectors = (realLen.getInt(0) + 4) / 4096 + 1;
        }
        int i = numSectors * 4096;
        ByteBuffer byteBuffer = ByteBuffer.allocate(i);
        this.file.read(byteBuffer, sectorNumber * 4096);
        byteBuffer.flip();
        if (byteBuffer.remaining() < 5) {
            LOGGER.error("Chunk {} header is truncated: expected {} but read {}", new Object[]{chunkPos, i, byteBuffer.remaining()});
            if (this.canRecalcHeader && this.recalculateHeader()) {
                return this.getChunkDataInputStream(chunkPos);
            }
            return null;
        }
        int _int = byteBuffer.getInt();
        byte b = byteBuffer.get();
        if (_int == 0) {
            LOGGER.warn("Chunk {} is allocated, but stream is missing", (Object)chunkPos);
            if (this.canRecalcHeader && this.recalculateHeader()) {
                return this.getChunkDataInputStream(chunkPos);
            }
            return null;
        }
        int i1 = _int - 1;
        if (RegionFile.isExternalStreamChunk(b)) {
            DataInputStream ret;
            if (i1 != 0) {
                LOGGER.warn("Chunk has both internal and external streams");
                if (this.canRecalcHeader && this.recalculateHeader()) {
                    return this.getChunkDataInputStream(chunkPos);
                }
            }
            if ((ret = this.createExternalChunkInputStream(chunkPos, RegionFile.getExternalChunkVersion(b))) == null && this.canRecalcHeader && this.recalculateHeader()) {
                return this.getChunkDataInputStream(chunkPos);
            }
            return ret;
        }
        if (i1 > byteBuffer.remaining()) {
            LOGGER.error("Chunk {} stream is truncated: expected {} but read {}", new Object[]{chunkPos, i1, byteBuffer.remaining()});
            if (this.canRecalcHeader && this.recalculateHeader()) {
                return this.getChunkDataInputStream(chunkPos);
            }
            return null;
        }
        if (i1 < 0) {
            LOGGER.error("Declared size {} of chunk {} is negative", (Object)_int, (Object)chunkPos);
            if (this.canRecalcHeader && this.recalculateHeader()) {
                return this.getChunkDataInputStream(chunkPos);
            }
            return null;
        }
        JvmProfiler.INSTANCE.onRegionFileRead(this.info, chunkPos, this.version, i1);
        DataInputStream ret = this.createChunkInputStream(chunkPos, b, RegionFile.createStream(byteBuffer, i1));
        if (ret == null && this.canRecalcHeader && this.recalculateHeader()) {
            return this.getChunkDataInputStream(chunkPos);
        }
        return ret;
    }

    private static int getTimestamp() {
        return (int)(Util.getEpochMillis() / 1000L);
    }

    private static boolean isExternalStreamChunk(byte versionByte) {
        return (versionByte & 0x80) != 0;
    }

    private static byte getExternalChunkVersion(byte versionByte) {
        return (byte)(versionByte & 0xFFFFFF7F);
    }

    @Nullable
    private DataInputStream createChunkInputStream(ChunkPos chunkPos, byte versionByte, InputStream inputStream) throws IOException {
        RegionFileVersion regionFileVersion = RegionFileVersion.fromId(versionByte);
        if (regionFileVersion == RegionFileVersion.VERSION_CUSTOM) {
            String utf = new DataInputStream(inputStream).readUTF();
            ResourceLocation resourceLocation = ResourceLocation.tryParse(utf);
            if (resourceLocation != null) {
                LOGGER.error("Unrecognized custom compression {}", (Object)resourceLocation);
                return null;
            }
            LOGGER.error("Invalid custom compression id {}", (Object)utf);
            return null;
        }
        if (regionFileVersion == null) {
            LOGGER.error("Chunk {} has invalid chunk stream version {}", (Object)chunkPos, (Object)versionByte);
            return null;
        }
        return new DataInputStream(regionFileVersion.wrap(inputStream));
    }

    @Nullable
    private DataInputStream createExternalChunkInputStream(ChunkPos chunkPos, byte versionByte) throws IOException {
        DataInputStream is = this.createExternalChunkInputStream0(chunkPos, versionByte);
        if (is == null) {
            return is;
        }
        return new ExternalChunkStreamMarker(is);
    }

    @Nullable
    private DataInputStream createExternalChunkInputStream0(ChunkPos chunkPos, byte versionByte) throws IOException {
        Path externalChunkPath = this.getExternalChunkPath(chunkPos);
        if (!Files.isRegularFile(externalChunkPath, new LinkOption[0])) {
            LOGGER.error("External chunk path {} is not file", (Object)externalChunkPath);
            return null;
        }
        return this.createChunkInputStream(chunkPos, versionByte, Files.newInputStream(externalChunkPath, new OpenOption[0]));
    }

    private static ByteArrayInputStream createStream(ByteBuffer sourceBuffer, int length) {
        return new ByteArrayInputStream(sourceBuffer.array(), sourceBuffer.position(), length);
    }

    private int packSectorOffset(int sectorOffset, int sectorCount) {
        return sectorOffset << 8 | sectorCount;
    }

    private static int getNumSectors(int packedSectorOffset) {
        return packedSectorOffset & 0xFF;
    }

    private static int getSectorNumber(int packedSectorOffset) {
        return packedSectorOffset >> 8 & 0xFFFFFF;
    }

    private static int sizeToSectors(int size) {
        return (size + 4096 - 1) / 4096;
    }

    public boolean doesChunkExist(ChunkPos chunkPos) {
        int offset = this.getOffset(chunkPos);
        if (offset == 0) {
            return false;
        }
        int sectorNumber = RegionFile.getSectorNumber(offset);
        int numSectors = RegionFile.getNumSectors(offset);
        ByteBuffer byteBuffer = ByteBuffer.allocate(5);
        try {
            this.file.read(byteBuffer, sectorNumber * 4096);
            byteBuffer.flip();
            if (byteBuffer.remaining() != 5) {
                return false;
            }
            int _int = byteBuffer.getInt();
            byte b = byteBuffer.get();
            if (RegionFile.isExternalStreamChunk(b)) {
                if (!RegionFileVersion.isValidVersion(RegionFile.getExternalChunkVersion(b))) {
                    return false;
                }
                if (!Files.isRegularFile(this.getExternalChunkPath(chunkPos), new LinkOption[0])) {
                    return false;
                }
            } else {
                if (!RegionFileVersion.isValidVersion(b)) {
                    return false;
                }
                if (_int == 0) {
                    return false;
                }
                int i = _int - 1;
                if (i < 0 || i > 4096 * numSectors) {
                    return false;
                }
            }
            return true;
        }
        catch (IOException var9) {
            ServerInternalException.reportInternalException((Throwable)var9);
            return false;
        }
    }

    public DataOutputStream getChunkDataOutputStream(ChunkPos chunkPos) throws IOException {
        return new DataOutputStream(this.version.wrap(new ChunkBuffer(chunkPos)));
    }

    public void flush() throws IOException {
        this.file.force(true);
    }

    public void clear(ChunkPos chunkPos) throws IOException {
        int offsetIndex = RegionFile.getOffsetIndex(chunkPos);
        int i = this.offsets.get(offsetIndex);
        if (i != 0) {
            this.offsets.put(offsetIndex, 0);
            this.timestamps.put(offsetIndex, RegionFile.getTimestamp());
            this.writeHeader();
            Files.deleteIfExists(this.getExternalChunkPath(chunkPos));
            this.usedSectors.free(RegionFile.getSectorNumber(i), RegionFile.getNumSectors(i));
        }
    }

    protected synchronized void write(ChunkPos chunkPos, ByteBuffer chunkData) throws IOException {
        CommitOp commitOp;
        int i3;
        int offsetIndex = RegionFile.getOffsetIndex(chunkPos);
        int i = this.offsets.get(offsetIndex);
        int sectorNumber = RegionFile.getSectorNumber(i);
        int numSectors = RegionFile.getNumSectors(i);
        int i1 = chunkData.remaining();
        int i2 = RegionFile.sizeToSectors(i1);
        if (i2 >= 256) {
            Path externalChunkPath = this.getExternalChunkPath(chunkPos);
            LOGGER.warn("Saving oversized chunk {} ({} bytes} to external file {}", new Object[]{chunkPos, i1, externalChunkPath});
            i2 = 1;
            i3 = this.usedSectors.allocate(i2);
            commitOp = this.writeToExternalFile(externalChunkPath, chunkData);
            ByteBuffer byteBuffer = this.createExternalStub();
            this.file.write(byteBuffer, i3 * 4096);
        } else {
            i3 = this.usedSectors.allocate(i2);
            commitOp = () -> Files.deleteIfExists(this.getExternalChunkPath(chunkPos));
            this.file.write(chunkData, i3 * 4096);
        }
        this.offsets.put(offsetIndex, this.packSectorOffset(i3, i2));
        this.timestamps.put(offsetIndex, RegionFile.getTimestamp());
        this.writeHeader();
        commitOp.run();
        if (sectorNumber != 0) {
            this.usedSectors.free(sectorNumber, numSectors);
        }
    }

    private ByteBuffer createExternalStub() {
        return this.createExternalStub(this.version);
    }

    private ByteBuffer createExternalStub(RegionFileVersion version) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(5);
        byteBuffer.putInt(1);
        byteBuffer.put((byte)(version.getId() | 0x80));
        byteBuffer.flip();
        return byteBuffer;
    }

    private CommitOp writeToExternalFile(Path externalChunkFile, ByteBuffer chunkData) throws IOException {
        Path path = Files.createTempFile(this.externalFileDir, "tmp", null, new FileAttribute[0]);
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            chunkData.position(5);
            fileChannel.write(chunkData);
        }
        catch (Throwable throwable) {
            ServerInternalException.reportInternalException((Throwable)throwable);
            throw throwable;
        }
        return () -> Files.move(path, externalChunkFile, StandardCopyOption.REPLACE_EXISTING);
    }

    private void writeHeader() throws IOException {
        this.header.position(0);
        this.file.write(this.header, 0L);
    }

    private int getOffset(ChunkPos chunkPos) {
        return this.offsets.get(RegionFile.getOffsetIndex(chunkPos));
    }

    public boolean hasChunk(ChunkPos chunkPos) {
        return this.getOffset(chunkPos) != 0;
    }

    private static int getOffsetIndex(ChunkPos chunkPos) {
        return chunkPos.getRegionLocalX() + chunkPos.getRegionLocalZ() * 32;
    }

    @Override
    public void close() throws IOException {
        try {
            this.padToFullSector();
        }
        finally {
            try {
                this.file.force(true);
            }
            finally {
                this.file.close();
            }
        }
    }

    private void padToFullSector() throws IOException {
        int i1;
        int i = (int)this.file.size();
        if (i != (i1 = RegionFile.sizeToSectors(i) * 4096)) {
            ByteBuffer byteBuffer = PADDING_BUFFER.duplicate();
            byteBuffer.position(0);
            this.file.write(byteBuffer, i1 - 1);
        }
    }

    private synchronized void initOversizedState() throws IOException {
        Path metaFile = this.getOversizedMetaFile();
        if (Files.exists(metaFile, new LinkOption[0])) {
            byte[] read = Files.readAllBytes(metaFile);
            System.arraycopy(read, 0, this.oversized, 0, this.oversized.length);
            for (byte temp : this.oversized) {
                this.oversizedCount += temp;
            }
        }
    }

    private static int getChunkIndex(int x, int z) {
        return (x & 0x1F) + (z & 0x1F) * 32;
    }

    synchronized boolean isOversized(int x, int z) {
        return this.oversized[RegionFile.getChunkIndex(x, z)] == 1;
    }

    synchronized void setOversized(int x, int z, boolean oversized) throws IOException {
        Path oversizedMetaFile;
        Path oversizedFile;
        int offset = RegionFile.getChunkIndex(x, z);
        boolean previous = this.oversized[offset] == 1;
        this.oversized[offset] = (byte)(oversized ? 1 : 0);
        if (!previous && oversized) {
            ++this.oversizedCount;
        } else if (!oversized && previous) {
            --this.oversizedCount;
        }
        if (previous && !oversized && Files.exists(oversizedFile = this.getOversizedFile(x, z), new LinkOption[0])) {
            Files.delete(oversizedFile);
        }
        if (this.oversizedCount > 0) {
            if (previous != oversized) {
                this.writeOversizedMeta();
            }
        } else if (previous && Files.exists(oversizedMetaFile = this.getOversizedMetaFile(), new LinkOption[0])) {
            Files.delete(oversizedMetaFile);
        }
    }

    private void writeOversizedMeta() throws IOException {
        Files.write(this.getOversizedMetaFile(), this.oversized, new OpenOption[0]);
    }

    private Path getOversizedMetaFile() {
        return this.path.getParent().resolve(this.path.getFileName().toString().replaceAll("\\.mca$", "") + ".oversized.nbt");
    }

    private Path getOversizedFile(int x, int z) {
        return this.path.getParent().resolve(this.path.getFileName().toString().replaceAll("\\.mca$", "") + "_oversized_" + x + "_" + z + ".nbt");
    }

    synchronized CompoundTag getOversizedData(int x, int z) throws IOException {
        Path file = this.getOversizedFile(x, z);
        try (DataInputStream out = new DataInputStream(new BufferedInputStream(new InflaterInputStream(Files.newInputStream(file, new OpenOption[0]))));){
            CompoundTag compoundTag = NbtIo.read(out);
            return compoundTag;
        }
    }

    class ChunkBuffer
    extends ByteArrayOutputStream
    implements ChunkSystemChunkBuffer {
        private final ChunkPos pos;
        private boolean writeOnClose;

        @Override
        public final boolean moonrise$getWriteOnClose() {
            return this.writeOnClose;
        }

        @Override
        public final void moonrise$setWriteOnClose(boolean value) {
            this.writeOnClose = value;
        }

        @Override
        public final void moonrise$write(RegionFile regionFile) throws IOException {
            regionFile.write(this.pos, ByteBuffer.wrap(this.buf, 0, this.count));
        }

        public ChunkBuffer(ChunkPos pos) {
            super(8096);
            this.writeOnClose = true;
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(RegionFile.this.version.getId());
            this.pos = pos;
        }

        @Override
        public void write(int b) {
            if (this.count > 524288000) {
                throw new RegionFileStorage.RegionFileSizeException("Region file too large: " + this.count);
            }
            super.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (this.count + len > 524288000) {
                throw new RegionFileStorage.RegionFileSizeException("Region file too large: " + (this.count + len));
            }
            super.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, this.count);
            int i = this.count - 5 + 1;
            JvmProfiler.INSTANCE.onRegionFileWrite(RegionFile.this.info, this.pos, RegionFile.this.version, i);
            byteBuffer.putInt(0, i);
            if (this.writeOnClose) {
                RegionFile.this.write(this.pos, byteBuffer);
            }
        }
    }

    static interface CommitOp {
        public void run() throws IOException;
    }
}

