/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.patches.chunk_system.io.ChunkSystemRegionFileStorage;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.util.stream.ExternalChunkStreamMarker;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExceptionCollector;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public class RegionFileStorage
implements AutoCloseable,
ChunkSystemRegionFileStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String ANVIL_EXTENSION = ".mca";
    private static final int MAX_CACHE_SIZE = 256;
    public final Long2ObjectLinkedOpenHashMap<RegionFile> regionCache = new Long2ObjectLinkedOpenHashMap();
    private final RegionStorageInfo info;
    private final Path folder;
    private final boolean sync;
    private final boolean isChunkData;
    private static final int REGION_SHIFT = 5;
    private static final int MAX_NON_EXISTING_CACHE = 4096;
    private final LongLinkedOpenHashSet nonExistingRegionFiles = new LongLinkedOpenHashSet();

    public static boolean isChunkDataFolder(Path path) {
        return path.toFile().getName().equalsIgnoreCase("region");
    }

    @Nullable
    public static ChunkPos getRegionFileCoordinates(Path file) {
        String fileName = file.getFileName().toString();
        if (!fileName.startsWith("r.") || !fileName.endsWith(ANVIL_EXTENSION)) {
            return null;
        }
        String[] split = fileName.split("\\.");
        if (split.length != 4) {
            return null;
        }
        try {
            int x = Integer.parseInt(split[1]);
            int z = Integer.parseInt(split[2]);
            return new ChunkPos(x << 5, z << 5);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static String getRegionFileName(int chunkX, int chunkZ) {
        return "r." + (chunkX >> 5) + "." + (chunkZ >> 5) + ANVIL_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesRegionFilePossiblyExist(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            if (this.nonExistingRegionFiles.contains(position)) {
                this.nonExistingRegionFiles.addAndMoveToFirst(position);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRegionFile(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            this.nonExistingRegionFiles.remove(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markNonExisting(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            if (this.nonExistingRegionFiles.addAndMoveToFirst(position)) {
                while (this.nonExistingRegionFiles.size() >= 4096) {
                    this.nonExistingRegionFiles.removeLastLong();
                }
            }
        }
    }

    @Override
    public final boolean moonrise$doesRegionFileNotExistNoIO(int chunkX, int chunkZ) {
        return !this.doesRegionFilePossiblyExist(ChunkPos.asLong(chunkX >> 5, chunkZ >> 5));
    }

    @Override
    public final synchronized RegionFile moonrise$getRegionFileIfLoaded(int chunkX, int chunkZ) {
        return (RegionFile)this.regionCache.getAndMoveToFirst(ChunkPos.asLong(chunkX >> 5, chunkZ >> 5));
    }

    @Override
    public final synchronized RegionFile moonrise$getRegionFileIfExists(int chunkX, int chunkZ) throws IOException {
        Path regionPath;
        long key = ChunkPos.asLong(chunkX >> 5, chunkZ >> 5);
        RegionFile ret = (RegionFile)this.regionCache.getAndMoveToFirst(key);
        if (ret != null) {
            return ret;
        }
        if (!this.doesRegionFilePossiblyExist(key)) {
            return null;
        }
        if (this.regionCache.size() >= GlobalConfiguration.get().misc.regionFileCacheSize) {
            ((RegionFile)this.regionCache.removeLast()).close();
        }
        if (!Files.exists(regionPath = this.folder.resolve(RegionFileStorage.getRegionFileName(chunkX, chunkZ)), new LinkOption[0])) {
            this.markNonExisting(key);
            return null;
        }
        this.createRegionFile(key);
        FileUtil.createDirectoriesSafe(this.folder);
        ret = new RegionFile(this.info, regionPath, this.folder, this.sync);
        this.regionCache.putAndMoveToFirst(key, (Object)ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final MoonriseRegionFileIO.RegionDataController.WriteData moonrise$startWrite(int chunkX, int chunkZ, CompoundTag compound) throws IOException {
        if (compound == null) {
            return new MoonriseRegionFileIO.RegionDataController.WriteData(compound, MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.DELETE, null, null);
        }
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        RegionFile regionFile = this.getRegionFile(pos);
        MoonriseRegionFileIO.RegionDataController.WriteData writeData = regionFile.moonrise$startWrite(compound, pos);
        try {
            try {
                NbtIo.write(compound, writeData.output());
            }
            finally {
                writeData.output().close();
            }
        }
        catch (RegionFileSizeException ex) {
            int maxSize = 500;
            LOGGER.error("Chunk at (" + chunkX + "," + chunkZ + ") in regionfile '" + regionFile.getPath().toString() + "' exceeds max size of 500MiB, it has been deleted from disk.");
            return new MoonriseRegionFileIO.RegionDataController.WriteData(compound, MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.DELETE, null, null);
        }
        return writeData;
    }

    @Override
    public final void moonrise$finishWrite(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.WriteData writeData) throws IOException {
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        if (writeData.result() == MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.DELETE) {
            RegionFile regionFile = this.moonrise$getRegionFileIfExists(chunkX, chunkZ);
            if (regionFile != null) {
                regionFile.clear(pos);
            }
            return;
        }
        writeData.write().run(this.getRegionFile(pos));
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController.ReadData moonrise$readData(int chunkX, int chunkZ) throws IOException {
        DataInputStream input;
        RegionFile regionFile = this.moonrise$getRegionFileIfExists(chunkX, chunkZ);
        DataInputStream dataInputStream = input = regionFile == null ? null : regionFile.getChunkDataInputStream(new ChunkPos(chunkX, chunkZ));
        if (input == null) {
            return new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.NO_DATA, null, null, regionFile == null ? 0 : regionFile.getRecalculateCount());
        }
        MoonriseRegionFileIO.RegionDataController.ReadData ret = new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.HAS_DATA, input, null, regionFile.getRecalculateCount());
        if (!(input instanceof ExternalChunkStreamMarker)) {
            return ret;
        }
        CompoundTag syncRead = this.moonrise$finishRead(chunkX, chunkZ, ret);
        if (syncRead == null) {
            return this.moonrise$readData(chunkX, chunkZ);
        }
        return new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.SYNC_READ, null, syncRead, regionFile.getRecalculateCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CompoundTag moonrise$finishRead(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.ReadData readData) throws IOException {
        try {
            CompoundTag ret = NbtIo.read(readData.input());
            if (!this.isChunkData) {
                CompoundTag compoundTag = ret;
                return compoundTag;
            }
            ChunkPos pos = new ChunkPos(chunkX, chunkZ);
            ChunkPos headerChunkPos = SerializableChunkData.getChunkCoordinate(ret);
            RegionFile regionFile = this.getRegionFile(pos);
            if (regionFile.getRecalculateCount() != readData.recalculateCount()) {
                CompoundTag compoundTag = null;
                return compoundTag;
            }
            if (!headerChunkPos.equals(pos)) {
                LOGGER.error("Attempting to read chunk data at " + String.valueOf(pos) + " but got chunk data for " + String.valueOf(headerChunkPos) + " instead! Attempting regionfile recalculation " + String.valueOf(regionFile.getPath().toAbsolutePath()));
                if (regionFile.recalculateHeader()) {
                    CompoundTag compoundTag = null;
                    return compoundTag;
                }
                LOGGER.error(LogUtils.FATAL_MARKER, "Can't recalculate regionfile header?");
                CompoundTag compoundTag = ret;
                return compoundTag;
            }
            CompoundTag compoundTag = ret;
            return compoundTag;
        }
        finally {
            readData.input().close();
        }
    }

    public RegionFile getRegionFile(ChunkPos chunkcoordintpair) throws IOException {
        return this.getRegionFile(chunkcoordintpair, false);
    }

    protected RegionFileStorage(RegionStorageInfo info, Path folder, boolean sync) {
        this.folder = folder;
        this.sync = sync;
        this.info = info;
        this.isChunkData = RegionFileStorage.isChunkDataFolder(this.folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @Contract(value="_, false -> !null")
    private RegionFile getRegionFile(ChunkPos chunkPos, boolean existingOnly) throws IOException {
        if (existingOnly) {
            return this.moonrise$getRegionFileIfExists(chunkPos.x, chunkPos.z);
        }
        RegionFileStorage regionFileStorage = this;
        synchronized (regionFileStorage) {
            long key = ChunkPos.asLong(chunkPos.x >> 5, chunkPos.z >> 5);
            RegionFile ret = (RegionFile)this.regionCache.getAndMoveToFirst(key);
            if (ret != null) {
                return ret;
            }
            if (this.regionCache.size() >= GlobalConfiguration.get().misc.regionFileCacheSize) {
                ((RegionFile)this.regionCache.removeLast()).close();
            }
            Path regionPath = this.folder.resolve(RegionFileStorage.getRegionFileName(chunkPos.x, chunkPos.z));
            this.createRegionFile(key);
            FileUtil.createDirectoriesSafe(this.folder);
            ret = new RegionFile(this.info, regionPath, this.folder, this.sync);
            this.regionCache.putAndMoveToFirst(key, (Object)ret);
            return ret;
        }
    }

    private static void printOversizedLog(String msg, Path file, int x, int z) {
        LogManager.getLogger().fatal(msg + " (" + file.toString().replaceAll(".+[\\\\/]", "") + " - " + x + "," + z + ") Go clean it up to remove this message. /minecraft:tp " + (x << 4) + " 128 " + (z << 4) + " - DO NOT REPORT THIS TO PAPER - You may ask for help on Discord, but do not file an issue. These error messages can not be removed.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CompoundTag readOversizedChunk(RegionFile regionfile, ChunkPos chunkCoordinate) throws IOException {
        RegionFile regionFile = regionfile;
        synchronized (regionFile) {
            try (DataInputStream datainputstream = regionfile.getChunkDataInputStream(chunkCoordinate);){
                CompoundTag oversizedData = regionfile.getOversizedData(chunkCoordinate.x, chunkCoordinate.z);
                CompoundTag chunk = NbtIo.read(datainputstream);
                if (oversizedData == null) {
                    CompoundTag compoundTag2 = chunk;
                    return compoundTag2;
                }
                CompoundTag oversizedLevel = oversizedData.getCompoundOrEmpty("Level");
                RegionFileStorage.mergeChunkList(chunk.getCompoundOrEmpty("Level"), oversizedLevel, "Entities", "Entities");
                RegionFileStorage.mergeChunkList(chunk.getCompoundOrEmpty("Level"), oversizedLevel, "TileEntities", "TileEntities");
                CompoundTag compoundTag = chunk;
                return compoundTag;
            }
            catch (Throwable throwable3) {
                throwable3.printStackTrace();
                throw throwable3;
            }
        }
    }

    private static void mergeChunkList(CompoundTag level, CompoundTag oversizedLevel, String key, String oversizedKey) {
        ListTag levelList = level.getListOrEmpty(key);
        ListTag oversizedList = oversizedLevel.getListOrEmpty(oversizedKey);
        if (!oversizedList.isEmpty()) {
            levelList.addAll(oversizedList);
            level.put(key, levelList);
        }
    }

    @Nullable
    public CompoundTag read(ChunkPos chunkPos) throws IOException {
        CompoundTag var4;
        RegionFile regionFile = this.getRegionFile(chunkPos, true);
        if (regionFile == null) {
            return null;
        }
        if (regionFile.isOversized(chunkPos.x, chunkPos.z)) {
            RegionFileStorage.printOversizedLog("Loading Oversized Chunk!", regionFile.getPath(), chunkPos.x, chunkPos.z);
            return RegionFileStorage.readOversizedChunk(regionFile, chunkPos);
        }
        try (DataInputStream chunkDataInputStream = regionFile.getChunkDataInputStream(chunkPos);){
            ChunkPos headerChunkPos;
            if (chunkDataInputStream == null) {
                CompoundTag compoundTag = null;
                return compoundTag;
            }
            var4 = NbtIo.read(chunkDataInputStream);
            if (this.isChunkData && !(headerChunkPos = SerializableChunkData.getChunkCoordinate(var4)).equals(chunkPos)) {
                MinecraftServer.LOGGER.error("Attempting to read chunk data at " + String.valueOf(chunkPos) + " but got chunk data for " + String.valueOf(headerChunkPos) + " instead! Attempting regionfile recalculation for regionfile " + String.valueOf(regionFile.getPath().toAbsolutePath()));
                if (regionFile.recalculateHeader()) {
                    CompoundTag compoundTag = this.read(chunkPos);
                    return compoundTag;
                }
                MinecraftServer.LOGGER.error("Can't recalculate regionfile header, regenerating chunk " + String.valueOf(chunkPos) + " for " + String.valueOf(regionFile.getPath().toAbsolutePath()));
                CompoundTag compoundTag = null;
                return compoundTag;
            }
        }
        return var4;
    }

    public void scanChunk(ChunkPos chunkPos, StreamTagVisitor visitor) throws IOException {
        RegionFile regionFile = this.getRegionFile(chunkPos, true);
        if (regionFile == null) {
            return;
        }
        try (DataInputStream chunkDataInputStream = regionFile.getChunkDataInputStream(chunkPos);){
            if (chunkDataInputStream != null) {
                NbtIo.parse(chunkDataInputStream, visitor, NbtAccounter.unlimitedHeap());
            }
        }
    }

    public void write(ChunkPos chunkPos, @Nullable CompoundTag chunkData) throws IOException {
        RegionFile regionFile = this.getRegionFile(chunkPos, chunkData == null);
        if (regionFile == null) {
            return;
        }
        if (chunkData == null) {
            regionFile.clear(chunkPos);
        } else {
            DataOutputStream chunkDataOutputStream = regionFile.getChunkDataOutputStream(chunkPos);
            try {
                NbtIo.write(chunkData, chunkDataOutputStream);
                regionFile.setOversized(chunkPos.x, chunkPos.z, false);
                chunkDataOutputStream.close();
            }
            catch (RegionFileSizeException ex) {
                regionFile.clear(chunkPos);
                int maxSize = 500;
                LOGGER.error("Chunk at (" + chunkPos.x + "," + chunkPos.z + ") in regionfile '" + regionFile.getPath().toString() + "' exceeds max size of 500MiB, it has been deleted from disk.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        RegionFileStorage regionFileStorage = this;
        synchronized (regionFileStorage) {
            ExceptionCollector<IOException> exceptionCollector = new ExceptionCollector<IOException>();
            for (RegionFile regionFile : this.regionCache.values()) {
                try {
                    regionFile.close();
                }
                catch (IOException ex) {
                    exceptionCollector.add(ex);
                }
            }
            exceptionCollector.throwIfPresent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        RegionFileStorage regionFileStorage = this;
        synchronized (regionFileStorage) {
            ExceptionCollector<IOException> exceptionCollector = new ExceptionCollector<IOException>();
            for (RegionFile regionFile : this.regionCache.values()) {
                try {
                    regionFile.flush();
                }
                catch (IOException ex) {
                    exceptionCollector.add(ex);
                }
            }
            exceptionCollector.throwIfPresent();
        }
    }

    public RegionStorageInfo info() {
        return this.info;
    }

    public static final class RegionFileSizeException
    extends RuntimeException {
        public RegionFileSizeException(String message) {
            super(message);
        }
    }
}

