/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.level.entity.Visibility;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class PersistentEntitySectionManager<T extends EntityAccess>
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    final Set<UUID> knownUuids = Sets.newHashSet();
    final LevelCallback<T> callbacks;
    public final EntityPersistentStorage<T> permanentStorage;
    private final EntityLookup<T> visibleEntityStorage;
    final EntitySectionStorage<T> sectionStorage;
    private final LevelEntityGetter<T> entityGetter;
    private final Long2ObjectMap<Visibility> chunkVisibility = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<ChunkLoadStatus> chunkLoadStatuses = new Long2ObjectOpenHashMap();
    private final LongSet chunksToUnload = new LongOpenHashSet();
    private final Queue<ChunkEntities<T>> loadingInbox = Queues.newConcurrentLinkedQueue();

    public PersistentEntitySectionManager(Class<T> entityClass, LevelCallback<T> callbacks, EntityPersistentStorage<T> permanentStorage) {
        this.visibleEntityStorage = new EntityLookup();
        this.sectionStorage = new EntitySectionStorage<T>(entityClass, (Long2ObjectFunction<Visibility>)this.chunkVisibility);
        this.chunkVisibility.defaultReturnValue((Object)Visibility.HIDDEN);
        this.chunkLoadStatuses.defaultReturnValue((Object)ChunkLoadStatus.FRESH);
        this.callbacks = callbacks;
        this.permanentStorage = permanentStorage;
        this.entityGetter = new LevelEntityGetterAdapter<T>(this.visibleEntityStorage, this.sectionStorage);
    }

    public List<Entity> getEntities(ChunkPos chunkPos) {
        return this.sectionStorage.getExistingSectionsInChunk(chunkPos.toLong()).flatMap(EntitySection::getEntities).map(entity -> (Entity)entity).collect(Collectors.toList());
    }

    public boolean isPending(long pair) {
        return this.chunkLoadStatuses.get(pair) == ChunkLoadStatus.PENDING;
    }

    void removeSectionIfEmpty(long sectionKey, EntitySection<T> section) {
        if (section.isEmpty()) {
            this.sectionStorage.remove(sectionKey);
        }
    }

    private boolean addEntityUuid(T entity) {
        AsyncCatcher.catchOp("Entity add by UUID");
        if (!this.knownUuids.add(entity.getUUID())) {
            LOGGER.warn("UUID of added entity already exists: {}", entity);
            return false;
        }
        return true;
    }

    public boolean addNewEntity(T entity) {
        return this.addEntity(entity, false);
    }

    private boolean addEntity(T entity, boolean worldGenSpawned) {
        Visibility effectiveStatus;
        AsyncCatcher.catchOp("Entity add");
        Entity entityCasted = (Entity)entity;
        boolean wasRemoved = entityCasted.isRemoved();
        boolean screened = PlatformHooks.get().screenEntity((ServerLevel)entityCasted.level(), entityCasted, worldGenSpawned, true);
        if (!wasRemoved && entityCasted.isRemoved() || !screened) {
            return false;
        }
        if (!this.addEntityUuid(entity)) {
            return false;
        }
        long packedSectionPos = SectionPos.asLong(entity.blockPosition());
        EntitySection<T> section = this.sectionStorage.getOrCreateSection(packedSectionPos);
        section.add(entity);
        entity.setLevelCallback(new Callback(this, entity, packedSectionPos, section));
        if (!worldGenSpawned) {
            this.callbacks.onCreated(entity);
        }
        if ((effectiveStatus = PersistentEntitySectionManager.getEffectiveStatus(entity, section.getStatus())).isAccessible()) {
            this.startTracking(entity);
        }
        if (effectiveStatus.isTicking()) {
            this.startTicking(entity);
        }
        return true;
    }

    static <T extends EntityAccess> Visibility getEffectiveStatus(T entity, Visibility visibility) {
        return entity.isAlwaysTicking() ? Visibility.TICKING : visibility;
    }

    public boolean isTicking(ChunkPos chunkPos) {
        return ((Visibility)((Object)this.chunkVisibility.get(chunkPos.toLong()))).isTicking();
    }

    public void addLegacyChunkEntities(Stream<T> entities) {
        entities.forEach(entity -> this.addEntity(entity, true));
    }

    public void addWorldGenChunkEntities(Stream<T> entities) {
        entities.forEach(entity -> this.addEntity(entity, false));
    }

    void startTicking(T entity) {
        AsyncCatcher.catchOp("Entity start ticking");
        this.callbacks.onTickingStart(entity);
    }

    void stopTicking(T entity) {
        AsyncCatcher.catchOp("Entity stop ticking");
        this.callbacks.onTickingEnd(entity);
    }

    void startTracking(T entity) {
        AsyncCatcher.catchOp("Entity start tracking");
        this.visibleEntityStorage.add(entity);
        this.callbacks.onTrackingStart(entity);
    }

    void stopTracking(T entity) {
        AsyncCatcher.catchOp("Entity stop tracking");
        this.callbacks.onTrackingEnd(entity);
        this.visibleEntityStorage.remove(entity);
    }

    public void updateChunkStatus(ChunkPos chunkPos, FullChunkStatus fullChunkStatus) {
        Visibility visibility = Visibility.fromFullChunkStatus(fullChunkStatus);
        this.updateChunkStatus(chunkPos, visibility);
    }

    public void updateChunkStatus(ChunkPos pos, Visibility visibility) {
        AsyncCatcher.catchOp("Update chunk status");
        long packedChunkPos = pos.toLong();
        if (visibility == Visibility.HIDDEN) {
            this.chunkVisibility.remove(packedChunkPos);
            this.chunksToUnload.add(packedChunkPos);
        } else {
            this.chunkVisibility.put(packedChunkPos, (Object)visibility);
            this.chunksToUnload.remove(packedChunkPos);
            this.ensureChunkQueuedForLoad(packedChunkPos);
        }
        this.sectionStorage.getExistingSectionsInChunk(packedChunkPos).forEach(entitySection -> {
            Visibility visibility1 = entitySection.updateChunkStatus(visibility);
            boolean isAccessible = visibility1.isAccessible();
            boolean isAccessible1 = visibility.isAccessible();
            boolean isTicking = visibility1.isTicking();
            boolean isTicking1 = visibility.isTicking();
            if (isTicking && !isTicking1) {
                entitySection.getEntities().filter(entity -> !entity.isAlwaysTicking()).forEach(this::stopTicking);
            }
            if (isAccessible && !isAccessible1) {
                entitySection.getEntities().filter(entity -> !entity.isAlwaysTicking()).forEach(this::stopTracking);
            } else if (!isAccessible && isAccessible1) {
                entitySection.getEntities().filter(entity -> !entity.isAlwaysTicking()).forEach(this::startTracking);
            }
            if (!isTicking && isTicking1) {
                entitySection.getEntities().filter(entity -> !entity.isAlwaysTicking()).forEach(this::startTicking);
            }
        });
    }

    public void ensureChunkQueuedForLoad(long chunkPosValue) {
        AsyncCatcher.catchOp("Entity chunk save");
        ChunkLoadStatus chunkLoadStatus = (ChunkLoadStatus)((Object)this.chunkLoadStatuses.get(chunkPosValue));
        if (chunkLoadStatus == ChunkLoadStatus.FRESH) {
            this.requestChunkLoad(chunkPosValue);
        }
    }

    private boolean storeChunkSections(long chunkPosValue, Consumer<T> entityAction) {
        return this.storeChunkSections(chunkPosValue, entityAction, false);
    }

    private boolean storeChunkSections(long chunkPosValue, Consumer<T> entityAction, boolean callEvent) {
        ChunkLoadStatus chunkLoadStatus = (ChunkLoadStatus)((Object)this.chunkLoadStatuses.get(chunkPosValue));
        if (chunkLoadStatus == ChunkLoadStatus.PENDING) {
            return false;
        }
        List<T> list = this.sectionStorage.getExistingSectionsInChunk(chunkPosValue).flatMap(entitySection -> entitySection.getEntities().filter(EntityAccess::shouldBeSaved)).collect(Collectors.toList());
        if (list.isEmpty()) {
            if (chunkLoadStatus == ChunkLoadStatus.LOADED) {
                if (callEvent) {
                    CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.permanentStorage).level, new ChunkPos(chunkPosValue), (List<Entity>)ImmutableList.of());
                }
                this.permanentStorage.storeEntities(new ChunkEntities(new ChunkPos(chunkPosValue), ImmutableList.of()));
            }
            return true;
        }
        if (chunkLoadStatus == ChunkLoadStatus.FRESH) {
            this.requestChunkLoad(chunkPosValue);
            return false;
        }
        if (callEvent) {
            CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.permanentStorage).level, new ChunkPos(chunkPosValue), list.stream().map(entity -> (Entity)entity).collect(Collectors.toList()));
        }
        this.permanentStorage.storeEntities(new ChunkEntities(new ChunkPos(chunkPosValue), list));
        list.forEach(entityAction);
        return true;
    }

    private void requestChunkLoad(long chunkPosValue) {
        AsyncCatcher.catchOp("Entity chunk load request");
        this.chunkLoadStatuses.put(chunkPosValue, (Object)ChunkLoadStatus.PENDING);
        ChunkPos chunkPos = new ChunkPos(chunkPosValue);
        ((CompletableFuture)this.permanentStorage.loadEntities(chunkPos).thenAccept(this.loadingInbox::add)).exceptionally(throwable -> {
            LOGGER.error("Failed to read chunk {}", (Object)chunkPos, throwable);
            return null;
        });
    }

    private boolean processChunkUnload(long chunkPosValue) {
        AsyncCatcher.catchOp("Entity chunk unload process");
        boolean flag = this.storeChunkSections(chunkPosValue, entity -> entity.getPassengersAndSelf().forEach(this::unloadEntity), true);
        if (!flag) {
            return false;
        }
        this.chunkLoadStatuses.remove(chunkPosValue);
        return true;
    }

    private void unloadEntity(EntityAccess entity) {
        entity.setRemoved(Entity.RemovalReason.UNLOADED_TO_CHUNK, EntityRemoveEvent.Cause.UNLOAD);
        entity.setLevelCallback(EntityInLevelCallback.NULL);
    }

    private void processUnloads() {
        this.chunksToUnload.removeIf(packedChunkPos -> this.chunkVisibility.get(packedChunkPos) != Visibility.HIDDEN || this.processChunkUnload(packedChunkPos));
    }

    private void processPendingLoads() {
        ChunkEntities<T> chunkEntities;
        AsyncCatcher.catchOp("Entity chunk process pending loads");
        while ((chunkEntities = this.loadingInbox.poll()) != null) {
            chunkEntities.getEntities().forEach(entity -> this.addEntity(entity, true));
            this.chunkLoadStatuses.put(chunkEntities.getPos().toLong(), (Object)ChunkLoadStatus.LOADED);
            List<Entity> entities = this.getEntities(chunkEntities.getPos());
            CraftEventFactory.callEntitiesLoadEvent(((EntityStorage)this.permanentStorage).level, chunkEntities.getPos(), entities);
        }
    }

    public void tick() {
        AsyncCatcher.catchOp("Entity manager tick");
        this.processPendingLoads();
        this.processUnloads();
    }

    private LongSet getAllChunksToSave() {
        LongSet allChunksWithExistingSections = this.sectionStorage.getAllChunksWithExistingSections();
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.chunkLoadStatuses)) {
            if (entry.getValue() != ChunkLoadStatus.LOADED) continue;
            allChunksWithExistingSections.add(entry.getLongKey());
        }
        return allChunksWithExistingSections;
    }

    public void autoSave() {
        AsyncCatcher.catchOp("Entity manager autosave");
        this.getAllChunksToSave().forEach(packedChunkPos -> {
            boolean flag;
            boolean bl = flag = this.chunkVisibility.get(packedChunkPos) == Visibility.HIDDEN;
            if (flag) {
                this.processChunkUnload(packedChunkPos);
            } else {
                this.storeChunkSections(packedChunkPos, entity -> {});
            }
        });
    }

    public void saveAll() {
        AsyncCatcher.catchOp("Entity manager save");
        LongSet allChunksToSave = this.getAllChunksToSave();
        while (!allChunksToSave.isEmpty()) {
            this.permanentStorage.flush(false);
            this.processPendingLoads();
            allChunksToSave.removeIf(packedChunkPos -> {
                boolean flag = this.chunkVisibility.get(packedChunkPos) == Visibility.HIDDEN;
                return flag ? this.processChunkUnload(packedChunkPos) : this.storeChunkSections(packedChunkPos, entity -> {});
            });
        }
        this.permanentStorage.flush(true);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.saveAll();
        }
        this.permanentStorage.close();
    }

    public boolean isLoaded(UUID uuid) {
        return this.knownUuids.contains(uuid);
    }

    public LevelEntityGetter<T> getEntityGetter() {
        return this.entityGetter;
    }

    public boolean canPositionTick(BlockPos pos) {
        return ((Visibility)((Object)this.chunkVisibility.get(ChunkPos.asLong(pos)))).isTicking();
    }

    public boolean canPositionTick(ChunkPos chunkPos) {
        return ((Visibility)((Object)this.chunkVisibility.get(chunkPos.toLong()))).isTicking();
    }

    public boolean areEntitiesLoaded(long chunkPos) {
        return this.chunkLoadStatuses.get(chunkPos) == ChunkLoadStatus.LOADED;
    }

    public void dumpSections(Writer writer) throws IOException {
        CsvOutput csvOutput = CsvOutput.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("visibility").addColumn("load_status").addColumn("entity_count").build(writer);
        this.sectionStorage.getAllChunksWithExistingSections().forEach(packedChunkPos -> {
            ChunkLoadStatus chunkLoadStatus = (ChunkLoadStatus)((Object)((Object)this.chunkLoadStatuses.get(packedChunkPos)));
            this.sectionStorage.getExistingSectionPositionsInChunk(packedChunkPos).forEach(packedSectionPos -> {
                EntitySection<T> section = this.sectionStorage.getSection(packedSectionPos);
                if (section != null) {
                    try {
                        csvOutput.writeRow(new Object[]{SectionPos.x(packedSectionPos), SectionPos.y(packedSectionPos), SectionPos.z(packedSectionPos), section.getStatus(), chunkLoadStatus, section.size()});
                    }
                    catch (IOException var7) {
                        throw new UncheckedIOException(var7);
                    }
                }
            });
        });
    }

    @VisibleForDebug
    public String gatherStats() {
        return this.knownUuids.size() + "," + this.visibleEntityStorage.count() + "," + this.sectionStorage.count() + "," + this.chunkLoadStatuses.size() + "," + this.chunkVisibility.size() + "," + this.loadingInbox.size() + "," + this.chunksToUnload.size();
    }

    @VisibleForDebug
    public int count() {
        return this.visibleEntityStorage.count();
    }

    static enum ChunkLoadStatus {
        FRESH,
        PENDING,
        LOADED;

    }

    class Callback
    implements EntityInLevelCallback {
        private final T entity;
        private long currentSectionKey;
        private EntitySection<T> currentSection;
        final /* synthetic */ PersistentEntitySectionManager this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        Callback(T t, long currentSection, EntitySection<T> entitySection) {
            void var3_3;
            void entity;
            this.this$0 = (PersistentEntitySectionManager)this$0;
            this.entity = entity;
            this.currentSectionKey = var3_3;
            this.currentSection = (EntitySection)currentSection;
        }

        @Override
        public void onMove() {
            BlockPos blockPos = this.entity.blockPosition();
            long packedSectionPos = SectionPos.asLong(blockPos);
            if (packedSectionPos != this.currentSectionKey) {
                AsyncCatcher.catchOp("Entity move");
                Visibility status = this.currentSection.getStatus();
                if (!this.currentSection.remove(this.entity)) {
                    LOGGER.warn("Entity {} wasn't found in section {} (moving to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), packedSectionPos});
                }
                this.this$0.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
                EntitySection section = this.this$0.sectionStorage.getOrCreateSection(packedSectionPos);
                section.add(this.entity);
                this.currentSection = section;
                this.currentSectionKey = packedSectionPos;
                this.updateStatus(status, section.getStatus());
            }
        }

        private void updateStatus(Visibility oldVisibility, Visibility newVisibility) {
            Visibility effectiveStatus1;
            Visibility effectiveStatus = PersistentEntitySectionManager.getEffectiveStatus(this.entity, oldVisibility);
            if (effectiveStatus == (effectiveStatus1 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, newVisibility))) {
                if (effectiveStatus1.isAccessible()) {
                    this.this$0.callbacks.onSectionChange(this.entity);
                }
            } else {
                boolean isAccessible = effectiveStatus.isAccessible();
                boolean isAccessible1 = effectiveStatus1.isAccessible();
                if (isAccessible && !isAccessible1) {
                    this.this$0.stopTracking(this.entity);
                } else if (!isAccessible && isAccessible1) {
                    this.this$0.startTracking(this.entity);
                }
                boolean isTicking = effectiveStatus.isTicking();
                boolean isTicking1 = effectiveStatus1.isTicking();
                if (isTicking && !isTicking1) {
                    this.this$0.stopTicking(this.entity);
                } else if (!isTicking && isTicking1) {
                    this.this$0.startTicking(this.entity);
                }
                if (isAccessible1) {
                    this.this$0.callbacks.onSectionChange(this.entity);
                }
            }
        }

        @Override
        public void onRemove(Entity.RemovalReason reason) {
            Visibility effectiveStatus;
            AsyncCatcher.catchOp("Entity remove");
            if (!this.currentSection.remove(this.entity)) {
                LOGGER.warn("Entity {} wasn't found in section {} (destroying due to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), reason});
            }
            if ((effectiveStatus = PersistentEntitySectionManager.getEffectiveStatus(this.entity, this.currentSection.getStatus())).isTicking()) {
                this.this$0.stopTicking(this.entity);
            }
            if (effectiveStatus.isAccessible()) {
                this.this$0.stopTracking(this.entity);
            }
            if (reason.shouldDestroy()) {
                this.this$0.callbacks.onDestroyed(this.entity);
            }
            this.this$0.knownUuids.remove(this.entity.getUUID());
            this.entity.setLevelCallback(NULL);
            this.this$0.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
        }
    }
}

