/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.level.entity.Visibility;
import org.slf4j.Logger;

public class TransientEntitySectionManager<T extends EntityAccess> {
    static final Logger LOGGER = LogUtils.getLogger();
    final LevelCallback<T> callbacks;
    final EntityLookup<T> entityStorage;
    final EntitySectionStorage<T> sectionStorage;
    private final LongSet tickingChunks = new LongOpenHashSet();
    private final LevelEntityGetter<T> entityGetter;

    public TransientEntitySectionManager(Class<T> clazz, LevelCallback<T> callbacks) {
        this.entityStorage = new EntityLookup();
        this.sectionStorage = new EntitySectionStorage<T>(clazz, (Long2ObjectFunction<Visibility>)((Long2ObjectFunction)packedChunkPos -> this.tickingChunks.contains(packedChunkPos) ? Visibility.TICKING : Visibility.TRACKED));
        this.callbacks = callbacks;
        this.entityGetter = new LevelEntityGetterAdapter<T>(this.entityStorage, this.sectionStorage);
    }

    public void startTicking(ChunkPos pos) {
        long packedChunkPos = pos.toLong();
        this.tickingChunks.add(packedChunkPos);
        this.sectionStorage.getExistingSectionsInChunk(packedChunkPos).forEach(section -> {
            Visibility visibility = section.updateChunkStatus(Visibility.TICKING);
            if (!visibility.isTicking()) {
                section.getEntities().filter(entity -> !entity.isAlwaysTicking()).forEach(this.callbacks::onTickingStart);
            }
        });
    }

    public void stopTicking(ChunkPos pos) {
        long packedChunkPos = pos.toLong();
        this.tickingChunks.remove(packedChunkPos);
        this.sectionStorage.getExistingSectionsInChunk(packedChunkPos).forEach(section -> {
            Visibility visibility = section.updateChunkStatus(Visibility.TRACKED);
            if (visibility.isTicking()) {
                section.getEntities().filter(entity -> !entity.isAlwaysTicking()).forEach(this.callbacks::onTickingEnd);
            }
        });
    }

    public LevelEntityGetter<T> getEntityGetter() {
        return this.entityGetter;
    }

    public void addEntity(T entity) {
        this.entityStorage.add(entity);
        long packedSectionPos = SectionPos.asLong(entity.blockPosition());
        EntitySection<T> section = this.sectionStorage.getOrCreateSection(packedSectionPos);
        section.add(entity);
        entity.setLevelCallback(new Callback(this, entity, packedSectionPos, section));
        this.callbacks.onCreated(entity);
        this.callbacks.onTrackingStart(entity);
        if (entity.isAlwaysTicking() || section.getStatus().isTicking()) {
            this.callbacks.onTickingStart(entity);
        }
    }

    @VisibleForDebug
    public int count() {
        return this.entityStorage.count();
    }

    void removeSectionIfEmpty(long section, EntitySection<T> entitySection) {
        if (entitySection.isEmpty()) {
            this.sectionStorage.remove(section);
        }
    }

    @VisibleForDebug
    public String gatherStats() {
        return this.entityStorage.count() + "," + this.sectionStorage.count() + "," + this.tickingChunks.size();
    }

    class Callback
    implements EntityInLevelCallback {
        private final T entity;
        private long currentSectionKey;
        private EntitySection<T> currentSection;
        final /* synthetic */ TransientEntitySectionManager this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        Callback(T t, long currentSection, EntitySection<T> entitySection) {
            void var3_3;
            void entity;
            this.this$0 = (TransientEntitySectionManager)this$0;
            this.entity = entity;
            this.currentSectionKey = var3_3;
            this.currentSection = (EntitySection)currentSection;
        }

        @Override
        public void onMove() {
            BlockPos blockPos = this.entity.blockPosition();
            long packedSectionPos = SectionPos.asLong(blockPos);
            if (packedSectionPos != this.currentSectionKey) {
                Visibility status = this.currentSection.getStatus();
                if (!this.currentSection.remove(this.entity)) {
                    LOGGER.warn("Entity {} wasn't found in section {} (moving to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), packedSectionPos});
                }
                this.this$0.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
                EntitySection section = this.this$0.sectionStorage.getOrCreateSection(packedSectionPos);
                section.add(this.entity);
                this.currentSection = section;
                this.currentSectionKey = packedSectionPos;
                this.this$0.callbacks.onSectionChange(this.entity);
                if (!this.entity.isAlwaysTicking()) {
                    boolean isTicking = status.isTicking();
                    boolean isTicking1 = section.getStatus().isTicking();
                    if (isTicking && !isTicking1) {
                        this.this$0.callbacks.onTickingEnd(this.entity);
                    } else if (!isTicking && isTicking1) {
                        this.this$0.callbacks.onTickingStart(this.entity);
                    }
                }
            }
        }

        @Override
        public void onRemove(Entity.RemovalReason reason) {
            Visibility status;
            if (!this.currentSection.remove(this.entity)) {
                LOGGER.warn("Entity {} wasn't found in section {} (destroying due to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), reason});
            }
            if ((status = this.currentSection.getStatus()).isTicking() || this.entity.isAlwaysTicking()) {
                this.this$0.callbacks.onTickingEnd(this.entity);
            }
            this.this$0.callbacks.onTrackingEnd(this.entity);
            this.this$0.callbacks.onDestroyed(this.entity);
            this.this$0.entityStorage.remove(this.entity);
            this.entity.setLevelCallback(NULL);
            this.this$0.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
        }
    }
}

