/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.apache.commons.lang3.tuple.Pair;

public class VibrationSelector {
    public static final Codec<VibrationSelector> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VibrationInfo.CODEC.lenientOptionalFieldOf("event").forGetter(selector -> selector.currentVibrationData.map(Pair::getLeft)), (App)Codec.LONG.fieldOf("tick").forGetter(selector -> selector.currentVibrationData.map(Pair::getRight).orElse(-1L))).apply((Applicative)instance, VibrationSelector::new));
    private Optional<Pair<VibrationInfo, Long>> currentVibrationData;

    public VibrationSelector(Optional<VibrationInfo> event, long tick) {
        this.currentVibrationData = event.map(inf -> Pair.of((Object)inf, (Object)tick));
    }

    public VibrationSelector() {
        this.currentVibrationData = Optional.empty();
    }

    public void addCandidate(VibrationInfo vibrationInfo, long tick) {
        if (this.shouldReplaceVibration(vibrationInfo, tick)) {
            this.currentVibrationData = Optional.of(Pair.of((Object)vibrationInfo, (Object)tick));
        }
    }

    private boolean shouldReplaceVibration(VibrationInfo vibrationInfo, long tick) {
        if (this.currentVibrationData.isEmpty()) {
            return true;
        }
        Pair<VibrationInfo, Long> pair = this.currentVibrationData.get();
        long right = (Long)pair.getRight();
        if (tick != right) {
            return false;
        }
        VibrationInfo vibrationInfo1 = (VibrationInfo)pair.getLeft();
        return vibrationInfo.distance() < vibrationInfo1.distance() || !(vibrationInfo.distance() > vibrationInfo1.distance()) && VibrationSystem.getGameEventFrequency(vibrationInfo.gameEvent()) > VibrationSystem.getGameEventFrequency(vibrationInfo1.gameEvent());
    }

    public Optional<VibrationInfo> chosenCandidate(long tick) {
        if (this.currentVibrationData.isEmpty()) {
            return Optional.empty();
        }
        return (Long)this.currentVibrationData.get().getRight() < tick ? Optional.of((VibrationInfo)this.currentVibrationData.get().getLeft()) : Optional.empty();
    }

    public void startOver() {
        this.currentVibrationData = Optional.empty();
    }
}

