/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class Beardifier
implements DensityFunctions.BeardifierOrMarker {
    public static final int BEARD_KERNEL_RADIUS = 12;
    private static final int BEARD_KERNEL_SIZE = 24;
    private static final float[] BEARD_KERNEL = Util.make(new float[13824], array -> {
        for (int i = 0; i < 24; ++i) {
            for (int i1 = 0; i1 < 24; ++i1) {
                for (int i2 = 0; i2 < 24; ++i2) {
                    array[i * 24 * 24 + i1 * 24 + i2] = (float)Beardifier.computeBeardContribution(i1 - 12, i2 - 12, i - 12);
                }
            }
        }
    });
    private final ObjectListIterator<Rigid> pieceIterator;
    private final ObjectListIterator<JigsawJunction> junctionIterator;

    public static Beardifier forStructuresInChunk(StructureManager structureManager, ChunkPos chunkPos) {
        int minBlockX = chunkPos.getMinBlockX();
        int minBlockZ = chunkPos.getMinBlockZ();
        ObjectArrayList list = new ObjectArrayList(10);
        ObjectArrayList list1 = new ObjectArrayList(32);
        for (StructureStart structureStart : structureManager.startsForStructure(chunkPos, structure -> structure.terrainAdaptation() != TerrainAdjustment.NONE)) {
            TerrainAdjustment terrainAdjustment = structureStart.getStructure().terrainAdaptation();
            for (StructurePiece structurePiece : structureStart.getPieces()) {
                if (!structurePiece.isCloseToChunk(chunkPos, 12)) continue;
                if (structurePiece instanceof PoolElementStructurePiece) {
                    PoolElementStructurePiece poolElementStructurePiece = (PoolElementStructurePiece)structurePiece;
                    StructureTemplatePool.Projection projection = poolElementStructurePiece.getElement().getProjection();
                    if (projection == StructureTemplatePool.Projection.RIGID) {
                        list.add((Object)new Rigid(poolElementStructurePiece.getBoundingBox(), terrainAdjustment, poolElementStructurePiece.getGroundLevelDelta()));
                    }
                    for (JigsawJunction jigsawJunction : poolElementStructurePiece.getJunctions()) {
                        int sourceX = jigsawJunction.getSourceX();
                        int sourceZ = jigsawJunction.getSourceZ();
                        if (sourceX <= minBlockX - 12 || sourceZ <= minBlockZ - 12 || sourceX >= minBlockX + 15 + 12 || sourceZ >= minBlockZ + 15 + 12) continue;
                        list1.add((Object)jigsawJunction);
                    }
                    continue;
                }
                list.add((Object)new Rigid(structurePiece.getBoundingBox(), terrainAdjustment, 0));
            }
        }
        return new Beardifier((ObjectListIterator<Rigid>)list.iterator(), (ObjectListIterator<JigsawJunction>)list1.iterator());
    }

    @VisibleForTesting
    public Beardifier(ObjectListIterator<Rigid> pieceIterator, ObjectListIterator<JigsawJunction> junctionIterator) {
        this.pieceIterator = pieceIterator;
        this.junctionIterator = junctionIterator;
    }

    @Override
    public double compute(DensityFunction.FunctionContext context) {
        int max;
        int groundLevelDelta;
        int i = context.blockX();
        int i1 = context.blockY();
        int i2 = context.blockZ();
        double d = 0.0;
        while (this.pieceIterator.hasNext()) {
            Rigid rigid = (Rigid)this.pieceIterator.next();
            BoundingBox boundingBox = rigid.box();
            groundLevelDelta = rigid.groundLevelDelta();
            max = Math.max(0, Math.max(boundingBox.minX() - i, i - boundingBox.maxX()));
            int max1 = Math.max(0, Math.max(boundingBox.minZ() - i2, i2 - boundingBox.maxZ()));
            int i3 = boundingBox.minY() + groundLevelDelta;
            int i4 = i1 - i3;
            int i5 = switch (rigid.terrainAdjustment()) {
                default -> throw new MatchException(null, null);
                case TerrainAdjustment.NONE -> 0;
                case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN -> i4;
                case TerrainAdjustment.BEARD_BOX -> Math.max(0, Math.max(i3 - i1, i1 - boundingBox.maxY()));
                case TerrainAdjustment.ENCAPSULATE -> Math.max(0, Math.max(boundingBox.minY() - i1, i1 - boundingBox.maxY()));
            };
            d += (switch (rigid.terrainAdjustment()) {
                default -> throw new MatchException(null, null);
                case TerrainAdjustment.NONE -> 0.0;
                case TerrainAdjustment.BURY -> Beardifier.getBuryContribution(max, (double)i5 / 2.0, max1);
                case TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> Beardifier.getBeardContribution(max, i5, max1, i4) * 0.8;
                case TerrainAdjustment.ENCAPSULATE -> Beardifier.getBuryContribution((double)max / 2.0, (double)i5 / 2.0, (double)max1 / 2.0) * 0.8;
            });
        }
        this.pieceIterator.back(Integer.MAX_VALUE);
        while (this.junctionIterator.hasNext()) {
            JigsawJunction jigsawJunction = (JigsawJunction)this.junctionIterator.next();
            int i6 = i - jigsawJunction.getSourceX();
            groundLevelDelta = i1 - jigsawJunction.getSourceGroundY();
            max = i2 - jigsawJunction.getSourceZ();
            d += Beardifier.getBeardContribution(i6, groundLevelDelta, max, groundLevelDelta) * 0.4;
        }
        this.junctionIterator.back(Integer.MAX_VALUE);
        return d;
    }

    @Override
    public double minValue() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double maxValue() {
        return Double.POSITIVE_INFINITY;
    }

    private static double getBuryContribution(double x, double y, double z) {
        double len = Mth.length(x, y, z);
        return Mth.clampedMap(len, 0.0, 6.0, 1.0, 0.0);
    }

    private static double getBeardContribution(int x, int y, int z, int height) {
        int i = x + 12;
        int i1 = y + 12;
        int i2 = z + 12;
        if (Beardifier.isInKernelRange(i) && Beardifier.isInKernelRange(i1) && Beardifier.isInKernelRange(i2)) {
            double d = (double)height + 0.5;
            double d1 = Mth.lengthSquared((double)x, d, (double)z);
            double d2 = -d * Mth.fastInvSqrt(d1 / 2.0) / 2.0;
            return d2 * (double)BEARD_KERNEL[i2 * 24 * 24 + i * 24 + i1];
        }
        return 0.0;
    }

    private static boolean isInKernelRange(int value) {
        return value >= 0 && value < 24;
    }

    private static double computeBeardContribution(int x, int y, int z) {
        return Beardifier.computeBeardContribution(x, (double)y + 0.5, z);
    }

    private static double computeBeardContribution(int x, double y, int z) {
        double d = Mth.lengthSquared((double)x, y, (double)z);
        return Math.pow(Math.E, -d / 16.0);
    }

    @VisibleForTesting
    public record Rigid(BoundingBox box, TerrainAdjustment terrainAdjustment, int groundLevelDelta) {
    }
}

