/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class MarsagliaPolarGaussian {
    public final RandomSource randomSource;
    private double nextNextGaussian;
    private boolean haveNextNextGaussian;

    public MarsagliaPolarGaussian(RandomSource randomSource) {
        this.randomSource = randomSource;
    }

    public void reset() {
        this.haveNextNextGaussian = false;
    }

    public double nextGaussian() {
        double d1;
        double d;
        double d2;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        do {
            d = 2.0 * this.randomSource.nextDouble() - 1.0;
            d1 = 2.0 * this.randomSource.nextDouble() - 1.0;
        } while ((d2 = Mth.square(d) + Mth.square(d1)) >= 1.0 || d2 == 0.0);
        double squareRoot = Math.sqrt(-2.0 * Math.log(d2) / d2);
        this.nextNextGaussian = d1 * squareRoot;
        this.haveNextNextGaussian = true;
        return d * squareRoot;
    }
}

