/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;

public class BasaltColumnsFeature
extends Feature<ColumnFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_PLACE_ON = ImmutableList.of((Object)Blocks.LAVA, (Object)Blocks.BEDROCK, (Object)Blocks.MAGMA_BLOCK, (Object)Blocks.SOUL_SAND, (Object)Blocks.NETHER_BRICKS, (Object)Blocks.NETHER_BRICK_FENCE, (Object)Blocks.NETHER_BRICK_STAIRS, (Object)Blocks.NETHER_WART, (Object)Blocks.CHEST, (Object)Blocks.SPAWNER);
    private static final int CLUSTERED_REACH = 5;
    private static final int CLUSTERED_SIZE = 50;
    private static final int UNCLUSTERED_REACH = 8;
    private static final int UNCLUSTERED_SIZE = 15;

    public BasaltColumnsFeature(Codec<ColumnFeatureConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean place(FeaturePlaceContext<ColumnFeatureConfiguration> context) {
        int seaLevel = context.chunkGenerator().getSeaLevel();
        BlockPos blockPos = context.origin();
        WorldGenLevel worldGenLevel = context.level();
        RandomSource randomSource = context.random();
        ColumnFeatureConfiguration columnFeatureConfiguration = context.config();
        if (!BasaltColumnsFeature.canPlaceAt(worldGenLevel, seaLevel, blockPos.mutable())) {
            return false;
        }
        int i = columnFeatureConfiguration.height().sample(randomSource);
        boolean flag = randomSource.nextFloat() < 0.9f;
        int min = Math.min(i, flag ? 5 : 8);
        int i1 = flag ? 50 : 15;
        boolean flag1 = false;
        for (BlockPos blockPos1 : BlockPos.randomBetweenClosed(randomSource, i1, blockPos.getX() - min, blockPos.getY(), blockPos.getZ() - min, blockPos.getX() + min, blockPos.getY(), blockPos.getZ() + min)) {
            int i2 = i - blockPos1.distManhattan(blockPos);
            if (i2 < 0) continue;
            flag1 |= this.placeColumn(worldGenLevel, seaLevel, blockPos1, i2, columnFeatureConfiguration.reach().sample(randomSource));
        }
        return flag1;
    }

    private boolean placeColumn(LevelAccessor level, int seaLevel, BlockPos pos, int distance, int reach) {
        boolean flag = false;
        block0: for (BlockPos blockPos : BlockPos.betweenClosed(pos.getX() - reach, pos.getY(), pos.getZ() - reach, pos.getX() + reach, pos.getY(), pos.getZ() + reach)) {
            int i = blockPos.distManhattan(pos);
            BlockPos blockPos1 = BasaltColumnsFeature.isAirOrLavaOcean(level, seaLevel, blockPos) ? BasaltColumnsFeature.findSurface(level, seaLevel, blockPos.mutable(), i) : BasaltColumnsFeature.findAir(level, blockPos.mutable(), i);
            if (blockPos1 == null) continue;
            BlockPos.MutableBlockPos mutableBlockPos = blockPos1.mutable();
            for (int i1 = distance - i / 2; i1 >= 0; --i1) {
                if (BasaltColumnsFeature.isAirOrLavaOcean(level, seaLevel, mutableBlockPos)) {
                    this.setBlock(level, mutableBlockPos, Blocks.BASALT.defaultBlockState());
                    mutableBlockPos.move(Direction.UP);
                    flag = true;
                    continue;
                }
                if (!level.getBlockState(mutableBlockPos).is(Blocks.BASALT)) continue block0;
                mutableBlockPos.move(Direction.UP);
            }
        }
        return flag;
    }

    @Nullable
    private static BlockPos findSurface(LevelAccessor level, int seaLevel, BlockPos.MutableBlockPos pos, int distance) {
        while (pos.getY() > level.getMinY() + 1 && distance > 0) {
            --distance;
            if (BasaltColumnsFeature.canPlaceAt(level, seaLevel, pos)) {
                return pos;
            }
            pos.move(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(LevelAccessor level, int seaLevel, BlockPos.MutableBlockPos pos) {
        if (!BasaltColumnsFeature.isAirOrLavaOcean(level, seaLevel, pos)) {
            return false;
        }
        BlockState blockState = level.getBlockState(pos.move(Direction.DOWN));
        pos.move(Direction.UP);
        return !blockState.isAir() && !CANNOT_PLACE_ON.contains((Object)blockState.getBlock());
    }

    @Nullable
    private static BlockPos findAir(LevelAccessor level, BlockPos.MutableBlockPos pos, int distance) {
        while (pos.getY() <= level.getMaxY() && distance > 0) {
            --distance;
            BlockState blockState = level.getBlockState(pos);
            if (CANNOT_PLACE_ON.contains((Object)blockState.getBlock())) {
                return null;
            }
            if (blockState.isAir()) {
                return pos;
            }
            pos.move(Direction.UP);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(LevelAccessor level, int seaLevel, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        return blockState.isAir() || blockState.is(Blocks.LAVA) && pos.getY() <= seaLevel;
    }
}

