/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class BlockBlobFeature
extends Feature<BlockStateConfiguration> {
    public BlockBlobFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        BlockState blockState;
        BlockPos blockPos = context.origin();
        WorldGenLevel worldGenLevel = context.level();
        RandomSource randomSource = context.random();
        BlockStateConfiguration blockStateConfiguration = context.config();
        while (blockPos.getY() > worldGenLevel.getMinY() + 3 && (worldGenLevel.isEmptyBlock(blockPos.below()) || !BlockBlobFeature.isDirt(blockState = worldGenLevel.getBlockState(blockPos.below())) && !BlockBlobFeature.isStone(blockState))) {
            blockPos = blockPos.below();
        }
        if (blockPos.getY() <= worldGenLevel.getMinY() + 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            int randomInt = randomSource.nextInt(2);
            int randomInt1 = randomSource.nextInt(2);
            int randomInt2 = randomSource.nextInt(2);
            float f = (float)(randomInt + randomInt1 + randomInt2) * 0.333f + 0.5f;
            for (BlockPos blockPos1 : BlockPos.betweenClosed(blockPos.offset(-randomInt, -randomInt1, -randomInt2), blockPos.offset(randomInt, randomInt1, randomInt2))) {
                if (!(blockPos1.distSqr(blockPos) <= (double)(f * f))) continue;
                worldGenLevel.setBlock(blockPos1, blockStateConfiguration.state, 3);
            }
            blockPos = blockPos.offset(-1 + randomSource.nextInt(2), -randomSource.nextInt(2), -1 + randomSource.nextInt(2));
        }
        return true;
    }
}

