/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class BeehiveDecorator
extends TreeDecorator {
    public static final MapCodec<BeehiveDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(BeehiveDecorator::new, decorator -> Float.valueOf(decorator.probability));
    private static final Direction WORLDGEN_FACING = Direction.SOUTH;
    private static final Direction[] SPAWN_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.stream().filter(direction -> direction != WORLDGEN_FACING.getOpposite()).toArray(Direction[]::new);
    private final float probability;

    public BeehiveDecorator(float probability) {
        this.probability = probability;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.BEEHIVE;
    }

    @Override
    public void place(TreeDecorator.Context context) {
        RandomSource randomSource;
        ObjectArrayList<BlockPos> list = context.leaves();
        ObjectArrayList<BlockPos> list1 = context.logs();
        if (!list1.isEmpty() && !((randomSource = context.random()).nextFloat() >= this.probability)) {
            int i = !list.isEmpty() ? Math.max(((BlockPos)list.getFirst()).getY() - 1, ((BlockPos)list1.getFirst()).getY() + 1) : Math.min(((BlockPos)list1.getFirst()).getY() + 1 + randomSource.nextInt(3), ((BlockPos)list1.getLast()).getY());
            List list2 = list1.stream().filter(blockPos -> blockPos.getY() == i).flatMap(blockPos -> Stream.of(SPAWN_DIRECTIONS).map(blockPos::relative)).collect(Collectors.toList());
            if (!list2.isEmpty()) {
                Util.shuffle(list2, randomSource);
                Optional<BlockPos> optional = list2.stream().filter(blockPos -> context.isAir((BlockPos)blockPos) && context.isAir(blockPos.relative(WORLDGEN_FACING))).findFirst();
                if (!optional.isEmpty()) {
                    context.setBlock(optional.get(), (BlockState)Blocks.BEE_NEST.defaultBlockState().setValue(BeehiveBlock.FACING, WORLDGEN_FACING));
                    context.level().getBlockEntity(optional.get(), BlockEntityType.BEEHIVE).ifPresent(beehiveBlockEntity -> {
                        int i1 = 2 + randomSource.nextInt(2);
                        for (int i2 = 0; i2 < i1; ++i2) {
                            beehiveBlockEntity.storeBee(BeehiveBlockEntity.Occupant.create(randomSource.nextInt(599)));
                        }
                    });
                }
            }
        }
    }
}

