/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class FancyTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<FancyTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> FancyTrunkPlacer.trunkPlacerParts(instance).apply((Applicative)instance, FancyTrunkPlacer::new));
    private static final double TRUNK_HEIGHT_SCALE = 0.618;
    private static final double CLUSTER_DENSITY_MAGIC = 1.382;
    private static final double BRANCH_SLOPE = 0.381;
    private static final double BRANCH_LENGTH_MAGIC = 0.328;

    public FancyTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @Override
    protected TrunkPlacerType<?> type() {
        return TrunkPlacerType.FANCY_TRUNK_PLACER;
    }

    @Override
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        int i3;
        int i = 5;
        int i1 = freeTreeHeight + 2;
        int floor = Mth.floor((double)i1 * 0.618);
        FancyTrunkPlacer.setDirtAt(level, blockSetter, random, pos.below(), config);
        double d = 1.0;
        int min = Math.min(1, Mth.floor(1.382 + Math.pow(1.0 * (double)i1 / 13.0, 2.0)));
        int i2 = pos.getY() + floor;
        ArrayList list = Lists.newArrayList();
        list.add(new FoliageCoords(pos.above(i3), i2));
        for (i3 = i1 - 5; i3 >= 0; --i3) {
            float f = FancyTrunkPlacer.treeShape(i1, i3);
            if (f < 0.0f) continue;
            for (int i4 = 0; i4 < min; ++i4) {
                BlockPos blockPos1;
                double d1 = 1.0;
                double d2 = 1.0 * (double)f * ((double)random.nextFloat() + 0.328);
                double d3 = (double)(random.nextFloat() * 2.0f) * Math.PI;
                double d4 = d2 * Math.sin(d3) + 0.5;
                double d5 = d2 * Math.cos(d3) + 0.5;
                BlockPos blockPos = pos.offset(Mth.floor(d4), i3 - 1, Mth.floor(d5));
                if (!this.makeLimb(level, blockSetter, random, blockPos, blockPos1 = blockPos.above(5), false, config)) continue;
                int i5 = pos.getX() - blockPos.getX();
                int i6 = pos.getZ() - blockPos.getZ();
                double d6 = (double)blockPos.getY() - Math.sqrt(i5 * i5 + i6 * i6) * 0.381;
                int i7 = d6 > (double)i2 ? i2 : (int)d6;
                BlockPos blockPos2 = new BlockPos(pos.getX(), i7, pos.getZ());
                if (!this.makeLimb(level, blockSetter, random, blockPos2, blockPos, false, config)) continue;
                list.add(new FoliageCoords(blockPos, blockPos2.getY()));
            }
        }
        this.makeLimb(level, blockSetter, random, pos, pos.above(floor), true, config);
        this.makeBranches(level, blockSetter, random, i1, pos, list, config);
        ArrayList list1 = Lists.newArrayList();
        for (FoliageCoords foliageCoords : list) {
            if (!this.trimBranches(i1, foliageCoords.getBranchBase() - pos.getY())) continue;
            list1.add(foliageCoords.attachment);
        }
        return list1;
    }

    private boolean makeLimb(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos basePos, BlockPos offsetPos, boolean modifyWorld, TreeConfiguration config) {
        if (!modifyWorld && Objects.equals(basePos, offsetPos)) {
            return true;
        }
        BlockPos blockPos = offsetPos.offset(-basePos.getX(), -basePos.getY(), -basePos.getZ());
        int steps = this.getSteps(blockPos);
        float f = (float)blockPos.getX() / (float)steps;
        float f1 = (float)blockPos.getY() / (float)steps;
        float f2 = (float)blockPos.getZ() / (float)steps;
        for (int i = 0; i <= steps; ++i) {
            BlockPos blockPos1 = basePos.offset(Mth.floor(0.5f + (float)i * f), Mth.floor(0.5f + (float)i * f1), Mth.floor(0.5f + (float)i * f2));
            if (modifyWorld) {
                this.placeLog(level, blockSetter, random, blockPos1, config, blockState -> (BlockState)blockState.trySetValue(RotatedPillarBlock.AXIS, this.getLogAxis(basePos, blockPos1)));
                continue;
            }
            if (this.isFree(level, blockPos1)) continue;
            return false;
        }
        return true;
    }

    private int getSteps(BlockPos pos) {
        int abs = Mth.abs(pos.getX());
        int abs1 = Mth.abs(pos.getY());
        int abs2 = Mth.abs(pos.getZ());
        return Math.max(abs, Math.max(abs1, abs2));
    }

    private Direction.Axis getLogAxis(BlockPos pos, BlockPos otherPos) {
        int abs1;
        Direction.Axis axis = Direction.Axis.Y;
        int abs = Math.abs(otherPos.getX() - pos.getX());
        int max = Math.max(abs, abs1 = Math.abs(otherPos.getZ() - pos.getZ()));
        if (max > 0) {
            axis = abs == max ? Direction.Axis.X : Direction.Axis.Z;
        }
        return axis;
    }

    private boolean trimBranches(int maxHeight, int currentHeight) {
        return (double)currentHeight >= (double)maxHeight * 0.2;
    }

    private void makeBranches(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int maxHeight, BlockPos pos, List<FoliageCoords> foliageCoords, TreeConfiguration config) {
        for (FoliageCoords foliageCoords1 : foliageCoords) {
            int branchBase = foliageCoords1.getBranchBase();
            BlockPos blockPos = new BlockPos(pos.getX(), branchBase, pos.getZ());
            if (blockPos.equals(foliageCoords1.attachment.pos()) || !this.trimBranches(maxHeight, branchBase - pos.getY())) continue;
            this.makeLimb(level, blockSetter, random, blockPos, foliageCoords1.attachment.pos(), true, config);
        }
    }

    private static float treeShape(int height, int currentY) {
        if ((float)currentY < (float)height * 0.3f) {
            return -1.0f;
        }
        float f = (float)height / 2.0f;
        float f1 = f - (float)currentY;
        float squareRoot = Mth.sqrt(f * f - f1 * f1);
        if (f1 == 0.0f) {
            squareRoot = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return squareRoot * 0.5f;
    }

    static class FoliageCoords {
        final FoliagePlacer.FoliageAttachment attachment;
        private final int branchBase;

        public FoliageCoords(BlockPos attachmentPos, int branchBase) {
            this.attachment = new FoliagePlacer.FoliageAttachment(attachmentPos, 0, false);
            this.branchBase = branchBase;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

