/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools.alias;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;

@FunctionalInterface
public interface PoolAliasLookup {
    public static final PoolAliasLookup EMPTY = poolKey -> poolKey;

    public ResourceKey<StructureTemplatePool> lookup(ResourceKey<StructureTemplatePool> var1);

    public static PoolAliasLookup create(List<PoolAliasBinding> aliases, BlockPos pos, long seed) {
        if (aliases.isEmpty()) {
            return EMPTY;
        }
        RandomSource randomSource = RandomSource.create(seed).forkPositional().at(pos);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        aliases.forEach(poolAliasBinding -> poolAliasBinding.forEachResolved(randomSource, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1)));
        ImmutableMap map = builder.build();
        return arg_0 -> PoolAliasLookup.lambda$create$3((Map)map, arg_0);
    }

    private static /* synthetic */ ResourceKey lambda$create$3(Map map, ResourceKey poolKey) {
        return Objects.requireNonNull(map.getOrDefault(poolKey, poolKey), () -> "alias " + String.valueOf(poolKey.location()) + " was mapped to null value");
    }
}

