/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.slf4j.Logger;

public class JigsawReplacementProcessor
extends StructureProcessor {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<JigsawReplacementProcessor> CODEC = MapCodec.unit(() -> INSTANCE);
    public static final JigsawReplacementProcessor INSTANCE = new JigsawReplacementProcessor();

    private JigsawReplacementProcessor() {
    }

    @Override
    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader level, BlockPos offset, BlockPos pos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        BlockState blockState = relativeBlockInfo.state();
        if (blockState.is(Blocks.JIGSAW)) {
            BlockState blockState1;
            if (relativeBlockInfo.nbt() == null) {
                LOGGER.warn("Jigsaw block at {} is missing nbt, will not replace", (Object)offset);
                return relativeBlockInfo;
            }
            String stringOr = relativeBlockInfo.nbt().getStringOr("final_state", "minecraft:air");
            try {
                BlockStateParser.BlockResult blockResult = BlockStateParser.parseForBlock(level.holderLookup(Registries.BLOCK), stringOr, true);
                blockState1 = blockResult.blockState();
            }
            catch (CommandSyntaxException var11) {
                LOGGER.error("Failed to parse jigsaw replacement state '{}' at {}: {}", new Object[]{stringOr, offset, var11.getMessage()});
                return null;
            }
            return blockState1.is(Blocks.STRUCTURE_VOID) ? null : new StructureTemplate.StructureBlockInfo(relativeBlockInfo.pos(), blockState1, null);
        }
        return relativeBlockInfo;
    }

    @Override
    protected StructureProcessorType<?> getType() {
        return StructureProcessorType.JIGSAW_REPLACEMENT;
    }
}

