/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.player.PlayerTeleportEvent;

public record TeleportTransition(ServerLevel newLevel, Vec3 position, Vec3 deltaMovement, float yRot, float xRot, boolean missingRespawnBlock, boolean asPassenger, Set<Relative> relatives, PostTeleportTransition postTeleportTransition, PlayerTeleportEvent.TeleportCause cause) {
    public static final PostTeleportTransition DO_NOTHING = entity -> {};
    public static final PostTeleportTransition PLAY_PORTAL_SOUND = TeleportTransition::playPortalSound;
    public static final PostTeleportTransition PLACE_PORTAL_TICKET = TeleportTransition::placePortalTicket;

    public TeleportTransition(ServerLevel newLevel, Vec3 position, Vec3 deltaMovement, float yRot, float xRot, boolean missingRespawnBlock, boolean asPassenger, Set<Relative> relatives, PostTeleportTransition postTeleportTransition) {
        this(newLevel, position, deltaMovement, yRot, xRot, missingRespawnBlock, asPassenger, relatives, postTeleportTransition, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public TeleportTransition(PlayerTeleportEvent.TeleportCause cause) {
        this(null, Vec3.ZERO, Vec3.ZERO, 0.0f, 0.0f, false, false, Set.of(), DO_NOTHING, cause);
    }

    public TeleportTransition(ServerLevel newLevel, Vec3 position, Vec3 deltaMovement, float yRot, float xRot, PostTeleportTransition postTeleportTransition) {
        this(newLevel, position, deltaMovement, yRot, xRot, postTeleportTransition, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public TeleportTransition(ServerLevel newLevel, Vec3 position, Vec3 deltaMovement, float yRot, float xRot, PostTeleportTransition postTeleportTransition, PlayerTeleportEvent.TeleportCause cause) {
        this(newLevel, position, deltaMovement, yRot, xRot, Set.of(), postTeleportTransition, cause);
    }

    public TeleportTransition(ServerLevel newLevel, Vec3 position, Vec3 deltaMovement, float yRot, float xRot, Set<Relative> relatives, PostTeleportTransition postTeleportTransition) {
        this(newLevel, position, deltaMovement, yRot, xRot, relatives, postTeleportTransition, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public TeleportTransition(ServerLevel newLevel, Vec3 position, Vec3 deltaMovement, float yRot, float xRot, Set<Relative> relatives, PostTeleportTransition postTeleportTransition, PlayerTeleportEvent.TeleportCause cause) {
        this(newLevel, position, deltaMovement, yRot, xRot, false, false, relatives, postTeleportTransition, cause);
    }

    public TeleportTransition(ServerLevel level, Entity entity, PostTeleportTransition postTeleportTransition) {
        this(level, entity, postTeleportTransition, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public TeleportTransition(ServerLevel level, Entity entity, PostTeleportTransition postTeleportTransition, PlayerTeleportEvent.TeleportCause cause) {
        this(level, TeleportTransition.findAdjustedSharedSpawnPos(level, entity), Vec3.ZERO, level.getSharedSpawnAngle(), 0.0f, false, false, Set.of(), postTeleportTransition, cause);
    }

    private static void playPortalSound(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.connection.send(new ClientboundLevelEventPacket(1032, BlockPos.ZERO, 0, false));
        }
    }

    private static void placePortalTicket(Entity entity) {
        entity.placePortalTicket(BlockPos.containing(entity.position()));
    }

    public static TeleportTransition missingRespawnBlock(ServerLevel level, Entity entity, PostTeleportTransition postTeleportTransition) {
        return new TeleportTransition(level, TeleportTransition.findAdjustedSharedSpawnPos(level, entity), Vec3.ZERO, level.getSharedSpawnAngle(), 0.0f, true, false, Set.of(), postTeleportTransition);
    }

    private static Vec3 findAdjustedSharedSpawnPos(ServerLevel level, Entity entity) {
        return entity.adjustSpawnLocation(level, level.getSharedSpawnPos()).getBottomCenter();
    }

    public TeleportTransition withRotation(float yRot, float xRot) {
        return new TeleportTransition(this.newLevel(), this.position(), this.deltaMovement(), yRot, xRot, this.missingRespawnBlock(), this.asPassenger(), this.relatives(), this.postTeleportTransition());
    }

    public TeleportTransition withPosition(Vec3 position) {
        return new TeleportTransition(this.newLevel(), position, this.deltaMovement(), this.yRot(), this.xRot(), this.missingRespawnBlock(), this.asPassenger(), this.relatives(), this.postTeleportTransition());
    }

    public TeleportTransition transitionAsPassenger() {
        return new TeleportTransition(this.newLevel(), this.position(), this.deltaMovement(), this.yRot(), this.xRot(), this.missingRespawnBlock(), true, this.relatives(), this.postTeleportTransition());
    }

    @FunctionalInterface
    public static interface PostTeleportTransition {
        public void onTransition(Entity var1);

        default public PostTeleportTransition then(PostTeleportTransition postTeleportTransition) {
            return entity -> {
                this.onTransition(entity);
                postTeleportTransition.onTransition(entity);
            };
        }
    }
}

