/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.validation;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class PathAllowList
implements PathMatcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String COMMENT_PREFIX = "#";
    private final List<ConfigEntry> entries;
    private final Map<String, PathMatcher> compiledPaths = new ConcurrentHashMap<String, PathMatcher>();

    public PathAllowList(List<ConfigEntry> entries) {
        this.entries = entries;
    }

    public PathMatcher getForFileSystem(FileSystem fileSystem) {
        return this.compiledPaths.computeIfAbsent(fileSystem.provider().getScheme(), key -> {
            List<PathMatcher> list;
            try {
                list = this.entries.stream().map(configEntry -> configEntry.compile(fileSystem)).toList();
            }
            catch (Exception var5) {
                LOGGER.error("Failed to compile file pattern list", (Throwable)var5);
                return path -> false;
            }
            return switch (list.size()) {
                case 0 -> path -> false;
                case 1 -> list.get(0);
                default -> path -> {
                    for (PathMatcher pathMatcher : list) {
                        if (!pathMatcher.matches(path)) continue;
                        return true;
                    }
                    return false;
                };
            };
        });
    }

    @Override
    public boolean matches(Path path) {
        return this.getForFileSystem(path.getFileSystem()).matches(path);
    }

    public static PathAllowList readPlain(BufferedReader reader) {
        return new PathAllowList(reader.lines().flatMap(line -> ConfigEntry.parse(line).stream()).toList());
    }

    public record ConfigEntry(EntryType type, String pattern) {
        public PathMatcher compile(FileSystem fileSystem) {
            return this.type().compile(fileSystem, this.pattern);
        }

        static Optional<ConfigEntry> parse(String string) {
            if (string.isBlank() || string.startsWith(PathAllowList.COMMENT_PREFIX)) {
                return Optional.empty();
            }
            if (!string.startsWith("[")) {
                return Optional.of(new ConfigEntry(EntryType.PREFIX, string));
            }
            int index = string.indexOf(93, 1);
            if (index == -1) {
                throw new IllegalArgumentException("Unterminated type in line '" + string + "'");
            }
            String sub = string.substring(1, index);
            String sub1 = string.substring(index + 1);
            return switch (sub) {
                case "glob", "regex" -> Optional.of(new ConfigEntry(EntryType.FILESYSTEM, sub + ":" + sub1));
                case "prefix" -> Optional.of(new ConfigEntry(EntryType.PREFIX, sub1));
                default -> throw new IllegalArgumentException("Unsupported definition type in line '" + string + "'");
            };
        }

        static ConfigEntry glob(String glob) {
            return new ConfigEntry(EntryType.FILESYSTEM, "glob:" + glob);
        }

        static ConfigEntry regex(String regex) {
            return new ConfigEntry(EntryType.FILESYSTEM, "regex:" + regex);
        }

        static ConfigEntry prefix(String prefix) {
            return new ConfigEntry(EntryType.PREFIX, prefix);
        }
    }

    @FunctionalInterface
    public static interface EntryType {
        public static final EntryType FILESYSTEM = FileSystem::getPathMatcher;
        public static final EntryType PREFIX = (fileSystem, pattern) -> path -> path.toString().startsWith(pattern);

        public PathMatcher compile(FileSystem var1, String var2);
    }
}

