/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.MinecartCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface CollisionContext {
    public static CollisionContext empty() {
        return EntityCollisionContext.EMPTY;
    }

    public static CollisionContext of(Entity entity) {
        Entity entity2 = entity;
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractMinecart.class}, (Object)entity3, n)) {
            case 0 -> {
                AbstractMinecart abstractMinecart = (AbstractMinecart)entity3;
                if (AbstractMinecart.useExperimentalMovement(abstractMinecart.level())) {
                    yield new MinecartCollisionContext(abstractMinecart, false);
                }
                yield new EntityCollisionContext(entity, false, false);
            }
            default -> new EntityCollisionContext(entity, false, false);
        };
    }

    public static CollisionContext of(Entity entity, boolean canStandOnFluid) {
        return new EntityCollisionContext(entity, canStandOnFluid, false);
    }

    public static CollisionContext placementContext(@Nullable Entity entity) {
        Predicate<FluidState> predicate;
        ItemStack itemStack;
        boolean bl = entity != null && entity.isDescending();
        double d = entity != null ? entity.getY() : -1.7976931348623157E308;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntityx = (LivingEntity)entity;
            itemStack = livingEntityx.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            predicate = fluidState -> livingEntity.canStandOnFluid((FluidState)fluidState);
        } else {
            predicate = fluidState -> false;
        }
        return new EntityCollisionContext(bl, true, d, itemStack, predicate, entity);
    }

    public boolean isDescending();

    public boolean isAbove(VoxelShape var1, BlockPos var2, boolean var3);

    public boolean isHoldingItem(Item var1);

    public boolean canStandOnFluid(FluidState var1, FluidState var2);

    public VoxelShape getCollisionShape(BlockState var1, CollisionGetter var2, BlockPos var3);

    default public boolean isPlacement() {
        return false;
    }
}

