/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.world.scores.ReadOnlyScoreInfo;

public class Score
implements ReadOnlyScoreInfo {
    public static final MapCodec<Score> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("Score", (Object)0).forGetter(Score::value), (App)Codec.BOOL.optionalFieldOf("Locked", (Object)false).forGetter(Score::isLocked), (App)ComponentSerialization.CODEC.optionalFieldOf("display").forGetter(score -> Optional.ofNullable(score.display)), (App)NumberFormatTypes.CODEC.optionalFieldOf("format").forGetter(score -> Optional.ofNullable(score.numberFormat))).apply((Applicative)instance, Score::new));
    private int value;
    private boolean locked = true;
    @Nullable
    private Component display;
    @Nullable
    private NumberFormat numberFormat;

    public Score() {
    }

    private Score(int value, boolean locked, Optional<Component> display, Optional<NumberFormat> numberFormat) {
        this.value = value;
        this.locked = locked;
        this.display = display.orElse(null);
        this.numberFormat = numberFormat.orElse(null);
    }

    @Override
    public int value() {
        return this.value;
    }

    public void value(int value) {
        this.value = value;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Nullable
    public Component display() {
        return this.display;
    }

    public void display(@Nullable Component display) {
        this.display = display;
    }

    @Override
    @Nullable
    public NumberFormat numberFormat() {
        return this.numberFormat;
    }

    public void numberFormat(@Nullable NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }
}

