/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class ScoreboardSaveData
extends SavedData {
    public static final String FILE_ID = "scoreboard";
    private final Scoreboard scoreboard;

    public ScoreboardSaveData(Scoreboard scoreboard) {
        this.scoreboard = scoreboard;
    }

    public void loadFrom(Packed packed) {
        packed.objectives().forEach(this.scoreboard::loadObjective);
        packed.scores().forEach(this.scoreboard::loadPlayerScore);
        packed.displaySlots().forEach((slot, objective) -> {
            Objective objective1 = this.scoreboard.getObjective((String)objective);
            this.scoreboard.setDisplayObjective((DisplaySlot)slot, objective1);
        });
        packed.teams().forEach(this.scoreboard::loadPlayerTeam);
    }

    public Packed pack() {
        EnumMap<DisplaySlot, String> map = new EnumMap<DisplaySlot, String>(DisplaySlot.class);
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            Objective displayObjective = this.scoreboard.getDisplayObjective(displaySlot);
            if (displayObjective == null) continue;
            map.put(displaySlot, displayObjective.getName());
        }
        return new Packed(this.scoreboard.getObjectives().stream().map(Objective::pack).toList(), this.scoreboard.packPlayerScores(), map, this.scoreboard.getPlayerTeams().stream().filter(p -> GlobalConfiguration.get().scoreboards.saveEmptyScoreboardTeams || !p.getPlayers().isEmpty()).map(PlayerTeam::pack).toList());
    }

    public record Packed(List<Objective.Packed> objectives, List<Scoreboard.PackedScore> scores, Map<DisplaySlot, String> displaySlots, List<PlayerTeam.Packed> teams) {
        public static final Codec<Packed> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Objective.Packed.CODEC.listOf().optionalFieldOf("Objectives", List.of()).forGetter(Packed::objectives), (App)Scoreboard.PackedScore.CODEC.listOf().optionalFieldOf("PlayerScores", List.of()).forGetter(Packed::scores), (App)Codec.unboundedMap(DisplaySlot.CODEC, (Codec)Codec.STRING).optionalFieldOf("DisplaySlots", Map.of()).forGetter(Packed::displaySlots), (App)PlayerTeam.Packed.CODEC.listOf().optionalFieldOf("Teams", List.of()).forGetter(Packed::teams)).apply((Applicative)instance, Packed::new));
    }
}

