/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.Hash;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.ticks.SavedTick;
import net.minecraft.world.ticks.TickPriority;

public record ScheduledTick<T>(T type, BlockPos pos, long triggerTick, TickPriority priority, long subTickOrder) {
    public static final Comparator<ScheduledTick<?>> DRAIN_ORDER = (scheduledTick, scheduledTick1) -> {
        int i = Long.compare(scheduledTick.triggerTick, scheduledTick1.triggerTick);
        if (i != 0) {
            return i;
        }
        i = scheduledTick.priority.compareTo(scheduledTick1.priority);
        return i != 0 ? i : Long.compare(scheduledTick.subTickOrder, scheduledTick1.subTickOrder);
    };
    public static final Comparator<ScheduledTick<?>> INTRA_TICK_DRAIN_ORDER = (scheduledTick, scheduledTick1) -> {
        int i = scheduledTick.priority.compareTo(scheduledTick1.priority);
        return i != 0 ? i : Long.compare(scheduledTick.subTickOrder, scheduledTick1.subTickOrder);
    };
    public static final Hash.Strategy<ScheduledTick<?>> UNIQUE_TICK_HASH = new Hash.Strategy<ScheduledTick<?>>(){

        public int hashCode(ScheduledTick<?> scheduledTick) {
            return 31 * scheduledTick.pos().hashCode() + scheduledTick.type().hashCode();
        }

        public boolean equals(@Nullable ScheduledTick<?> first, @Nullable ScheduledTick<?> second) {
            return first == second || first != null && second != null && first.type() == second.type() && first.pos().equals(second.pos());
        }
    };

    public ScheduledTick(T type, BlockPos pos, long triggerTick, long subTickOrder) {
        this(type, pos, triggerTick, TickPriority.NORMAL, subTickOrder);
    }

    public ScheduledTick {
        pos = pos.immutable();
    }

    public static <T> ScheduledTick<T> probe(T type, BlockPos pos) {
        return new ScheduledTick<T>(type, pos, 0L, TickPriority.NORMAL, 0L);
    }

    public SavedTick<T> toSavedTick(long gametime) {
        return new SavedTick<T>(this.type, this.pos, (int)(this.triggerTick - gametime), this.priority);
    }
}

